/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.map.forms;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.meteoinfo.geo.layer.LayerTypes;
import org.meteoinfo.geo.layer.MapLayer;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geo.mapview.MapView;
import org.meteoinfo.map.forms.FrmMain;

public class FrmIntersection
extends JDialog {
    List<VectorLayer> _vLayers = new ArrayList<VectorLayer>();
    List<VectorLayer> _polygonLayers = new ArrayList<VectorLayer>();
    private final FrmMain _parent;
    private JButton jButton_Apply;
    private JCheckBox jCheckBox_SelFeatureOnly_Intersection;
    private JCheckBox jCheckBox_SelFeatureOnly_Subject;
    private JComboBox jComboBox_IntersectionLayer;
    private JComboBox jComboBox_SubjectLayer;
    private JLabel jLabel1;
    private JLabel jLabel2;

    public FrmIntersection(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.initComponents();
        this._parent = (FrmMain)parent;
        this.initialize();
    }

    private void initialize() {
        MapView mapView = this._parent.getMapDocument().getActiveMapFrame().getMapView();
        this.jComboBox_SubjectLayer.removeAllItems();
        this.jComboBox_IntersectionLayer.removeAllItems();
        for (int i = 0; i < mapView.getLayerNum(); ++i) {
            MapLayer layer = (MapLayer)mapView.getLayers().get(i);
            if (layer.getLayerType() != LayerTypes.VECTOR_LAYER) continue;
            this._vLayers.add((VectorLayer)layer);
            this.jComboBox_SubjectLayer.addItem(layer.getLayerName());
            if (!layer.getShapeType().isPolygon()) continue;
            this._polygonLayers.add((VectorLayer)layer);
            this.jComboBox_IntersectionLayer.addItem(layer.getLayerName());
        }
        if (this.jComboBox_SubjectLayer.getItemCount() > 0) {
            this.jComboBox_SubjectLayer.setSelectedIndex(0);
        }
        if (this.jComboBox_IntersectionLayer.getItemCount() > 0) {
            this.jComboBox_IntersectionLayer.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jComboBox_SubjectLayer = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jComboBox_IntersectionLayer = new JComboBox();
        this.jCheckBox_SelFeatureOnly_Intersection = new JCheckBox();
        this.jButton_Apply = new JButton();
        this.jCheckBox_SelFeatureOnly_Subject = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Intersection");
        this.jLabel1.setText("Subject layer:");
        this.jComboBox_SubjectLayer.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel2.setText("Intersection layer:");
        this.jComboBox_IntersectionLayer.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_IntersectionLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmIntersection.this.jComboBox_IntersectionLayerActionPerformed(evt);
            }
        });
        this.jCheckBox_SelFeatureOnly_Intersection.setText("Selected features only");
        this.jButton_Apply.setText("Apply");
        this.jButton_Apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmIntersection.this.jButton_ApplyActionPerformed(evt);
            }
        });
        this.jCheckBox_SelFeatureOnly_Subject.setText("Selected features only");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(134, 134, 134).addComponent(this.jButton_Apply, -2, 85, -2).addContainerGap(167, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBox_SubjectLayer, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBox_IntersectionLayer, 0, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox_SelFeatureOnly_Subject).addComponent(this.jLabel1).addComponent(this.jCheckBox_SelFeatureOnly_Intersection).addComponent(this.jLabel2)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_SubjectLayer, -2, -1, -2).addGap(6, 6, 6).addComponent(this.jCheckBox_SelFeatureOnly_Subject).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_IntersectionLayer, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox_SelFeatureOnly_Intersection).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 12, Short.MAX_VALUE).addComponent(this.jButton_Apply).addContainerGap()));
        this.pack();
    }

    private void jButton_ApplyActionPerformed(ActionEvent evt) {
        if (this.jComboBox_SubjectLayer.getSelectedItem().toString().equals(this.jComboBox_IntersectionLayer.getSelectedItem().toString())) {
            JOptionPane.showMessageDialog(null, "The two layers are same!");
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        VectorLayer fromLayer = this._vLayers.get(this.jComboBox_SubjectLayer.getSelectedIndex());
        VectorLayer clipLayer = this._polygonLayers.get(this.jComboBox_IntersectionLayer.getSelectedIndex());
        boolean onlySel = this.jCheckBox_SelFeatureOnly_Intersection.isSelected();
        VectorLayer newLayer = fromLayer.clip(clipLayer, onlySel);
        newLayer.setLayerName("Intersection_" + newLayer.getLayerName());
        this._parent.getMapDocument().getActiveMapFrame().addLayer((MapLayer)newLayer);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jComboBox_IntersectionLayerActionPerformed(ActionEvent evt) {
        if (this.jComboBox_IntersectionLayer.getItemCount() > 0) {
            VectorLayer aLayer = this._polygonLayers.get(this.jComboBox_IntersectionLayer.getSelectedIndex());
            List selIndexes = aLayer.getSelectedShapeIndexes();
            if (selIndexes.size() > 0) {
                this.jCheckBox_SelFeatureOnly_Intersection.setEnabled(true);
                this.jCheckBox_SelFeatureOnly_Intersection.setText("Selected features only (" + String.valueOf(selIndexes.size()) + " features selected)");
            } else {
                this.jCheckBox_SelFeatureOnly_Intersection.setEnabled(false);
                this.jCheckBox_SelFeatureOnly_Intersection.setSelected(false);
                this.jCheckBox_SelFeatureOnly_Intersection.setText("Selected features only");
            }
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmIntersection.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmIntersection.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmIntersection.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmIntersection.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmIntersection dialog = new FrmIntersection(new FrmMain(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

