/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import java.io.IOException;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.grib.GribNumbers;
import ucar.nc2.grib.grib2.Grib2Drs;
import ucar.unidata.io.RandomAccessFile;

@Immutable
public class Grib2SectionDataRepresentation {
    private final long startingPosition;
    private final int dataPoints;
    private final int dataTemplate;
    private final int length;

    public Grib2SectionDataRepresentation(RandomAccessFile raf) throws IOException {
        this.startingPosition = raf.getFilePointer();
        this.length = GribNumbers.int4(raf);
        if (this.length == 0) {
            throw new IllegalArgumentException("Not a GRIB-2 Data representation section");
        }
        int section = raf.read();
        if (section != 5) {
            throw new IllegalArgumentException("Not a GRIB-2 Data representation section");
        }
        this.dataPoints = GribNumbers.int4(raf);
        int dt = GribNumbers.uint2(raf);
        this.dataTemplate = dt == 40000 ? 40 : dt;
        raf.seek(this.startingPosition + (long)this.length);
    }

    public Grib2SectionDataRepresentation(long startingPosition, int dataPoints, int dataTemplate) {
        this.startingPosition = startingPosition;
        this.dataPoints = dataPoints;
        this.dataTemplate = dataTemplate;
        this.length = 0;
    }

    public int getDataPoints() {
        return this.dataPoints;
    }

    public int getDataTemplate() {
        return this.dataTemplate;
    }

    public long getStartingPosition() {
        return this.startingPosition;
    }

    public long getLength(RandomAccessFile raf) throws IOException {
        if (this.length == 0) {
            raf.seek(this.startingPosition);
            return GribNumbers.int4(raf);
        }
        return this.length;
    }

    public Grib2Drs getDrs(RandomAccessFile raf) throws IOException {
        raf.seek(this.startingPosition + 11L);
        return Grib2Drs.factory(this.dataTemplate, raf);
    }

    public String toString() {
        return "Grib2SectionDataRepresentation{startingPosition=" + this.startingPosition + ", dataPoints=" + this.dataPoints + ", dataTemplate=" + this.dataTemplate + ", length=" + this.length + '}';
    }
}

