/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.transform;

import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.Complex;
import org.meteoinfo.ndarray.DataType;

public class FFT {
    public static Complex[] fft(Complex[] x) {
        int N = x.length;
        if (N == 1) {
            return new Complex[]{x[0]};
        }
        if (N % 2 != 0) {
            throw new RuntimeException("N is not a power of 2");
        }
        Complex[] even = new Complex[N / 2];
        for (int k = 0; k < N / 2; ++k) {
            even[k] = x[2 * k];
        }
        Complex[] q = FFT.fft(even);
        Complex[] odd = even;
        for (int k = 0; k < N / 2; ++k) {
            odd[k] = x[2 * k + 1];
        }
        Complex[] r = FFT.fft(odd);
        Complex[] y = new Complex[N];
        for (int k = 0; k < N / 2; ++k) {
            double kth = (double)(-2 * k) * Math.PI / (double)N;
            Complex wk = new Complex(Math.cos(kth), Math.sin(kth));
            y[k] = q[k].add(wk.multiply(r[k]));
            y[k + N / 2] = q[k].subtract(wk.multiply(r[k]));
        }
        return y;
    }

    public static Array fft(Array x) {
        int N = (int)(x = x.copyIfView()).getSize();
        if (N == 1) {
            return x.copy();
        }
        if (N % 2 != 0) {
            throw new RuntimeException("N is not a power of 2");
        }
        Complex[] even = new Complex[N / 2];
        for (int k = 0; k < N / 2; ++k) {
            even[k] = x.getComplex(2 * k);
        }
        Complex[] q = FFT.fft(even);
        Complex[] odd = even;
        for (int k = 0; k < N / 2; ++k) {
            odd[k] = x.getComplex(2 * k + 1);
        }
        Complex[] r = FFT.fft(odd);
        Array y = Array.factory((DataType)DataType.COMPLEX, (int[])new int[]{N});
        for (int k = 0; k < N / 2; ++k) {
            double kth = (double)(-2 * k) * Math.PI / (double)N;
            Complex wk = new Complex(Math.cos(kth), Math.sin(kth));
            y.setComplex(k, q[k].add(wk.multiply(r[k])));
            y.setComplex(k + N / 2, q[k].subtract(wk.multiply(r[k])));
        }
        return y;
    }

    public static Complex[] ifft(Complex[] x) {
        int i;
        int N = x.length;
        Complex[] y = new Complex[N];
        for (i = 0; i < N; ++i) {
            y[i] = x[i].conj();
        }
        y = FFT.fft(y);
        for (i = 0; i < N; ++i) {
            y[i] = y[i].conj();
        }
        for (i = 0; i < N; ++i) {
            y[i] = y[i].multiply(1.0 / (double)N);
        }
        return y;
    }

    public static Array ifft(Array x) {
        int i;
        x = x.copyIfView();
        int N = (int)x.getSize();
        Array y = Array.factory((DataType)DataType.COMPLEX, (int[])new int[]{N});
        for (i = 0; i < N; ++i) {
            y.setComplex(i, x.getComplex(i).conj());
        }
        y = FFT.fft(y);
        for (i = 0; i < N; ++i) {
            y.setComplex(i, y.getComplex(i).conj());
        }
        for (i = 0; i < N; ++i) {
            y.setComplex(i, y.getComplex(i).multiply(1.0 / (double)N));
        }
        return y;
    }

    public static Complex[] cConvolve(Complex[] x, Complex[] y) {
        if (x.length != y.length) {
            throw new RuntimeException("Dimensions don't agree");
        }
        int N = x.length;
        Complex[] a = FFT.fft(x);
        Complex[] b = FFT.fft(y);
        Complex[] c = new Complex[N];
        for (int i = 0; i < N; ++i) {
            c[i] = a[i].multiply(b[i]);
        }
        return FFT.ifft(c);
    }

    public static Complex[] convolve(Complex[] x, Complex[] y) {
        int i;
        int i2;
        Complex ZERO = new Complex(0.0, 0.0);
        Complex[] a = new Complex[2 * x.length];
        for (i2 = 0; i2 < x.length; ++i2) {
            a[i2] = x[i2];
        }
        for (i2 = x.length; i2 < 2 * x.length; ++i2) {
            a[i2] = ZERO;
        }
        Complex[] b = new Complex[2 * y.length];
        for (i = 0; i < y.length; ++i) {
            b[i] = y[i];
        }
        for (i = y.length; i < 2 * y.length; ++i) {
            b[i] = ZERO;
        }
        return FFT.cConvolve(a, b);
    }

    public static void show(Complex[] x, String title) {
        System.out.println(title);
        System.out.println("-------------------");
        for (int i = 0; i < x.length; ++i) {
            System.out.println(x[i]);
        }
        System.out.println();
    }

    public static Complex[] toComplex(double[] SZ) {
        int count = SZ.length;
        Complex[] C_SZ = new Complex[count];
        for (int i = 0; i < count; ++i) {
            Complex d;
            C_SZ[i] = d = new Complex(SZ[i], 0.0);
        }
        return C_SZ;
    }
}

