/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.optimize;

import org.apache.commons.math4.legacy.analysis.ParametricUnivariateFunction;
import org.apache.commons.math4.legacy.analysis.UnivariateFunction;
import org.apache.commons.math4.legacy.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math4.legacy.analysis.differentiation.FiniteDifferencesDifferentiator;
import org.apache.commons.math4.legacy.analysis.differentiation.UnivariateDifferentiableFunction;
import org.meteoinfo.math.optimize.ParamUnivariateFunction;

public class MyParametricUnivariateFunction
implements ParametricUnivariateFunction {
    private ParamUnivariateFunction function;
    private int nbPoints;
    private double stepSize;
    double EPSILON = 1.0E-8;
    boolean useDerivativeStructure;

    public MyParametricUnivariateFunction(ParamUnivariateFunction function, int nbPoints, double stepSize) {
        this(function, nbPoints, stepSize, true);
    }

    public MyParametricUnivariateFunction(ParamUnivariateFunction function, int nbPoints, double stepSize, boolean useDerivativeStructure) {
        this.function = function;
        this.nbPoints = nbPoints;
        this.stepSize = stepSize;
        this.useDerivativeStructure = useDerivativeStructure;
    }

    public boolean isUseDerivativeStructure() {
        return this.useDerivativeStructure;
    }

    public void setUseDerivativeStructure(boolean value) {
        this.useDerivativeStructure = value;
    }

    public double value(double v, double ... parameters) {
        this.function.setParameters(parameters);
        double y = Double.POSITIVE_INFINITY;
        try {
            y = this.function.value(v);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return y;
    }

    public double[] gradient(double x, double ... parameters) {
        if (this.useDerivativeStructure) {
            return this.gradientDerivativeStructure(x, parameters);
        }
        return this.gradientSimple(x, parameters);
    }

    public double[] gradientSimple(double x, double ... parameters) {
        this.function.setParameters(parameters);
        double fx = this.function.value(x);
        int n = parameters.length;
        double[] gradients = new double[n];
        for (int i = 0; i < n; ++i) {
            gradients[i] = Double.POSITIVE_INFINITY;
        }
        double[] xh = new double[n];
        for (int i = 0; i < n; ++i) {
            System.arraycopy(parameters, 0, xh, 0, n);
            double xi = parameters[i];
            double h = this.EPSILON * Math.abs(xi);
            if (h == 0.0) {
                h = this.EPSILON;
            }
            xh[i] = xi + h;
            h = xh[i] - xi;
            this.function.setParameters(xh);
            double fh = this.function.value(x);
            xh[i] = xi;
            gradients[i] = (fh - fx) / h;
        }
        this.function.setParameters(parameters);
        return gradients;
    }

    public double[] gradientDerivativeStructure(double x, double ... parameters) {
        this.function.setParameters(parameters);
        double fx = this.function.value(x);
        int n = parameters.length;
        double[] gradients = new double[n];
        for (int i = 0; i < n; ++i) {
            gradients[i] = Double.POSITIVE_INFINITY;
        }
        FiniteDifferencesDifferentiator differentiator = new FiniteDifferencesDifferentiator(5, 0.01);
        for (int i = 0; i < n; ++i) {
            MyUnivariateFunction uf = new MyUnivariateFunction(this.function, x, i, parameters);
            UnivariateDifferentiableFunction f = differentiator.differentiate((UnivariateFunction)uf);
            DerivativeStructure y = f.value(new DerivativeStructure(1, 1, 0, parameters[i]));
            gradients[i] = y.getPartialDerivative(new int[]{1});
        }
        this.function.setParameters(parameters);
        return gradients;
    }

    private class MyUnivariateFunction
    implements UnivariateFunction {
        private ParamUnivariateFunction function;
        private double x;
        private int paraIdx;
        private int paraNum;
        private double[] parameters;

        public MyUnivariateFunction(ParamUnivariateFunction function, double x, int paraIdx, double ... parameters) {
            this.function = function;
            this.x = x;
            this.paraIdx = paraIdx;
            this.parameters = parameters;
            this.paraNum = parameters.length;
        }

        public double value(double v) {
            double[] params = new double[this.paraNum];
            System.arraycopy(this.parameters, 0, params, 0, this.paraNum);
            params[this.paraIdx] = v;
            this.function.setParameters(params);
            return this.function.value(this.x);
        }
    }
}

