/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.distance;

import java.util.function.ToDoubleBiFunction;
import org.meteoinfo.math.MathEx;
import org.meteoinfo.math.distance.Distance;

public class CorrelationDistance
implements Distance<double[]> {
    private static final long serialVersionUID = 1L;
    private String method;
    private ToDoubleBiFunction<double[], double[]> cor;

    public CorrelationDistance() {
        this("pearson");
    }

    public CorrelationDistance(String method) {
        switch (this.method = method.trim().toLowerCase()) {
            case "pearson": {
                this.cor = (x, y) -> 1.0 - MathEx.cor(x, y);
                break;
            }
            case "spearman": {
                this.cor = (x, y) -> 1.0 - MathEx.spearman(x, y);
                break;
            }
            case "kendall": {
                this.cor = (x, y) -> 1.0 - MathEx.kendall(x, y);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid correlation: " + method);
            }
        }
    }

    public String toString() {
        return String.format("Correlation Distance(%s)", this.method);
    }

    @Override
    public double d(double[] x, double[] y) {
        return this.cor.applyAsDouble(x, y);
    }
}

