/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.iosp.bufr.BufrDataDescriptionSection;
import ucar.nc2.iosp.bufr.BufrDataSection;
import ucar.nc2.iosp.bufr.BufrIdentificationSection;
import ucar.nc2.iosp.bufr.BufrIndicatorSection;
import ucar.nc2.iosp.bufr.BufrNumbers;
import ucar.nc2.iosp.bufr.EmbeddedTable;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.TableLookup;
import ucar.unidata.io.KMPMatch;
import ucar.unidata.io.RandomAccessFile;

public class MessageScanner {
    private static Logger log = LoggerFactory.getLogger(MessageScanner.class);
    private static final KMPMatch matcher = new KMPMatch("BUFR".getBytes(StandardCharsets.UTF_8));
    private RandomAccessFile raf;
    private boolean useEmbeddedTables;
    private int countMsgs;
    private int countObs;
    private byte[] header;
    private long startPos;
    private long lastPos;
    private boolean debug;
    private EmbeddedTable embedTable;

    public static boolean isValidFile(RandomAccessFile raf) throws IOException {
        raf.seek(0L);
        if (!raf.searchForward(matcher, 40000)) {
            return false;
        }
        raf.skipBytes(4);
        BufrIndicatorSection is = new BufrIndicatorSection(raf);
        if (is.getBufrEdition() > 4) {
            return false;
        }
        return (long)is.getBufrLength() <= raf.length();
    }

    public MessageScanner(RandomAccessFile raf) throws IOException {
        this(raf, 0L, true);
    }

    public MessageScanner(RandomAccessFile raf, long startPos, boolean useEmbeddedTables) throws IOException {
        startPos = startPos < 30L ? 0L : startPos - 30L;
        this.raf = raf;
        this.lastPos = startPos;
        this.useEmbeddedTables = useEmbeddedTables;
        raf.seek(startPos);
        raf.order(0);
    }

    public Message getFirstDataMessage() throws IOException {
        while (this.hasNext()) {
            Message m = this.next();
            if (m == null || m.containsBufrTable() || m.getNumberDatasets() == 0) continue;
            return m;
        }
        return null;
    }

    public void reset() {
        this.lastPos = 0L;
    }

    public boolean hasNext() throws IOException {
        if (this.lastPos >= this.raf.length()) {
            return false;
        }
        this.raf.seek(this.lastPos);
        boolean more = this.raf.searchForward(matcher, -1);
        if (more) {
            long stop = this.raf.getFilePointer();
            int sizeHeader = (int)(stop - this.lastPos);
            if (sizeHeader > 30) {
                sizeHeader = 30;
            }
            this.header = new byte[sizeHeader];
            this.startPos = stop - (long)sizeHeader;
            this.raf.seek(this.startPos);
            int nRead = this.raf.read(this.header);
            if (nRead != this.header.length) {
                log.warn("Unable to read full BUFR header. Got " + nRead + " but expected " + this.header.length);
                return false;
            }
        }
        if (this.debug && this.countMsgs % 100 == 0) {
            System.out.printf("%d ", this.countMsgs);
        }
        return more;
    }

    public Message next() {
        try {
            long start = this.raf.getFilePointer();
            this.raf.seek(start + 4L);
            BufrIndicatorSection is = new BufrIndicatorSection(this.raf);
            BufrIdentificationSection ids = new BufrIdentificationSection(this.raf, is);
            BufrDataDescriptionSection dds = new BufrDataDescriptionSection(this.raf);
            long dataPos = this.raf.getFilePointer();
            int dataLength = BufrNumbers.uint3(this.raf);
            BufrDataSection dataSection = new BufrDataSection(dataPos, dataLength);
            this.lastPos = dataPos + (long)dataLength + 4L;
            if (is.getBufrEdition() > 4) {
                log.warn("Illegal edition - BUFR message at pos " + start + " header= " + MessageScanner.cleanup(this.header));
                return null;
            }
            if (is.getBufrEdition() < 2) {
                log.warn("Edition " + is.getBufrEdition() + " is not supported - BUFR message at pos " + start + " header= " + MessageScanner.cleanup(this.header));
                return null;
            }
            long ending = dataPos + (long)dataLength;
            this.raf.seek(dataPos + (long)dataLength);
            for (int i = 0; i < 3; ++i) {
                if (this.raf.read() == 55) continue;
                log.warn("Missing End of BUFR message at pos= {} header= {} file= {}", new Object[]{ending, MessageScanner.cleanup(this.header), this.raf.getLocation()});
                return null;
            }
            if (this.raf.read() != 55) {
                this.raf.seek(dataPos + (long)dataLength - 1L);
                if (this.raf.read() != 55) {
                    log.warn("Missing End of BUFR message at pos= {} header= {} edition={} file= {}", new Object[]{ending, MessageScanner.cleanup(this.header), is.getBufrEdition(), this.raf.getLocation()});
                    return null;
                }
                log.info("End of BUFR message off-by-one at pos= {} header= {} edition={} file= {}", new Object[]{ending, MessageScanner.cleanup(this.header), is.getBufrEdition(), this.raf.getLocation()});
                --this.lastPos;
            }
            Message m = new Message(this.raf, is, ids, dds, dataSection);
            m.setHeader(MessageScanner.cleanup(this.header));
            m.setStartPos(start);
            if (this.useEmbeddedTables && m.containsBufrTable()) {
                if (this.embedTable == null) {
                    this.embedTable = new EmbeddedTable(m, this.raf);
                }
                this.embedTable.addTable(m);
            } else if (this.embedTable != null) {
                m.setTableLookup(this.embedTable.getTableLookup());
            }
            ++this.countMsgs;
            this.countObs += dds.getNumberDatasets();
            this.raf.seek(start + (long)is.getBufrLength());
            return m;
        }
        catch (IOException ioe) {
            log.error("Error reading message at " + this.lastPos, (Throwable)ioe);
            this.lastPos = this.raf.getFilePointer();
            return null;
        }
    }

    public TableLookup getTableLookup() throws IOException {
        while (this.hasNext()) {
            this.next();
        }
        return this.embedTable != null ? this.embedTable.getTableLookup() : null;
    }

    public byte[] getMessageBytesFromLast(Message m) throws IOException {
        long startPos = m.getStartPos();
        int length = (int)(this.lastPos - startPos);
        byte[] result = new byte[length];
        this.raf.seek(startPos);
        this.raf.readFully(result);
        return result;
    }

    public byte[] getMessageBytes(Message m) throws IOException {
        long startPos = m.getStartPos();
        int length = m.is.getBufrLength();
        byte[] result = new byte[length];
        this.raf.seek(startPos);
        this.raf.readFully(result);
        return result;
    }

    public int getTotalObs() {
        return this.countObs;
    }

    public int getTotalMessages() {
        return this.countMsgs;
    }

    private static String cleanup(byte[] h) {
        byte[] bb = new byte[h.length];
        int count = 0;
        for (byte b : h) {
            if (b < 32 || b >= 127) continue;
            bb[count++] = b;
        }
        return new String(bb, 0, count, StandardCharsets.UTF_8);
    }

    public long writeCurrentMessage(WritableByteChannel out) throws IOException {
        long nbytes = this.lastPos - this.startPos;
        return this.raf.readToByteChannel(out, this.startPos, nbytes);
    }
}

