/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.radar;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.meteoinfo.common.DataConvert;
import org.meteoinfo.data.dimarray.Dimension;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.radar.BaseRadarDataInfo;
import org.meteoinfo.data.meteodata.radar.CutConfig;
import org.meteoinfo.data.meteodata.radar.GenericHeader;
import org.meteoinfo.data.meteodata.radar.IRadarDataInfo;
import org.meteoinfo.data.meteodata.radar.MomentHeader;
import org.meteoinfo.data.meteodata.radar.RadarDataType;
import org.meteoinfo.data.meteodata.radar.RadialHeader;
import org.meteoinfo.data.meteodata.radar.RadialRecord;
import org.meteoinfo.data.meteodata.radar.SiteConfig;
import org.meteoinfo.data.meteodata.radar.TaskConfig;
import org.meteoinfo.ndarray.math.ArrayUtil;

public class StandardRadarDataInfo
extends BaseRadarDataInfo
implements IRadarDataInfo {
    private GenericHeader genericHeader;
    private SiteConfig siteConfig;
    private TaskConfig taskConfig;
    private List<CutConfig> cutConfigs;
    private List<RadialHeader> radialHeaders;

    public StandardRadarDataInfo() {
        this.meteoDataType = MeteoDataType.RADAR;
    }

    @Override
    public RadarDataType getRadarDataType() {
        return RadarDataType.STANDARD;
    }

    public GenericHeader getGenericHeader() {
        return this.genericHeader;
    }

    public SiteConfig getSiteConfig() {
        return this.siteConfig;
    }

    public TaskConfig getTaskConfig() {
        return this.taskConfig;
    }

    public List<CutConfig> getCutConfigs() {
        return this.cutConfigs;
    }

    public List<RadialHeader> getRadialHeaders() {
        return this.radialHeaders;
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) {
        try {
            raf.seek(0L);
            byte[] bytes = new byte[4];
            raf.read(bytes);
            int magic = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            return magic == 1297371986;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean canOpen(String fileName) {
        try {
            byte[] bytes = new byte[4];
            if (fileName.endsWith("bz2")) {
                BZip2CompressorInputStream inputStream = new BZip2CompressorInputStream(Files.newInputStream(Paths.get(fileName, new String[0]), new OpenOption[0]));
                inputStream.read(bytes);
                inputStream.close();
            } else {
                RandomAccessFile raf = new RandomAccessFile(fileName, "r");
                raf.seek(0L);
                raf.read(bytes);
                raf.close();
            }
            int magic = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            return magic == 1297371986;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    void readDataInfo(InputStream raf) {
        try {
            this.genericHeader = new GenericHeader(raf);
            this.siteConfig = new SiteConfig(raf);
            this.antennaHeight = this.siteConfig.antennaHeight;
            this.beamWidthVert = this.siteConfig.beamWidthVert;
            this.addAttribute(new Attribute("StationCode", this.siteConfig.siteCode));
            this.addAttribute(new Attribute("StationName", this.siteConfig.siteName));
            this.addAttribute(new Attribute("StationLatitude", Float.valueOf(this.siteConfig.latitude)));
            this.addAttribute(new Attribute("StationLongitude", Float.valueOf(this.siteConfig.longitude)));
            this.addAttribute(new Attribute("AntennaHeight", this.siteConfig.antennaHeight));
            this.addAttribute(new Attribute("GroundHeight", this.siteConfig.groundHeight));
            this.addAttribute(new Attribute("RadarType", this.siteConfig.getRadarType()));
            this.addAttribute(new Attribute("featureType", "RADIAL"));
            this.addAttribute(new Attribute("DataType", "Radial"));
            this.addAttribute(new Attribute("RadarDataType", "CMA Standard"));
            this.taskConfig = new TaskConfig(raf);
            this.addAttribute(new Attribute("TaskName", this.taskConfig.taskName));
            this.addAttribute(new Attribute("TaskDescription", this.taskConfig.taskDescription));
            this.cutConfigs = new ArrayList<CutConfig>();
            for (int i = 0; i < this.taskConfig.cutNumber; ++i) {
                CutConfig cutConfig = new CutConfig(raf);
                this.cutConfigs.add(cutConfig);
                if (i != 0) continue;
                this.logResolution = cutConfig.logResolution;
                this.dopplerResolution = cutConfig.dopplerResolution;
            }
            this.radialHeaders = new ArrayList<RadialHeader>();
            byte[] rhBytes = new byte[RadialHeader.length];
            while (raf.read(rhBytes) != -1) {
                RadialHeader radialHeader = new RadialHeader(rhBytes);
                for (int i = 0; i < radialHeader.momentNumber; ++i) {
                    RadialRecord record;
                    MomentHeader momentHeader = new MomentHeader(raf);
                    String product = (String)this.productMap.get(momentHeader.dataType);
                    if (this.recordMap.containsKey(product)) {
                        record = (RadialRecord)this.recordMap.get(product);
                    } else {
                        record = new RadialRecord(product);
                        record.setBinLength(momentHeader.binLength);
                        record.scale = 1.0f / (float)momentHeader.scale;
                        record.offset = (float)(-momentHeader.offset) / (float)momentHeader.scale;
                        this.recordMap.put(product, record);
                    }
                    if (radialHeader.radialNumber == 1) {
                        record.fixedElevation.add(Float.valueOf(this.cutConfigs.get((int)(radialHeader.elevationNumber - 1)).elevation));
                        record.elevation.add(new ArrayList());
                        record.azimuth.add(new ArrayList());
                        record.azimuthMinIndex.add(0);
                        if (this.isVelocityGroup(record)) {
                            record.disResolution.add(Float.valueOf(this.cutConfigs.get((int)(radialHeader.elevationNumber - 1)).dopplerResolution));
                            record.distance.add(ArrayUtil.arrayRange1((Number)0, (int)(momentHeader.dataLength / momentHeader.binLength), (Number)this.cutConfigs.get((int)(radialHeader.elevationNumber - 1)).dopplerResolution));
                        } else {
                            record.disResolution.add(Float.valueOf(this.cutConfigs.get((int)(radialHeader.elevationNumber - 1)).logResolution));
                            record.distance.add(ArrayUtil.arrayRange1((Number)0, (int)(momentHeader.dataLength / momentHeader.binLength), (Number)this.cutConfigs.get((int)(radialHeader.elevationNumber - 1)).logResolution));
                        }
                        record.newScanData();
                    }
                    record.elevation.get(record.elevation.size() - 1).add(Float.valueOf(radialHeader.elevation));
                    record.addAzimuth(radialHeader.azimuth);
                    byte[] bytes = new byte[momentHeader.dataLength];
                    raf.read(bytes);
                    record.addDataBytes(bytes);
                }
                this.radialHeaders.add(radialHeader);
            }
            raf.close();
            RadialRecord refRadialRecord = (RadialRecord)this.recordMap.get("dBZ");
            this.radialDim = new Dimension();
            this.radialDim.setName("radial");
            this.radialDim.setLength(refRadialRecord.getMaxRadials());
            this.addDimension(this.radialDim);
            this.scanDim = new Dimension();
            this.scanDim.setName("scan");
            this.scanDim.setLength(refRadialRecord.getScanNumber());
            this.addDimension(this.scanDim);
            this.gateRDim = new Dimension();
            this.gateRDim.setName("gateR");
            this.gateRDim.setLength(refRadialRecord.getGateNumber(0));
            this.addDimension(this.gateRDim);
            this.makeRefVariables(refRadialRecord);
            RadialRecord velRadialRecord = (RadialRecord)this.recordMap.get("V");
            this.gateVDim = new Dimension();
            this.gateVDim.setName("gateV");
            this.gateVDim.setLength(velRadialRecord.getGateNumber(0));
            this.addDimension(this.gateVDim);
            this.makeVelVariables(velRadialRecord);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Float> getElevations() {
        ArrayList<Float> elevations = new ArrayList<Float>();
        for (CutConfig cutConfig : this.cutConfigs) {
            if (elevations.contains(Float.valueOf(cutConfig.elevation))) continue;
            elevations.add(Float.valueOf(cutConfig.elevation));
        }
        return elevations;
    }
}

