/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data;

import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.ndarray.Array;

public class XYSeriesData {
    private String key;
    private double[] xdata;
    private double[] ydata;
    private double missingValue = -9999.0;

    public XYSeriesData() {
    }

    public XYSeriesData(String key) {
        this.key = key;
    }

    public XYSeriesData(String key, double[] xdata, double[] ydata) {
        this.key = key;
        this.xdata = xdata;
        this.ydata = ydata;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String value) {
        this.key = value;
    }

    public double[] getXdata() {
        return this.xdata;
    }

    public void setXdata(double[] value) {
        this.xdata = value;
    }

    public void setXdata(List<Number> value) {
        this.xdata = new double[value.size()];
        for (int i = 0; i < value.size(); ++i) {
            double v = value.get(i).doubleValue();
            this.xdata[i] = Double.isNaN(v) ? this.missingValue : v;
        }
    }

    public void setXdata(Array value) {
        this.xdata = new double[(int)value.getSize()];
        for (int i = 0; i < this.xdata.length; ++i) {
            double v = value.getDouble(i);
            this.xdata[i] = Double.isNaN(v) ? this.missingValue : v;
        }
    }

    public double[] getYdata() {
        return this.ydata;
    }

    public void setYdata(double[] value) {
        this.ydata = value;
    }

    public void setYdata(List<Number> value) {
        this.ydata = new double[value.size()];
        for (int i = 0; i < value.size(); ++i) {
            double v = value.get(i).doubleValue();
            this.ydata[i] = Double.isNaN(v) ? this.missingValue : v;
        }
    }

    public void setYdata(Array value) {
        this.ydata = new double[(int)value.getSize()];
        for (int i = 0; i < this.ydata.length; ++i) {
            double v = value.getDouble(i);
            this.ydata[i] = Double.isNaN(v) ? this.missingValue : v;
        }
    }

    public double getMissingValue() {
        return this.missingValue;
    }

    public void setMissingValue(double value) {
        this.missingValue = value;
    }

    public int dataLength() {
        return this.xdata.length;
    }

    public double getX(int idx) {
        return this.xdata[idx];
    }

    public double getX_min(int idx) {
        return this.xdata[idx];
    }

    public double getX_max(int idx) {
        return this.xdata[idx];
    }

    public double getY(int idx) {
        return this.ydata[idx];
    }

    public double getY_min(int idx) {
        return this.ydata[idx];
    }

    public double getY_max(int idx) {
        return this.ydata[idx];
    }

    public List<Integer> getMissingValueIndex() {
        ArrayList<Integer> mvidx = new ArrayList<Integer>();
        for (int i = 0; i < this.xdata.length; ++i) {
            if (!MIMath.doubleEquals((double)this.xdata[i], (double)this.missingValue) && !MIMath.doubleEquals((double)this.ydata[i], (double)this.missingValue)) continue;
            mvidx.add(i);
        }
        return mvidx;
    }
}

