/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.types;

public enum MatlabType {
    Cell(1, "cell"),
    Structure(2, "struct"),
    Object(3, "object"),
    Character(4, "char"),
    Sparse(5, "sparse"),
    Double(6, "double"),
    Single(7, "single"),
    Int8(8, "int8"),
    UInt8(9, "uint8"),
    Int16(10, "int16"),
    UInt16(11, "uint16"),
    Int32(12, "int32"),
    UInt32(13, "uint32"),
    Int64(14, "int64"),
    UInt64(15, "uint64"),
    Function(16, "function_handle"),
    Opaque(17, "opaque");

    private final byte id;
    private final String name;
    private static final MatlabType[] lookup;

    public String toString() {
        return this.name;
    }

    public static MatlabType fromId(int id) {
        MatlabType type;
        if (id > 0 && id < lookup.length && (type = lookup[id]) != null) {
            return type;
        }
        throw new IllegalArgumentException("Unknown array type for id: " + id);
    }

    public byte id() {
        return this.id;
    }

    private MatlabType(int id, String name) {
        this.id = (byte)id;
        this.name = name;
    }

    static {
        int highestId = 0;
        for (MatlabType type : MatlabType.values()) {
            highestId = Math.max(highestId, type.id);
        }
        lookup = new MatlabType[highestId + 1];
        MatlabType[] matlabTypeArray = MatlabType.values();
        int n = matlabTypeArray.length;
        for (int i = 0; i < n; ++i) {
            MatlabType type;
            MatlabType.lookup[type.id()] = type = matlabTypeArray[i];
        }
    }
}

