/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.plot;

import java.awt.Color;
import org.meteoinfo.common.colors.ColorUtil;
import org.meteoinfo.geometry.graphic.Artist;
import org.meteoinfo.geometry.legend.LineStyles;
import org.meteoinfo.geometry.legend.PolylineBreak;

public class GridLine
extends Artist {
    protected PolylineBreak lineBreak = new PolylineBreak();
    protected boolean drawXLine;
    protected boolean drawYLine;
    protected boolean drawZLine;
    protected boolean top;

    public GridLine() {
        this(false);
    }

    public GridLine(boolean visible) {
        this.lineBreak.setColor(new Color(0.15f, 0.15f, 0.15f, 0.15f));
        this.lineBreak.setStyle(LineStyles.DASH);
        this.top = false;
        this.drawXLine = visible;
        this.drawYLine = visible;
        this.drawZLine = visible;
    }

    public Color getColor() {
        return this.lineBreak.getColor();
    }

    public void setColor(Color value) {
        int alpha = this.getColor().getAlpha();
        Color color = ColorUtil.getColor((Color)value, (int)alpha);
        this.lineBreak.setColor(color);
    }

    public void setColorAndAlpha(Color value) {
        this.lineBreak.setColor(value);
    }

    public void setAlpha(int value) {
        Color color = ColorUtil.getColor((Color)this.getColor(), (int)value);
        this.lineBreak.setColor(color);
    }

    public void setAlpha(float value) {
        Color color = ColorUtil.getColor((Color)this.getColor(), (float)value);
        this.lineBreak.setColor(color);
    }

    public float getSize() {
        return this.lineBreak.getWidth();
    }

    public void setSize(float value) {
        this.lineBreak.setWidth(value);
    }

    public LineStyles getStyle() {
        return this.lineBreak.getStyle();
    }

    public void setStyle(LineStyles value) {
        this.lineBreak.setStyle(value);
    }

    public boolean isDrawXLine() {
        return this.drawXLine;
    }

    public void setDrawXLine(boolean value) {
        this.drawXLine = value;
    }

    public boolean isDrawYLine() {
        return this.drawYLine;
    }

    public void setDrawYLine(boolean value) {
        this.drawYLine = value;
    }

    public boolean isDrawZLine() {
        return this.drawZLine;
    }

    public void setDrawZLine(boolean value) {
        this.drawZLine = value;
    }

    public boolean isTop() {
        return this.top;
    }

    public void setTop(boolean value) {
        this.top = value;
    }
}

