/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.meteoinfo.chart.ChartElement;
import org.meteoinfo.chart.geo.MapPlot;
import org.meteoinfo.common.PointF;

public class ChartScaleBar
extends ChartElement {
    private MapPlot mapPlot;
    private float lineWidth;
    private Font font;
    private ScaleBarType scaleBarType;
    private ScaleBarUnits unit;
    private String unitText;
    private int numBreaks;
    private boolean drawNeatLine;
    private Color neatLineColor;
    private float neatLineSize;
    private boolean drawScaleText;
    private float yShiftScale = 2.0f;

    public ChartScaleBar(MapPlot mapPlot) {
        this.width = 200.0f;
        this.height = 50.0f;
        this.mapPlot = mapPlot;
        this.antiAlias = true;
        this.scaleBarType = ScaleBarType.SCALE_LINE_1;
        this.lineWidth = 1.0f;
        this.drawNeatLine = false;
        this.neatLineColor = Color.black;
        this.neatLineSize = 1.0f;
        this.font = new Font("Arial", 0, 12);
        this.unit = ScaleBarUnits.KILOMETERS;
        this.unitText = "km";
        this.numBreaks = 4;
        this.drawScaleText = false;
    }

    public MapPlot getMapPlot() {
        return this.mapPlot;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float value) {
        this.lineWidth = value;
    }

    public ScaleBarType getScaleBarType() {
        return this.scaleBarType;
    }

    public void setScaleBarType(ScaleBarType type) {
        this.scaleBarType = type;
    }

    public boolean isDrawNeatLine() {
        return this.drawNeatLine;
    }

    public void setDrawNeatLine(boolean istrue) {
        this.drawNeatLine = istrue;
    }

    public Color getNeatLineColor() {
        return this.neatLineColor;
    }

    public void setNeatLineColor(Color color) {
        this.neatLineColor = color;
    }

    public float getNeatLineSize() {
        return this.neatLineSize;
    }

    public void setNeatLineSize(float size) {
        this.neatLineSize = size;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public int getBreakNumber() {
        return this.numBreaks;
    }

    public void setBreakNumber(int num) {
        this.numBreaks = num;
    }

    public boolean isDrawScaleText() {
        return this.drawScaleText;
    }

    public void setDrawScaleText(boolean istrue) {
        this.drawScaleText = istrue;
    }

    public void draw(Graphics2D g, float x, float y) {
        AffineTransform oldMatrix = g.getTransform();
        g.translate(x, y);
        if (this.antiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.isDrawBackColor()) {
            g.setColor(this.getBackground());
            g.fill(new Rectangle2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight()));
        }
        this.drawScaleBar(g);
        if (this.drawNeatLine) {
            Rectangle2D.Float mapRect = new Rectangle2D.Float(this.neatLineSize - 1.0f, this.neatLineSize - 1.0f, this.getWidth() - this.neatLineSize, this.getHeight() - this.neatLineSize);
            g.setColor(this.neatLineColor);
            g.setStroke(new BasicStroke(this.neatLineSize));
            g.draw(mapRect);
        }
        g.setTransform(oldMatrix);
    }

    public void paintGraphics(Graphics2D g, PointF pageLocation) {
        AffineTransform oldMatrix = g.getTransform();
        PointF aP = this.pageToScreen(this.getX(), this.getY(), pageLocation, 1.0f);
        g.translate(aP.X, aP.Y);
        if (this.antiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.isDrawBackColor()) {
            g.setColor(this.getBackground());
            g.fill(new Rectangle2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight()));
        }
        this.drawScaleBar(g);
        if (this.drawNeatLine) {
            Rectangle2D.Float mapRect = new Rectangle2D.Float(this.neatLineSize - 1.0f, this.neatLineSize - 1.0f, this.getWidth() - this.neatLineSize, this.getHeight() - this.neatLineSize);
            g.setColor(this.neatLineColor);
            g.setStroke(new BasicStroke(this.neatLineSize));
            g.draw(mapRect);
        }
        g.setTransform(oldMatrix);
    }

    private void drawScaleBar(Graphics2D g) {
        FontMetrics metrics = g.getFontMetrics(this.font);
        float unitLength = metrics.stringWidth(this.unitText) * 2;
        float widthNoUnit = this.getWidth() - unitLength;
        long geoBreakWidth = (long)this.getGeoWidth(widthNoUnit / (float)this.numBreaks);
        if (geoBreakWidth < 1L) {
            return;
        }
        double n = Math.pow(10.0, String.valueOf(geoBreakWidth).length() - 1);
        geoBreakWidth = (long)(Math.floor((double)geoBreakWidth / n) * n);
        long breakWidth = (long)this.getWidth(geoBreakWidth);
        FontMetrics metrics1 = g.getFontMetrics(this.font);
        float fontHeight = metrics1.getHeight();
        float leftStart = (float)metrics1.stringWidth(String.valueOf(Math.abs(geoBreakWidth))) / 2.0f;
        double scale = (double)geoBreakWidth * this.getConversionFactor(this.unit) * 100.0 / ((double)(breakWidth / 96L) * 2.539999918);
        if (this.drawScaleText) {
            g.setFont(this.font);
            g.setColor(this.getForeground());
            g.drawString("1 : " + String.format("{0:0,0}", scale), leftStart - (float)(metrics.stringWidth(String.valueOf(Math.abs(0))) / 2), fontHeight * 2.5f);
        }
        switch (this.scaleBarType) {
            case SCALE_LINE_1: {
                this.drawScaleLine1(g, breakWidth, geoBreakWidth);
                break;
            }
            case SCALE_LINE_2: {
                this.drawScaleLine2(g, breakWidth, geoBreakWidth);
                break;
            }
            case ALTERNATING_BAR: {
                this.drawAlternatingBar(g, breakWidth, geoBreakWidth);
            }
        }
    }

    private double getConversionFactor(ScaleBarUnits unit) {
        switch (unit) {
            case KILOMETERS: {
                return 1000.0;
            }
        }
        return 1.0;
    }

    private double getGeoWidth(double width) {
        double geoWidth = width / this.mapPlot.getXScale() / this.getConversionFactor(this.unit);
        if (this.mapPlot.isLonLatMap()) {
            geoWidth *= this.getLonDistScale();
        }
        return geoWidth;
    }

    private double getWidth(double geoWidth) {
        double width = geoWidth * this.mapPlot.getXScale() * this.getConversionFactor(this.unit);
        if (this.mapPlot.isLonLatMap()) {
            width /= this.getLonDistScale();
        }
        return width;
    }

    private double getLonDistScale() {
        double pY = (this.mapPlot.getDrawExtent().maxY + this.mapPlot.getDrawExtent().minY) / 2.0;
        double ProjX = 0.0;
        double ProjY = pY;
        double pProjX = 1.0;
        double pProjY = pY;
        double dx = Math.abs(ProjX - pProjX);
        double dy = Math.abs(ProjY - pProjY);
        double y = (ProjY + pProjY) / 2.0;
        double factor = Math.cos(y * Math.PI / 180.0);
        double dist = Math.sqrt((dx *= factor) * dx + dy * dy);
        return dist *= 111319.5;
    }

    private void drawScaleLine1(Graphics2D g, long breakWidth, long geoBreakWidth) {
        FontMetrics metrics = g.getFontMetrics(this.font);
        float fontHeight = metrics.getHeight();
        float leftStart = (float)metrics.stringWidth(String.valueOf(Math.abs(geoBreakWidth))) / 2.0f;
        int yShift = 10;
        g.setColor(this.getForeground());
        g.setStroke(new BasicStroke(this.lineWidth));
        g.draw(new Line2D.Float(leftStart, fontHeight * 1.6f + (float)yShift, leftStart + (float)(breakWidth * (long)this.numBreaks), fontHeight * 1.6f + (float)yShift));
        g.setFont(this.font);
        for (int i = 0; i <= this.numBreaks; ++i) {
            g.draw(new Line2D.Float(leftStart, fontHeight * 1.1f + (float)yShift, leftStart, fontHeight * 1.6f + (float)yShift));
            g.drawString(String.valueOf(Math.abs(geoBreakWidth * (long)i)), leftStart - (float)(metrics.stringWidth(String.valueOf(Math.abs(geoBreakWidth * (long)i))) / 2), (float)yShift * this.yShiftScale);
            leftStart += (float)breakWidth;
        }
        g.drawString(this.unitText, leftStart - (float)breakWidth + fontHeight / 2.0f, fontHeight * 1.1f + (float)yShift * this.yShiftScale);
    }

    private void drawScaleLine2(Graphics2D g, long breakWidth, long geoBreakWidth) {
        FontMetrics metrics = g.getFontMetrics(this.font);
        float fontHeight = metrics.getHeight();
        float leftStart = (float)metrics.stringWidth(String.valueOf(Math.abs(geoBreakWidth))) / 2.0f;
        int yShift = 5;
        g.setColor(this.getForeground());
        g.setStroke(new BasicStroke(this.lineWidth));
        g.draw(new Line2D.Float(leftStart, fontHeight * 1.6f + (float)yShift, leftStart + (float)(breakWidth * (long)this.numBreaks), fontHeight * 1.6f + (float)yShift));
        g.setFont(this.font);
        for (int i = 0; i <= this.numBreaks; ++i) {
            g.draw(new Line2D.Float(leftStart, fontHeight * 1.1f + (float)yShift, leftStart, fontHeight + fontHeight * 1.1f + (float)yShift));
            g.drawString(String.valueOf(Math.abs(geoBreakWidth * (long)i)), leftStart - (float)(metrics.stringWidth(String.valueOf(Math.abs(geoBreakWidth * (long)i))) / 2), (float)yShift * this.yShiftScale);
            leftStart += (float)breakWidth;
        }
        g.drawString(this.unitText, leftStart - (float)breakWidth + fontHeight / 2.0f, fontHeight * 1.1f + (float)yShift * this.yShiftScale);
    }

    private void drawAlternatingBar(Graphics2D g, long breakWidth, long geoBreakWidth) {
        FontMetrics metrics = g.getFontMetrics(this.font);
        float fontHeight = metrics.getHeight();
        float leftStart = (float)metrics.stringWidth(String.valueOf(Math.abs(geoBreakWidth))) / 2.0f;
        int yShift = 5;
        float rHeight = fontHeight / 2.0f;
        boolean isFill = false;
        g.setStroke(new BasicStroke(this.lineWidth));
        g.setColor(this.getForeground());
        g.setFont(this.font);
        for (int i = 0; i <= this.numBreaks; ++i) {
            if (i < this.numBreaks) {
                if (isFill) {
                    g.fill(new Rectangle2D.Float(leftStart, fontHeight * 1.1f + (float)yShift, breakWidth, rHeight));
                }
                g.draw(new Rectangle2D.Float(leftStart, fontHeight * 1.1f + (float)yShift, breakWidth, rHeight));
            }
            g.drawString(String.valueOf(Math.abs(geoBreakWidth * (long)i)), leftStart - (float)(metrics.stringWidth(String.valueOf(Math.abs(geoBreakWidth * (long)i))) / 2), (float)yShift * this.yShiftScale);
            leftStart += (float)breakWidth;
            isFill = !isFill;
        }
        g.setColor(this.getForeground());
        g.drawString(this.unitText, leftStart - (float)breakWidth + fontHeight / 2.0f, fontHeight * 1.1f + (float)yShift * this.yShiftScale);
    }

    @Override
    public void moveUpdate() {
    }

    @Override
    public void resizeUpdate() {
    }

    public static enum ScaleBarUnits {
        KILOMETERS,
        METERS,
        CENTIMETERS,
        MILLIMETERS,
        MILES,
        YARDS,
        FEET,
        INCHES;

    }

    public static enum ScaleBarType {
        SCALE_LINE_1,
        SCALE_LINE_2,
        ALTERNATING_BAR;

    }
}

