/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.analysis.integration;

import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.analysis.integration.BaseAbstractUnivariateIntegrator;
import org.apache.commons.math4.legacy.exception.NumberIsTooLargeException;
import org.apache.commons.numbers.core.ArithmeticUtils;

public class MidPointIntegrator
extends BaseAbstractUnivariateIntegrator {
    private static final int MIDPOINT_MAX_ITERATIONS_COUNT = 39;

    public MidPointIntegrator(double relativeAccuracy, double absoluteAccuracy, int minimalIterationCount, int maximalIterationCount) {
        super(relativeAccuracy, absoluteAccuracy, minimalIterationCount, maximalIterationCount);
        if (maximalIterationCount > 39) {
            throw new NumberIsTooLargeException((Number)maximalIterationCount, (Number)39, false);
        }
    }

    public MidPointIntegrator(int minimalIterationCount, int maximalIterationCount) {
        super(minimalIterationCount, maximalIterationCount);
        if (maximalIterationCount > 39) {
            throw new NumberIsTooLargeException((Number)maximalIterationCount, (Number)39, false);
        }
    }

    public MidPointIntegrator() {
        super(3, 39);
    }

    private double stage(int n, double previousStageResult, double min, double diffMaxMin) {
        long np = ArithmeticUtils.pow((long)3L, (int)(n - 1));
        double sum = 0.0;
        double spacing = diffMaxMin / (double)np;
        double leftOffset = spacing / 6.0;
        double rightOffset = 5.0 * leftOffset;
        double x = min;
        for (long i = 0L; i < np; ++i) {
            sum += this.computeObjectiveValue(x + leftOffset);
            sum += this.computeObjectiveValue(x + rightOffset);
            x += spacing;
        }
        return (previousStageResult + sum * spacing) / 3.0;
    }

    @Override
    protected double doIntegrate() {
        double min = this.getMin();
        double diff = this.getMax() - min;
        double midPoint = min + 0.5 * diff;
        double oldt = diff * this.computeObjectiveValue(midPoint);
        while (true) {
            double rLimit;
            double delta;
            this.iterations.increment();
            int i = this.iterations.getCount();
            double t = this.stage(i, oldt, min, diff);
            if (i >= this.getMinimalIterationCount() && ((delta = JdkMath.abs((double)(t - oldt))) <= (rLimit = this.getRelativeAccuracy() * (JdkMath.abs((double)oldt) + JdkMath.abs((double)t)) * 0.5) || delta <= this.getAbsoluteAccuracy())) {
                return t;
            }
            oldt = t;
        }
    }
}

