/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.icc.tags;

import java.io.IOException;
import java.io.RandomAccessFile;
import ucar.jpeg.icc.ICCProfile;
import ucar.jpeg.icc.tags.ICCTag;

public class ICCXYZType
extends ICCTag {
    public final long x;
    public final long y;
    public final long z;

    public static long DoubleToXYZ(double x) {
        return (long)Math.floor(x * 65536.0 + 0.5);
    }

    public static double XYZToDouble(long x) {
        return (double)x / 65536.0;
    }

    protected ICCXYZType(int signature, byte[] data, int offset, int length) {
        super(signature, data, offset, length);
        this.x = ICCProfile.getInt(data, offset + 8);
        this.y = ICCProfile.getInt(data, offset + 12);
        this.z = ICCProfile.getInt(data, offset + 16);
    }

    @Override
    public String toString() {
        return "[" + super.toString() + "(" + this.x + ", " + this.y + ", " + this.z + ")]";
    }

    public void write(RandomAccessFile raf) throws IOException {
        byte[] xb = ICCProfile.setLong(this.x);
        byte[] yb = ICCProfile.setLong(this.y);
        byte[] zb = ICCProfile.setLong(this.z);
        raf.write(xb, 4, 0);
        raf.write(yb, 4, 0);
        raf.write(zb, 4, 0);
    }
}

