/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.xmp;

import java.nio.charset.StandardCharsets;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.BinaryFileParser;
import org.apache.commons.imaging.formats.jpeg.JpegConstants;

public class JpegXmpParser
extends BinaryFileParser {
    public boolean isXmpJpegSegment(byte[] segmentData) {
        return JpegConstants.XMP_IDENTIFIER.isStartOf(segmentData);
    }

    public String parseXmpJpegSegment(byte[] segmentData) throws ImagingException {
        if (!this.isXmpJpegSegment(segmentData)) {
            throw new ImagingException("Invalid JPEG XMP Segment.");
        }
        int index = JpegConstants.XMP_IDENTIFIER.size();
        return new String(segmentData, index, segmentData.length - index, StandardCharsets.UTF_8);
    }
}

