/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geo.legend;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.PointF;
import org.meteoinfo.geo.legend.FrmColorSymbolSet;
import org.meteoinfo.geo.legend.FrmPointSymbolSet;
import org.meteoinfo.geo.legend.FrmPolygonSymbolSet;
import org.meteoinfo.geo.legend.FrmPolylineSymbolSet;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.HatchStyle;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.LegendType;
import org.meteoinfo.geometry.legend.LineStyles;
import org.meteoinfo.geometry.legend.MarkerType;
import org.meteoinfo.geometry.legend.PointBreak;
import org.meteoinfo.geometry.legend.PointStyle;
import org.meteoinfo.geometry.legend.PolygonBreak;
import org.meteoinfo.geometry.legend.PolylineBreak;
import org.meteoinfo.render.java2d.Draw;

public class LegendView
extends JPanel {
    private LegendScheme _legendScheme = null;
    private int _breakHeight;
    private int _symbolWidth;
    private int _valueWidth;
    private int _labelWidth;
    private FrmPointSymbolSet _frmPointSymbolSet;
    private FrmPolylineSymbolSet _frmPolylineSymbolSet;
    private FrmPolygonSymbolSet _frmPolygonSymbolSet;
    private FrmColorSymbolSet _frmColorSymbolSet;
    private List<Integer> _selectedRows = new ArrayList<Integer>();
    private int _startRow = -1;
    private ColorBreak _curBreak = null;
    private JScrollBar _vScrollBar;
    private JTextField _textField;
    private LookAndFeel laf = UIManager.getLookAndFeel();
    private Color borderColor;

    public LegendView() {
        this.setBackground(this.laf.getDefaults().getColor("List.background"));
        this.borderColor = this.laf.getDefaults().getColor("List.dropLineColor");
        this.initComponents();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                LegendView.this.onComponentResized(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LegendView.this.onMouseClicked(e);
            }
        });
        this._textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    LegendView.this.afterCellEdit();
                }
            }
        });
    }

    private void initComponents() {
        this.setPreferredSize(new Dimension(100, 200));
        this.setLayout(new BorderLayout());
        this._vScrollBar = new JScrollBar(1);
        this._vScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                LegendView.this.onScrollValueChanged(e);
            }
        });
        this.add((Component)this._vScrollBar, "East");
        this._vScrollBar.setSize(20, this.getHeight());
        this._vScrollBar.setLocation(this.getWidth() - this._vScrollBar.getWidth(), 0);
        this._textField = new JTextField();
        this._textField.setVisible(false);
        this.add(this._textField);
        this._frmPointSymbolSet = null;
        this._frmPolylineSymbolSet = null;
        this._frmPolygonSymbolSet = null;
        this._frmColorSymbolSet = null;
        this._legendScheme = null;
        this._breakHeight = 20;
        this._symbolWidth = 60;
        this._labelWidth = this._valueWidth = (this.getWidth() - this._symbolWidth) / 2;
    }

    public void onComponentResized(ComponentEvent e) {
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            this._labelWidth = this._valueWidth = (this.getWidth() - this._symbolWidth) / 2;
            this._vScrollBar.setLocation(this.getWidth() - this._vScrollBar.getWidth(), 0);
            this._vScrollBar.setSize(this._vScrollBar.getWidth(), this.getHeight());
        }
        this.repaint();
    }

    public void onScrollValueChanged(AdjustmentEvent e) {
        this._vScrollBar.setValue(e.getValue());
        this.repaint();
    }

    public void onMouseClicked(MouseEvent e) {
        if (e.getClickCount() == 1) {
            if (e.getButton() == 1) {
                if (this._textField.isVisible()) {
                    this.afterCellEdit();
                }
                int[] curTops = new int[]{0};
                int bIdx = this.findBreakIndexByPosition(e.getY(), curTops);
                if (bIdx >= 0) {
                    if (e.isControlDown()) {
                        if (this._selectedRows.contains(bIdx)) {
                            this._selectedRows.remove(bIdx);
                        } else {
                            this._selectedRows.add(bIdx);
                            this._startRow = bIdx;
                        }
                    } else if (e.isShiftDown()) {
                        this._selectedRows.clear();
                        if (this._startRow == -1) {
                            this._selectedRows.add(bIdx);
                        } else if (bIdx > this._startRow) {
                            for (int i = this._startRow; i <= bIdx; ++i) {
                                this._selectedRows.add(i);
                            }
                        } else {
                            for (int i = bIdx; i <= this._startRow; ++i) {
                                this._selectedRows.add(i);
                            }
                        }
                    } else {
                        this._selectedRows.clear();
                        this._selectedRows.add(bIdx);
                        this._startRow = bIdx;
                    }
                    this.repaint();
                }
            }
        } else if (e.getClickCount() == 2 && e.getButton() == 1) {
            if (this._textField.isVisible()) {
                this.afterCellEdit();
            }
            int[] curTops = new int[]{0};
            int bIdx = this.findBreakIndexByPosition(e.getY(), curTops);
            int curTop = curTops[0];
            if (bIdx >= 0) {
                ColorBreak aCB;
                if (e.isControlDown()) {
                    if (this._selectedRows.contains(bIdx)) {
                        this._selectedRows.remove(bIdx);
                    } else {
                        this._selectedRows.add(bIdx);
                        this._startRow = bIdx;
                    }
                } else if (e.isShiftDown()) {
                    int i;
                    this._selectedRows.clear();
                    if (this._startRow == -1) {
                        this._selectedRows.add(bIdx);
                    } else if (bIdx > this._startRow) {
                        for (i = this._startRow; i <= bIdx; ++i) {
                            this._selectedRows.add(i);
                        }
                    } else {
                        for (i = bIdx; i <= this._startRow; ++i) {
                            this._selectedRows.add(i);
                        }
                    }
                } else {
                    this._selectedRows.clear();
                    this._selectedRows.add(bIdx);
                    this._startRow = bIdx;
                }
                this._curBreak = aCB = (ColorBreak)this._legendScheme.getLegendBreaks().get(bIdx);
                if (this.ifInSymbol(e.getX())) {
                    this.showSymbolSetForm(aCB);
                } else if (this.ifInValue(e.getX())) {
                    this._textField.setLocation(this._symbolWidth, curTop);
                    this._textField.setSize(this._valueWidth, this._breakHeight);
                    this._textField.setText(aCB.getValueString());
                    this._textField.setName("Value");
                    this._textField.setVisible(true);
                } else if (this.ifInLabel(e.getX())) {
                    if (this._legendScheme.getLegendType() == LegendType.SINGLE_SYMBOL) {
                        this._textField.setLocation(this._symbolWidth, curTop);
                    } else {
                        this._textField.setLocation(this._symbolWidth + this._valueWidth, curTop);
                    }
                    this._textField.setSize(this._valueWidth, this._breakHeight);
                    this._textField.setText(aCB.getCaption());
                    this._textField.setName("Label");
                    this._textField.setVisible(true);
                }
            }
            this.repaint();
        }
    }

    private ColorBreak findBreakByPosition(int y, int[] curTops) {
        ColorBreak aCB = null;
        int idx = this.findBreakIndexByPosition(y, curTops);
        if (idx >= 0) {
            aCB = (ColorBreak)this._legendScheme.getLegendBreaks().get(idx);
        }
        return aCB;
    }

    private int findBreakIndexByPosition(int y, int[] curTops) {
        int idx = -1;
        int curTop = curTops[0];
        if (this._vScrollBar.isVisible()) {
            curTop -= this._vScrollBar.getValue();
        }
        for (int i = 0; i < this._legendScheme.getBreakNum(); ++i) {
            if (y <= (curTop += this._breakHeight) || y >= curTop + this._breakHeight) continue;
            idx = i;
            break;
        }
        curTops[0] = curTop;
        return idx;
    }

    private boolean ifInSymbol(int x) {
        return x > 0 && x < this._symbolWidth;
    }

    private boolean ifInValue(int x) {
        if (this._legendScheme.getLegendType() == LegendType.SINGLE_SYMBOL) {
            return false;
        }
        return x > this._symbolWidth && x < this._symbolWidth + this._valueWidth;
    }

    private boolean ifInLabel(int x) {
        if (this._legendScheme.getLegendType() == LegendType.SINGLE_SYMBOL) {
            return x > this._symbolWidth && x < this._symbolWidth + this._labelWidth;
        }
        return x > this._symbolWidth + this._valueWidth && x < this._symbolWidth + this._valueWidth + this._labelWidth;
    }

    private void showSymbolSetForm(ColorBreak aCB) {
        switch (this._legendScheme.getBreakType()) {
            case POINT_BREAK: {
                PointBreak aPB = (PointBreak)aCB;
                if (this._frmPointSymbolSet == null) {
                    this._frmPointSymbolSet = new FrmPointSymbolSet((Dialog)((JDialog)SwingUtilities.getWindowAncestor(this)), false, (Object)this);
                    this._frmPointSymbolSet.setLocationRelativeTo(this);
                    this._frmPointSymbolSet.setVisible(true);
                }
                this._frmPointSymbolSet.setPointBreak(aPB);
                this._frmPointSymbolSet.setVisible(true);
                break;
            }
            case POLYLINE_BREAK: {
                PolylineBreak aPLB = (PolylineBreak)aCB;
                if (this._frmPolylineSymbolSet == null) {
                    this._frmPolylineSymbolSet = new FrmPolylineSymbolSet((Dialog)((JDialog)SwingUtilities.getWindowAncestor(this)), false, (Object)this);
                    this._frmPolylineSymbolSet.setLocationRelativeTo(this);
                    this._frmPolylineSymbolSet.setVisible(true);
                }
                this._frmPolylineSymbolSet.setPolylineBreak(aPLB);
                this._frmPolylineSymbolSet.setVisible(true);
                break;
            }
            case POLYGON_BREAK: {
                PolygonBreak aPGB = (PolygonBreak)aCB;
                if (this._frmPolygonSymbolSet == null) {
                    this._frmPolygonSymbolSet = new FrmPolygonSymbolSet((Dialog)((JDialog)SwingUtilities.getWindowAncestor(this)), false, (Object)this);
                    this._frmPolygonSymbolSet.setLocationRelativeTo(this);
                    this._frmPolygonSymbolSet.setVisible(true);
                }
                this._frmPolygonSymbolSet.setPolygonBreak(aPGB);
                this._frmPolygonSymbolSet.setVisible(true);
                break;
            }
            case COLOR_BREAK: {
                if (this._frmColorSymbolSet == null) {
                    this._frmColorSymbolSet = new FrmColorSymbolSet((Dialog)((JDialog)SwingUtilities.getWindowAncestor(this)), false, this);
                    this._frmColorSymbolSet.setLocationRelativeTo(this);
                    this._frmColorSymbolSet.setVisible(true);
                }
                this._frmColorSymbolSet.setColorBreak(aCB);
                this._frmColorSymbolSet.setVisible(true);
            }
        }
    }

    private void afterCellEdit() {
        if (this._textField.getName().equals("Value")) {
            String aValue = this._textField.getText().trim();
            int aIdx = aValue.indexOf("-");
            if (aIdx > 0) {
                if (aValue.substring(aIdx - 1, aIdx).equals("E")) {
                    aIdx = aValue.indexOf("-", aIdx + 1);
                }
                double sValue = Double.parseDouble(aValue.substring(0, aIdx).trim());
                double eValue = Double.parseDouble(aValue.substring(aIdx + 1).trim());
                aValue = aValue.substring(0, aIdx).trim() + " - " + aValue.substring(aIdx + 1).trim();
                this._curBreak.setStartValue((Object)sValue);
                this._curBreak.setEndValue((Object)eValue);
            } else if (aIdx == 0) {
                double eValue;
                double sValue;
                aIdx = aValue.substring(1).indexOf("-");
                if (aIdx > 0) {
                    sValue = Double.parseDouble(aValue.substring(0, ++aIdx).trim());
                    eValue = Double.parseDouble(aValue.substring(aIdx + 1).trim());
                    aValue = aValue.substring(0, aIdx).trim() + " - " + aValue.substring(aIdx + 1).trim();
                } else {
                    eValue = sValue = Double.parseDouble(aValue);
                }
                this._curBreak.setStartValue((Object)sValue);
                this._curBreak.setEndValue((Object)eValue);
            } else {
                if (MIMath.isNumeric((String)aValue)) {
                    double sValue;
                    double d = sValue = Double.parseDouble(aValue);
                }
                this._curBreak.setStartValue((Object)aValue);
                this._curBreak.setEndValue((Object)aValue);
            }
            this._curBreak.setCaption(aValue);
        } else if (this._textField.getName().equals("Label")) {
            String caption = this._textField.getText().trim();
            this._curBreak.setCaption(caption);
        }
        this._textField.setVisible(false);
        this.repaint();
    }

    public LegendScheme getLegendScheme() {
        return this._legendScheme;
    }

    public void setLegendScheme(LegendScheme ls) {
        this._legendScheme = ls;
    }

    public List<Integer> getSelectedRows() {
        return this._selectedRows;
    }

    public int getBreakHeight() {
        return this._breakHeight;
    }

    public void setBreakHeight(int height) {
        this._breakHeight = height;
    }

    public void update(LegendScheme aLS) {
        this._legendScheme = aLS;
        this.repaint();
    }

    public void setLegendBreak_Color(Color aColor) {
        for (int rowIdx : this._selectedRows) {
            ((ColorBreak)this._legendScheme.getLegendBreaks().get(rowIdx)).setColor(aColor);
        }
        this.repaint();
    }

    public void setLegendBreak_Color_Transparency(int alpha) {
        for (int rowIdx : this._selectedRows) {
            Color c = ((ColorBreak)this._legendScheme.getLegendBreaks().get(rowIdx)).getColor();
            c = new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
            ((ColorBreak)this._legendScheme.getLegendBreaks().get(rowIdx)).setColor(c);
        }
        this.repaint();
    }

    public void setLegendBreak_OutlineColor(Color aColor) {
        for (int rowIdx : this._selectedRows) {
            switch (this._legendScheme.getBreakType()) {
                case POINT_BREAK: {
                    PointBreak aPB = (PointBreak)this._legendScheme.getLegendBreaks().get(rowIdx);
                    aPB.setOutlineColor(aColor);
                    break;
                }
                case POLYGON_BREAK: {
                    PolygonBreak aPGB = (PolygonBreak)this._legendScheme.getLegendBreaks().get(rowIdx);
                    aPGB.setOutlineColor(aColor);
                }
            }
        }
        this.repaint();
    }

    public void setLegendBreak_OutlineSize(float outlineSize) {
        for (int rowIdx : this._selectedRows) {
            switch (this._legendScheme.getBreakType()) {
                case POINT_BREAK: {
                    PointBreak pb = (PointBreak)this._legendScheme.getLegendBreaks().get(rowIdx);
                    pb.setOutlineSize(outlineSize);
                    break;
                }
                case POLYGON_BREAK: {
                    PolygonBreak aPGB = (PolygonBreak)this._legendScheme.getLegendBreaks().get(rowIdx);
                    aPGB.setOutlineSize(outlineSize);
                }
            }
        }
        this.repaint();
    }

    public void setLegendBreak_Angle(float angle) {
        for (int rowIdx : this._selectedRows) {
            PointBreak aPB = (PointBreak)this._legendScheme.getLegendBreaks().get(rowIdx);
            aPB.setAngle(angle);
        }
        this.repaint();
    }

    public void setLegendBreak_Alpha(int alpha) {
        for (int rowIdx : this._selectedRows) {
            ColorBreak aCB = (ColorBreak)this._legendScheme.getLegendBreaks().get(rowIdx);
            Color c = aCB.getColor();
            aCB.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha));
        }
        this.repaint();
    }

    public void setLegendBreak_Size(float aSize) {
        for (int rowIdx : this._selectedRows) {
            switch (this._legendScheme.getBreakType()) {
                case POINT_BREAK: {
                    PointBreak aPB = (PointBreak)this._legendScheme.getLegendBreaks().get(rowIdx);
                    aPB.setSize(aSize);
                    break;
                }
                case POLYLINE_BREAK: {
                    PolylineBreak aPLB = (PolylineBreak)this._legendScheme.getLegendBreaks().get(rowIdx);
                    aPLB.setWidth(aSize);
                    break;
                }
                case POLYGON_BREAK: {
                    PolygonBreak aPGB = (PolygonBreak)this._legendScheme.getLegendBreaks().get(rowIdx);
                    aPGB.setOutlineSize(aSize);
                }
            }
        }
        this.repaint();
    }

    public void setLegendBreak_PointStyle(PointStyle aPS) {
        for (int rowIdx : this._selectedRows) {
            PointBreak aPB = (PointBreak)this._legendScheme.getLegendBreaks().get(rowIdx);
            aPB.setStyle(aPS);
        }
        this.repaint();
    }

    public void setLegendBreak_PolylineStyle(LineStyles style) {
        for (int rowIdx : this._selectedRows) {
            PolylineBreak aPLB = (PolylineBreak)this._legendScheme.getLegendBreaks().get(rowIdx);
            aPLB.setStyle(style);
        }
        this.repaint();
    }

    public void setLegendBreak_PolygonStyle(HatchStyle style) {
        for (int rowIdx : this._selectedRows) {
            PolygonBreak aPLB = (PolygonBreak)this._legendScheme.getLegendBreaks().get(rowIdx);
            aPLB.setStyle(style);
        }
        this.repaint();
    }

    public void setLegendBreak_DrawOutline(boolean drawOutLine) {
        for (int rowIdx : this._selectedRows) {
            switch (this._legendScheme.getBreakType()) {
                case POINT_BREAK: {
                    PointBreak aPB = (PointBreak)this._legendScheme.getLegendBreaks().get(rowIdx);
                    aPB.setDrawOutline(drawOutLine);
                    break;
                }
                case POLYGON_BREAK: {
                    PolygonBreak aPGB = (PolygonBreak)this._legendScheme.getLegendBreaks().get(rowIdx);
                    aPGB.setDrawOutline(drawOutLine);
                }
            }
        }
        this.repaint();
    }

    public void setLegendBreak_DrawFill(boolean drawFill) {
        for (int rowIdx : this._selectedRows) {
            switch (this._legendScheme.getBreakType()) {
                case POINT_BREAK: {
                    PointBreak aPB = (PointBreak)this._legendScheme.getLegendBreaks().get(rowIdx);
                    aPB.setDrawFill(drawFill);
                    break;
                }
                case POLYGON_BREAK: {
                    PolygonBreak aPGB = (PolygonBreak)this._legendScheme.getLegendBreaks().get(rowIdx);
                    aPGB.setDrawFill(drawFill);
                }
            }
        }
        this.repaint();
    }

    public void setLegendBreak_DrawShape(boolean drawShape) {
        for (int rowIdx : this._selectedRows) {
            switch (this._legendScheme.getBreakType()) {
                case POINT_BREAK: {
                    PointBreak aPB = (PointBreak)this._legendScheme.getLegendBreaks().get(rowIdx);
                    aPB.setDrawShape(drawShape);
                    break;
                }
                case POLYLINE_BREAK: {
                    PolylineBreak aPLB = (PolylineBreak)this._legendScheme.getLegendBreaks().get(rowIdx);
                    aPLB.setDrawPolyline(drawShape);
                    break;
                }
                case POLYGON_BREAK: {
                    PolygonBreak aPGB = (PolygonBreak)this._legendScheme.getLegendBreaks().get(rowIdx);
                    aPGB.setDrawShape(drawShape);
                }
            }
        }
        this.repaint();
    }

    public void setLegendBreak_MarkerType(MarkerType markerType) {
        for (int rowIdx : this._selectedRows) {
            PointBreak aPB = (PointBreak)this._legendScheme.getLegendBreaks().get(rowIdx);
            aPB.setMarkerType(markerType);
        }
        this.repaint();
    }

    public void setLegendBreak_FontName(String fontName) {
        for (int rowIdx : this._selectedRows) {
            PointBreak aPB = (PointBreak)this._legendScheme.getLegendBreaks().get(rowIdx);
            aPB.setFontName(fontName);
        }
        this.repaint();
    }

    public void setLegendBreak_Image(String imagePath) {
        for (int rowIdx : this._selectedRows) {
            PointBreak aPB = (PointBreak)this._legendScheme.getLegendBreaks().get(rowIdx);
            aPB.setImagePath(imagePath);
        }
        this.repaint();
    }

    public void setLegendBreak_MarkerIndex(int markerIdx) {
        for (int rowIdx : this._selectedRows) {
            PointBreak aPB = (PointBreak)this._legendScheme.getLegendBreaks().get(rowIdx);
            switch (aPB.getMarkerType()) {
                case CHARACTER: {
                    aPB.setCharIndex(markerIdx);
                    break;
                }
                case SIMPLE: {
                    aPB.setStyle(PointStyle.values()[markerIdx]);
                    break;
                }
            }
        }
        this.repaint();
    }

    public void setLegendBreak_BackColor(Color backColor) {
        for (int rowIdx : this._selectedRows) {
            PolygonBreak aPGB = (PolygonBreak)this._legendScheme.getLegendBreaks().get(rowIdx);
            aPGB.setBackColor(backColor);
        }
        this.repaint();
    }

    public void setLegendBreak_DrawSymbol(boolean drawSymbol) {
        if (this._selectedRows.size() > 1) {
            int i = 0;
            for (int rowIdx : this._selectedRows) {
                PolylineBreak aPLB = (PolylineBreak)this._legendScheme.getLegendBreaks().get(rowIdx);
                aPLB.setDrawSymbol(drawSymbol);
                aPLB.setSymbolStyle(PointStyle.values()[i]);
                if (++i != PointStyle.values().length) continue;
                i = 0;
            }
        } else {
            PolylineBreak aPLB = (PolylineBreak)this._legendScheme.getLegendBreaks().get(this._selectedRows.get(0));
            aPLB.setDrawSymbol(drawSymbol);
        }
        this.repaint();
    }

    public void setLegendBreak_SymbolSize(float symbolSize) {
        for (int rowIdx : this._selectedRows) {
            PolylineBreak aPLB = (PolylineBreak)this._legendScheme.getLegendBreaks().get(rowIdx);
            aPLB.setSymbolSize(symbolSize);
        }
        this.repaint();
    }

    public void setLegendBreak_SymbolStyle(PointStyle symbolStyle) {
        for (int rowIdx : this._selectedRows) {
            PolylineBreak aPLB = (PolylineBreak)this._legendScheme.getLegendBreaks().get(rowIdx);
            aPLB.setSymbolStyle(symbolStyle);
        }
        this.repaint();
    }

    public void setLegendBreak_SymbolColor(Color symbolColor) {
        for (int rowIdx : this._selectedRows) {
            PolylineBreak aPLB = (PolylineBreak)this._legendScheme.getLegendBreaks().get(rowIdx);
            aPLB.setSymbolColor(symbolColor);
        }
        this.repaint();
    }

    public void setLegendBreak_SymbolInterval(int symbolInterval) {
        for (int rowIdx : this._selectedRows) {
            PolylineBreak aPLB = (PolylineBreak)this._legendScheme.getLegendBreaks().get(rowIdx);
            aPLB.setSymbolInterval(symbolInterval);
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this._legendScheme != null) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
            this.paintLegendScheme(g2);
        }
    }

    private void paintLegendScheme(Graphics2D g) {
        Rectangle rect;
        int TotalHeight = this.calcTotalDrawHeight();
        if (TotalHeight > this.getHeight()) {
            this._vScrollBar.setLocation(this.getWidth() - this._vScrollBar.getWidth(), 0);
            this._vScrollBar.setSize(this._vScrollBar.getWidth(), this.getHeight());
            this._vScrollBar.setMinimum(0);
            this._vScrollBar.setUnitIncrement(this._breakHeight);
            this._vScrollBar.setBlockIncrement(this.getHeight());
            this._vScrollBar.setMaximum(TotalHeight);
            if (!this._vScrollBar.isVisible()) {
                this._vScrollBar.setValue(0);
                this._vScrollBar.setVisible(true);
            }
            rect = new Rectangle(0, -this._vScrollBar.getValue(), this.getWidth() - this._vScrollBar.getWidth(), TotalHeight);
            this._labelWidth = this._valueWidth = (this.getWidth() - this._vScrollBar.getWidth() - this._symbolWidth) / 2;
        } else {
            this._vScrollBar.setVisible(false);
            rect = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            this._labelWidth = this._valueWidth = (this.getWidth() - this._symbolWidth) / 2;
        }
        this.drawBreaks(g, rect.y);
        this.drawTitle(g);
    }

    private void drawTitle(Graphics2D g) {
        int sX = 0;
        Font font = this.getFont();
        Color bColor = this.getBackground();
        g.setColor(bColor);
        g.fill(new Rectangle(sX, 0, this._symbolWidth, this._breakHeight));
        g.setColor(this.borderColor);
        g.draw(new Rectangle(0, 0, this._symbolWidth, this._breakHeight));
        String str = "Symbol";
        FontMetrics metrics = g.getFontMetrics(font);
        Dimension size = new Dimension(metrics.stringWidth(str), metrics.getHeight());
        int cx = this._symbolWidth / 2;
        int cy = this._breakHeight / 2;
        PointF aPoint = new PointF((float)(cx - size.width / 2), (float)(cy + size.height / 3));
        g.setFont(font);
        g.setColor(this.getForeground());
        g.drawString(str, aPoint.X, aPoint.Y);
        if (this._legendScheme.getLegendType() != LegendType.SINGLE_SYMBOL) {
            sX = this._symbolWidth;
            g.setColor(bColor);
            g.fill(new Rectangle(sX, 0, this._valueWidth, this._breakHeight));
            g.setColor(this.borderColor);
            g.draw(new Rectangle(sX, 0, this._valueWidth, this._breakHeight));
            str = "Value";
            size = new Dimension(metrics.stringWidth(str), metrics.getHeight());
            cx = sX + this._valueWidth / 2;
            aPoint = new PointF((float)(cx - size.width / 2), (float)(cy + size.height / 3));
            g.setColor(this.getForeground());
            g.drawString(str, aPoint.X, aPoint.Y);
            sX = this._symbolWidth + this._valueWidth;
        } else {
            sX = this._symbolWidth;
        }
        g.setColor(bColor);
        g.fill(new Rectangle(sX, 0, this._labelWidth, this._breakHeight));
        g.setColor(this.borderColor);
        g.draw(new Rectangle(sX, 0, this._labelWidth, this._breakHeight));
        str = "Label";
        size = new Dimension(metrics.stringWidth(str), metrics.getHeight());
        cx = sX + this._labelWidth / 2;
        aPoint = new PointF((float)(cx - size.width / 2), (float)(cy + size.height / 3));
        g.setColor(this.getForeground());
        g.drawString(str, aPoint.X, aPoint.Y);
    }

    private void drawBreaks(Graphics2D g, int sHeight) {
        Point sP = new Point(0, sHeight + this._breakHeight);
        for (int i = 0; i < this._legendScheme.getBreakNum(); ++i) {
            if (sP.y + this._breakHeight > this._breakHeight) {
                ColorBreak aCB = (ColorBreak)this._legendScheme.getLegendBreaks().get(i);
                Rectangle rect = new Rectangle(sP.x, sP.y, this._symbolWidth, this._breakHeight);
                boolean selected = this._selectedRows.contains(i);
                this.drawBreakSymbol(aCB, rect, selected, g);
                sP.y += this._breakHeight;
                continue;
            }
            if (sP.y > this.getHeight()) break;
            sP.y += this._breakHeight;
        }
    }

    private void drawBreakSymbol(ColorBreak aCB, Rectangle rect, boolean selected, Graphics2D g) {
        PointF aP = new PointF(0.0f, 0.0f);
        aP.X = rect.x + rect.width / 2;
        aP.Y = rect.y + rect.height / 2;
        if (selected) {
            g.setColor(Color.lightGray);
            g.fill(new Rectangle(this._symbolWidth, rect.y, this._valueWidth + this._labelWidth, rect.height));
        }
        switch (aCB.getBreakType()) {
            case POINT_BREAK: {
                PointBreak aPB = (PointBreak)aCB;
                float aSize = aPB.getSize();
                if (!aPB.isDrawShape()) break;
                if (aPB.getMarkerType() == MarkerType.CHARACTER) {
                    Draw.drawPoint((PointF)aP, (PointBreak)aPB, (Graphics2D)g);
                    break;
                }
                Draw.drawPoint((PointF)aP, (PointBreak)aPB, (Graphics2D)g);
                break;
            }
            case POLYLINE_BREAK: {
                PolylineBreak aPLB = (PolylineBreak)aCB;
                float aSize = aPLB.getWidth();
                float width = rect.width / 3 * 2;
                float height = rect.height / 3 * 2;
                Draw.drawPolylineSymbol((PointF)aP, (float)width, (float)height, (PolylineBreak)aPLB, (Graphics2D)g);
                break;
            }
            case POLYGON_BREAK: {
                PolygonBreak aPGB = (PolygonBreak)aCB;
                float width = rect.width / 3 * 2;
                float height = rect.height / 5 * 4;
                if (!aPGB.isDrawShape()) break;
                Draw.drawPolygonSymbol((PointF)aP, (float)width, (float)height, (PolygonBreak)aPGB, (Graphics2D)g);
                break;
            }
            case COLOR_BREAK: {
                float width = rect.width / 3 * 2;
                float height = rect.height / 3 * 2;
                Draw.drawPolygonSymbol((PointF)aP, (Color)aCB.getColor(), (Color)Color.black, (float)width, (float)height, (Boolean)true, (Boolean)true, (Graphics2D)g);
            }
        }
        int sX = this._symbolWidth;
        Font font = this.getFont();
        String str = aCB.getCaption();
        FontMetrics metrics = g.getFontMetrics(font);
        Dimension size = new Dimension(metrics.stringWidth(str), metrics.getHeight());
        aP.X = sX;
        aP.Y = rect.y + rect.height * 3 / 4;
        g.setFont(font);
        g.setColor(this.getForeground());
        if (this._legendScheme.getLegendType() == LegendType.SINGLE_SYMBOL) {
            g.drawString(str, aP.X, aP.Y);
        } else {
            aP.X += (float)this._valueWidth;
            g.drawString(str, aP.X, aP.Y);
            str = String.valueOf(aCB.getStartValue()).equals(String.valueOf(aCB.getEndValue())) ? String.valueOf(aCB.getStartValue()) : String.valueOf(aCB.getStartValue()) + " - " + String.valueOf(aCB.getEndValue());
            aP.X = sX;
            Rectangle clip = g.getClipBounds();
            g.clipRect(sX, rect.y, this._valueWidth - 5, rect.height);
            g.drawString(str, aP.X, aP.Y);
            g.setClip(clip.x, clip.y, clip.width, clip.height);
        }
    }

    private int calcTotalDrawHeight() {
        return this._breakHeight * (this._legendScheme.getBreakNum() + 1);
    }
}

