fn = 'D:/Temp/nc/wrfout_d01_2005-08-28_00-00-00'
f = addfile(fn)
lat2d = f['XLAT'][0,:,:]
lon2d = f['XLONG'][0,:,:]
tt = f.gettimes()
tlat = []
tlon = []
press = []
for t in range(f.timenum()):
    data = meteo.wrf.get_slp(f, timeidx=t)
    idx = data.argmin()
    idx = unravel_index(idx, data.shape)
    tlat.append(lat2d[idx[0],idx[1]])
    tlon.append(lon2d[idx[1],idx[1]])
    press.append(data[idx[0],idx[1]])

#Plot
axesm(bgcolor=(204,255,255))
geoshow('country', edgecolor=[200,200,200], facecolor=(255,251,195))
plotm(tlon, tlat)
layer = scatterm(tlon, tlat, press)
colorbar(layer)
for t in range(0, f.timenum()):
    text(tlon[t]+0.1, tlat[t], tt[t].strftime('%d:%H'))
title('Typhoon path tracing')