/*
 * Decompiled with CFR 0.152.
 */
package org.meteothink.trajstat.forms;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geo.legend.GroupNode;
import org.meteoinfo.geo.legend.LayerNode;
import org.meteoinfo.geo.plugin.IApplication;
import org.meteoinfo.table.Field;
import org.meteoinfo.ui.CheckTreeManager;
import org.meteoinfo.ui.CheckTreeSelectionModel;
import org.meteothink.trajstat.forms.FrmTable;

public class FrmClusterStat
extends JDialog {
    private IApplication app;
    CheckTreeManager checkTreeManager;
    private JButton jButton_Cancel;
    private JButton jButton_OK;
    private JComboBox jComboBox_Field;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JScrollPane jScrollPane2;
    private JTextField jTextField_Criterion;
    private JTextField jTextField_Missing;
    private JTree jTree_TrajLayers;

    public FrmClusterStat(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.app = (IApplication)parent;
        DefaultMutableTreeNode layersTN = new DefaultMutableTreeNode("Trajectory", true);
        GroupNode gNode = this.app.getMapDocument().getActiveMapFrame().getGroupByName("Trajectory");
        for (LayerNode lNode : gNode.getLayers()) {
            layersTN.insert(new DefaultMutableTreeNode(lNode.getMapLayer()), 0);
        }
        DefaultTreeModel model = new DefaultTreeModel(layersTN);
        this.jTree_TrajLayers.setModel(model);
        this.checkTreeManager = new CheckTreeManager(this.jTree_TrajLayers);
        TreePath path = this.jTree_TrajLayers.getPathForRow(1);
        CheckTreeSelectionModel selModel = this.checkTreeManager.getSelectionModel();
        selModel.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                FrmClusterStat.this.onSelectionValueChanged(e);
            }
        });
        selModel.addSelectionPath(path);
        this.getFileds();
    }

    private void getFileds() {
        TreePath[] checkedPaths = this.checkTreeManager.getSelectionModel().getSelectionPaths();
        if (checkedPaths == null) {
            return;
        }
        VectorLayer layer = null;
        for (TreePath path : checkedPaths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node.getChildCount() <= 0) {
                layer = (VectorLayer)node.getUserObject();
                break;
            }
            DefaultMutableTreeNode cnode = (DefaultMutableTreeNode)node.getChildAt(0);
            layer = (VectorLayer)cnode.getUserObject();
        }
        if (layer != null) {
            this.jComboBox_Field.removeAllItems();
            for (Field field : layer.getFields()) {
                if (!field.isNumeric()) continue;
                this.jComboBox_Field.addItem(field.getColumnName());
            }
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBox_Field = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jTextField_Criterion = new JTextField();
        this.jLabel3 = new JLabel();
        this.jTextField_Missing = new JTextField();
        this.jButton_OK = new JButton();
        this.jButton_Cancel = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTree_TrajLayers = new JTree();
        this.setDefaultCloseOperation(2);
        this.setTitle("Cluster statistics");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Setting"));
        this.jLabel1.setText("Field:");
        this.jComboBox_Field.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel2.setText("Criterion:");
        this.jTextField_Criterion.setText("0");
        this.jLabel3.setText("Missing:");
        this.jTextField_Missing.setText("0");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(14, 14, 14).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_Missing)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_Criterion)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_Field, 0, 112, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBox_Field, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextField_Criterion, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextField_Missing, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButton_OK.setText("OK");
        this.jButton_OK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmClusterStat.this.jButton_OKActionPerformed(evt);
            }
        });
        this.jButton_Cancel.setText("Cancel");
        this.jButton_Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmClusterStat.this.jButton_CancelActionPerformed(evt);
            }
        });
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("colors");
        DefaultMutableTreeNode treeNode2 = new DefaultMutableTreeNode("blue");
        treeNode1.add(treeNode2);
        treeNode2 = new DefaultMutableTreeNode("violet");
        treeNode1.add(treeNode2);
        treeNode2 = new DefaultMutableTreeNode("red");
        treeNode1.add(treeNode2);
        treeNode2 = new DefaultMutableTreeNode("yellow");
        treeNode1.add(treeNode2);
        this.jTree_TrajLayers.setModel(new DefaultTreeModel(treeNode1));
        this.jScrollPane2.setViewportView(this.jTree_TrajLayers);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -2, 185, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton_OK, -2, 81, -2).addGap(18, 18, 18).addComponent(this.jButton_Cancel).addGap(22, 22, 22)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_OK).addComponent(this.jButton_Cancel)).addGap(0, 9, Short.MAX_VALUE))).addContainerGap()));
        this.pack();
    }

    private void jButton_OKActionPerformed(ActionEvent evt) {
        int i;
        TreePath[] checkedPaths = this.checkTreeManager.getSelectionModel().getSelectionPaths();
        if (checkedPaths == null) {
            JOptionPane.showMessageDialog(null, "There is no trajectory layer was selected!");
            return;
        }
        ArrayList<VectorLayer> layers = new ArrayList<VectorLayer>();
        for (TreePath path : checkedPaths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node.getChildCount() > 0) {
                for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
                    DefaultMutableTreeNode cnode = (DefaultMutableTreeNode)node.getChildAt(i2);
                    layers.add((VectorLayer)cnode.getUserObject());
                }
                continue;
            }
            layers.add((VectorLayer)node.getUserObject());
            break;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        String fieldName = this.jComboBox_Field.getSelectedItem().toString();
        int cNum = 1;
        for (VectorLayer layer : layers) {
            int cFldIdx = layer.getFieldIdxByName("Cluster");
            if (cFldIdx == -1) {
                JOptionPane.showMessageDialog(null, "There is no Cluster field in " + layer.getLayerName() + "!");
                return;
            }
            for (i = 0; i < layer.getShapeNum(); ++i) {
                int cn = Integer.parseInt(layer.getCellValue(cFldIdx, i).toString());
                if (cNum >= cn) continue;
                cNum = cn;
            }
        }
        double criterion = Double.parseDouble(this.jTextField_Criterion.getText());
        double missingValue = Double.parseDouble(this.jTextField_Missing.getText());
        double[] mValue = new double[cNum + 1];
        double[] mPValue = new double[cNum + 1];
        double[] stdev = new double[cNum + 1];
        double[] pStdev = new double[cNum + 1];
        int[] tNum = new int[cNum + 1];
        int[] ptNum = new int[cNum + 1];
        for (i = 0; i <= cNum; ++i) {
            mValue[i] = 0.0;
            mPValue[i] = 0.0;
            tNum[i] = 0;
            ptNum[i] = 0;
            stdev[i] = 0.0;
            pStdev[i] = 0.0;
        }
        for (VectorLayer layer : layers) {
            int aFldIdx = layer.getFieldIdxByName(fieldName);
            int cFldIdx = layer.getFieldIdxByName("Cluster");
            for (i = 0; i < layer.getShapeNum(); ++i) {
                double aValue = Double.parseDouble(layer.getCellValue(aFldIdx, i).toString());
                int clusterIdx = Integer.parseInt(layer.getCellValue(cFldIdx, i).toString());
                if (MIMath.doubleEquals((double)aValue, (double)missingValue)) continue;
                int n = clusterIdx - 1;
                mValue[n] = mValue[n] + aValue;
                int n2 = clusterIdx - 1;
                tNum[n2] = tNum[n2] + 1;
                int n3 = clusterIdx - 1;
                stdev[n3] = stdev[n3] + Math.pow(aValue, 2.0);
                int n4 = cNum;
                mValue[n4] = mValue[n4] + aValue;
                int n5 = cNum;
                tNum[n5] = tNum[n5] + 1;
                int n6 = cNum;
                stdev[n6] = stdev[n6] + Math.pow(aValue, 2.0);
                if (!(aValue >= criterion)) continue;
                int n7 = clusterIdx - 1;
                mPValue[n7] = mPValue[n7] + aValue;
                int n8 = clusterIdx - 1;
                ptNum[n8] = ptNum[n8] + 1;
                int n9 = clusterIdx - 1;
                pStdev[n9] = pStdev[n9] + Math.pow(aValue, 2.0);
                int n10 = cNum;
                mPValue[n10] = mPValue[n10] + aValue;
                int n11 = cNum;
                ptNum[n11] = ptNum[n11] + 1;
                int n12 = cNum;
                pStdev[n12] = pStdev[n12] + Math.pow(aValue, 2.0);
            }
        }
        for (i = 0; i <= cNum; ++i) {
            stdev[i] = Math.sqrt(((double)tNum[i] * stdev[i] - Math.pow(mValue[i], 2.0)) / (double)(tNum[i] * (tNum[i] - 1)));
            mValue[i] = mValue[i] / (double)tNum[i];
            if (ptNum[i] > 1) {
                pStdev[i] = Math.sqrt(((double)ptNum[i] * pStdev[i] - Math.pow(mPValue[i], 2.0)) / (double)(ptNum[i] * (ptNum[i] - 1)));
                mPValue[i] = mPValue[i] / (double)ptNum[i];
                continue;
            }
            pStdev[i] = 0.0;
        }
        Object[][] tData = new Object[cNum + 1][7];
        Object[] colNames = new String[]{"Cluster", "Num", "Mean_Val", "Stdev", "P_Num", "P_Mean_Val", "P_Stdev"};
        for (i = 0; i <= cNum; ++i) {
            tData[i][0] = i == cNum ? "All" : Integer.valueOf(i + 1);
            tData[i][1] = tNum[i];
            tData[i][2] = String.format("%1$.2f", mValue[i]);
            tData[i][3] = String.format("%1$.2f", stdev[i]);
            tData[i][4] = ptNum[i];
            tData[i][5] = String.format("%1$.2f", mPValue[i]);
            tData[i][6] = String.format("%1$.2f", pStdev[i]);
        }
        DefaultTableModel model = new DefaultTableModel(tData, colNames);
        FrmTable frmTable = new FrmTable((Frame)((JFrame)this.app), false);
        frmTable.setTableModel(model);
        frmTable.setLocationRelativeTo((JFrame)this.app);
        frmTable.setVisible(true);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jButton_CancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void onSelectionValueChanged(TreeSelectionEvent evt) {
        this.getFileds();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmClusterStat.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmClusterStat.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmClusterStat.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmClusterStat.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmClusterStat dialog = new FrmClusterStat((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

