/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.graphic;

import java.awt.Color;
import java.awt.image.BufferedImage;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.meteoinfo.chart.graphic.GraphicProjectionUtil;
import org.meteoinfo.chart.jogl.Transform;
import org.meteoinfo.common.Extent3D;
import org.meteoinfo.geometry.colors.TransferFunction;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.graphic.GraphicCollection3D;
import org.meteoinfo.geometry.legend.LegendManage;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.projection.GeoTransform;

public class MeshGraphic
extends GraphicCollection3D {
    private float[] vertexPosition;
    private float[] vertexValue;
    private float[] vertexColor;
    private float[] vertexNormal;
    private float[] vertexTexture;
    private int[] vertexIndices;
    private int rows;
    private int columns;
    private boolean faceInterp = false;
    private boolean edgeInterp = false;
    private BufferedImage image;
    private boolean mesh = false;

    public float[] getVertexPosition() {
        return this.vertexPosition;
    }

    public float[] getVertexPosition(Transform transform) {
        int n = this.vertexPosition.length;
        float[] vData = new float[n];
        for (int i = 0; i < n; i += 3) {
            vData[i] = transform.transform_x(this.vertexPosition[i]);
            vData[i + 1] = transform.transform_y(this.vertexPosition[i + 1]);
            vData[i + 2] = transform.transform_z(this.vertexPosition[i + 2]);
        }
        return vData;
    }

    public void setVertexPosition(float[] value) {
        this.vertexPosition = value;
        this.updateExtent();
    }

    public void setVertexPosition(float[] value, int rows) {
        this.setVertexPosition(value);
        this.setRows(rows);
        this.updateVertexIndices();
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int value) {
        this.rows = value;
        this.columns = this.getVertexNumber() / value;
        this.calculateNormalVectors(this.vertexPosition);
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int value) {
        this.columns = value;
        this.rows = this.getVertexNumber() / value;
        this.calculateNormalVectors(this.vertexPosition);
    }

    public float[] getVertexValue() {
        return this.vertexValue;
    }

    public void setVertexValue(float[] value) {
        this.vertexValue = value;
    }

    public int[] getVertexIndices() {
        return this.vertexIndices;
    }

    public float[] getVertexColor() {
        return this.vertexColor;
    }

    public void setVertexColor(float[] value) {
        this.vertexColor = value;
    }

    public float[] getVertexNormal() {
        return this.vertexNormal;
    }

    public boolean isUsingTexture() {
        return this.image != null;
    }

    public float[] getVertexTexture() {
        return this.vertexTexture;
    }

    public boolean isFaceInterp() {
        return this.faceInterp;
    }

    public void setFaceInterp(boolean value) {
        this.faceInterp = value;
    }

    public boolean isEdgeInterp() {
        return this.edgeInterp;
    }

    public void setEdgeInterp(boolean value) {
        this.edgeInterp = value;
    }

    public boolean isMesh() {
        return this.mesh;
    }

    public void setMesh(boolean value) {
        this.mesh = value;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage value) {
        this.image = value;
        this.updateVertexTexture();
    }

    public int getVertexNumber() {
        return this.vertexPosition.length / 3;
    }

    public int getFaceNumber() {
        return (this.rows - 1) * (this.columns - 1);
    }

    public void updateExtent() {
        float minX = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float minY = minX;
        float maxY = maxX;
        float minZ = minX;
        float maxZ = maxX;
        boolean idx = false;
        for (int i = 0; i < this.vertexPosition.length; i += 3) {
            float x = this.vertexPosition[i];
            float y = this.vertexPosition[i + 1];
            float z = this.vertexPosition[i + 2];
            if (minX > x) {
                minX = x;
            }
            if (maxX < x) {
                maxX = x;
            }
            if (minY > y) {
                minY = y;
            }
            if (maxY < y) {
                maxY = y;
            }
            if (minZ > z) {
                minZ = z;
            }
            if (!(maxZ < z)) continue;
            maxZ = z;
        }
        this.extent = new Extent3D((double)minX, (double)maxX, (double)minY, (double)maxY, (double)minZ, (double)maxZ);
    }

    public void updateVertexIndices() {
        int n = (this.rows - 1) * (this.columns - 1) * 4;
        this.vertexIndices = new int[n];
        for (int i = 0; i < this.rows - 1; ++i) {
            for (int j = 0; j < this.columns - 1; ++j) {
                int vIdx = i * this.columns + j;
                int idx = (i * (this.columns - 1) + j) * 4;
                this.vertexIndices[idx] = vIdx;
                this.vertexIndices[idx + 1] = vIdx + 1;
                this.vertexIndices[idx + 2] = vIdx + 1 + this.columns;
                this.vertexIndices[idx + 3] = vIdx + this.columns;
            }
        }
    }

    public void setLegendScheme(LegendScheme ls) {
        super.setLegendScheme(ls);
        this.updateVertexColor();
    }

    public void updateVertexColor() {
        if (this.vertexValue != null && this.legendScheme != null) {
            this.vertexColor = new float[this.getVertexNumber() * 4];
            for (int i = 0; i < this.vertexValue.length; ++i) {
                float[] color = Float.isNaN(this.vertexValue[i]) ? this.legendScheme.getLegendBreak(0).getColor().getRGBComponents(null) : this.legendScheme.findLegendBreakAlways((Number)Float.valueOf(this.vertexValue[i])).getColor().getRGBComponents(null);
                System.arraycopy(color, 0, this.vertexColor, i * 4, 4);
            }
        }
    }

    public void setTransferFunction(TransferFunction transferFunction) {
        LegendScheme ls;
        if (this.vertexValue != null) {
            this.vertexColor = new float[this.getVertexNumber() * 4];
            for (int i = 0; i < this.vertexValue.length; ++i) {
                float[] color = transferFunction.getColor((double)this.vertexValue[i]).getRGBComponents(null);
                System.arraycopy(color, 0, this.vertexColor, i * 4, 4);
            }
        }
        this.legendScheme = ls = LegendManage.createLegendScheme((TransferFunction)transferFunction);
        this.setSingleLegend(false);
    }

    public void updateVertexTexture() {
        this.vertexTexture = new float[this.getVertexNumber() * 2];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                int idx = (i * this.columns + j) * 2;
                this.vertexTexture[idx] = (float)j / (float)(this.columns - 1);
                this.vertexTexture[idx + 1] = (float)i / (float)(this.rows - 1);
            }
        }
    }

    public Vector3f getVertex(float[] vData, int row, int col) {
        int idx = (row * this.columns + col) * 3;
        return new Vector3f(vData[idx], vData[idx + 1], vData[idx + 2]);
    }

    public Vector3f getVertex(int row, int col) {
        return this.getVertex(this.vertexPosition, row, col);
    }

    public void calculateNormalVectors(float[] vData) {
        int n = this.getVertexNumber();
        this.vertexNormal = new float[n * 3];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                int idx = (i * this.columns + j) * 3;
                Vector3f v = new Vector3f(vData[idx], vData[idx + 1], vData[idx + 2]);
                Vector3f left = j > 0 ? this.getVertex(vData, i, j - 1) : null;
                Vector3f right = j < this.columns - 1 ? this.getVertex(vData, i, j + 1) : null;
                Vector3f down = i > 0 ? this.getVertex(vData, i - 1, j) : null;
                Vector3f up = i < this.rows - 1 ? this.getVertex(vData, i + 1, j) : null;
                Vector3f nLeftUp = left == null || up == null ? new Vector3f() : left.sub((Vector3fc)v, new Vector3f()).cross((Vector3fc)up.sub((Vector3fc)v, new Vector3f()));
                Vector3f nLeftDown = left == null || down == null ? new Vector3f() : down.sub((Vector3fc)v, new Vector3f()).cross((Vector3fc)left.sub((Vector3fc)v, new Vector3f()));
                Vector3f nRightUp = right == null || up == null ? new Vector3f() : up.sub((Vector3fc)v, new Vector3f()).cross((Vector3fc)right.sub((Vector3fc)v, new Vector3f()));
                Vector3f nRightDown = right == null || down == null ? new Vector3f() : right.sub((Vector3fc)v, new Vector3f()).cross((Vector3fc)down.sub((Vector3fc)v, new Vector3f()));
                Vector3f normal = nLeftUp.add((Vector3fc)nLeftDown).add((Vector3fc)nRightUp).add((Vector3fc)nRightDown).normalize();
                normal.negate();
                this.vertexNormal[idx] = normal.x;
                this.vertexNormal[idx + 1] = normal.y;
                this.vertexNormal[idx + 2] = normal.z;
            }
        }
    }

    public Color getColor() {
        return Color.red;
    }

    public void doTransform() {
        if (this.transform != null && this.transform.isValid() && this.transform instanceof GeoTransform) {
            GeoTransform geoTransform = (GeoTransform)this.transform;
            GraphicProjectionUtil.projectClipGraphic((Graphic)this, geoTransform.getSourceProj(), geoTransform.getTargetProj());
        }
    }
}

