/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action.actions;

import bibliothek.extension.gui.dock.preference.editor.KeyStrokeEditor;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.action.ActionContentModifier;
import bibliothek.gui.dock.action.actions.AbstractStandardDockAction;
import bibliothek.gui.dock.action.actions.SharingStandardDockAction;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.event.KeyboardListener;
import bibliothek.gui.dock.station.LayoutLocked;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public abstract class SimpleDockAction
extends AbstractStandardDockAction
implements SharingStandardDockAction {
    private Map<ActionContentModifier, Icon> icons = new HashMap<ActionContentModifier, Icon>();
    private String text;
    private String tooltip;
    private boolean enabled = true;
    private KeyStroke accelerator;
    private boolean globalAccelerator = false;
    private Dockable representative;
    private Map<Dockable, DockableKeyForwarder> forwarders = new HashMap<Dockable, DockableKeyForwarder>();

    public SimpleDockAction(boolean monitorDisabling) {
        super(monitorDisabling);
    }

    @Override
    protected void bound(Dockable dockable) {
        super.bound(dockable);
        DockableKeyForwarder forwarder = new DockableKeyForwarder(dockable);
        this.forwarders.put(dockable, forwarder);
    }

    @Override
    protected void unbound(Dockable dockable) {
        super.unbound(dockable);
        DockableKeyForwarder forwarder = this.forwarders.remove(dockable);
        forwarder.destroy();
    }

    @Override
    public Icon getIcon(Dockable dockable, ActionContentModifier modifier) {
        return this.icons.get(modifier);
    }

    @Override
    public String getText(Dockable dockable) {
        return this.text;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
        this.fireActionTextChanged(this.getBoundDockables());
    }

    @Override
    public String getTooltipText(Dockable dockable) {
        return this.getTooltipText();
    }

    @Override
    public String getTooltipText() {
        if (this.accelerator == null) {
            return this.tooltip;
        }
        String acceleratorText = KeyStrokeEditor.toString(this.accelerator, true);
        if (this.tooltip == null) {
            return acceleratorText;
        }
        return this.tooltip + " (" + acceleratorText + ")";
    }

    @Override
    public String getTooltip() {
        return this.tooltip;
    }

    @Override
    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
        this.fireActionTooltipTextChanged(this.getBoundDockables());
    }

    @Override
    public boolean isEnabled(Dockable dockable) {
        return this.enabled && super.isEnabled(dockable);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            this.fireActionEnabledChanged(this.getBoundDockables());
        }
    }

    @Override
    public Icon getIcon() {
        return this.icons.get(ActionContentModifier.NONE);
    }

    @Override
    public void setIcon(Icon icon) {
        this.setIcon(ActionContentModifier.NONE, icon);
    }

    @Override
    public ActionContentModifier[] getIconContexts(Dockable dockable) {
        return this.icons.keySet().toArray(new ActionContentModifier[this.icons.size()]);
    }

    @Override
    public Icon getDisabledIcon() {
        return this.icons.get(ActionContentModifier.DISABLED);
    }

    @Override
    public void setDisabledIcon(Icon icon) {
        this.setIcon(ActionContentModifier.DISABLED, icon);
    }

    @Override
    public Icon getIcon(ActionContentModifier modifier) {
        return this.icons.get(modifier);
    }

    @Override
    public void setIcon(ActionContentModifier modifier, Icon icon) {
        if (icon == null) {
            this.icons.remove(modifier);
        } else {
            this.icons.put(modifier, icon);
        }
        this.fireActionIconChanged(modifier, this.getBoundDockables());
    }

    @Override
    public void setDockableRepresentation(Dockable dockable) {
        if (this.representative != dockable) {
            this.representative = dockable;
            this.fireActionRepresentativeChanged(this.getBoundDockables());
        }
    }

    @Override
    public Dockable getDockableRepresentation(Dockable dockable) {
        return this.representative;
    }

    @Override
    public Dockable getDockableRepresentation() {
        return this.representative;
    }

    @Override
    public KeyStroke getAccelerator() {
        return this.accelerator;
    }

    @Override
    public void setAccelerator(KeyStroke accelerator) {
        this.accelerator = accelerator;
        this.fireActionTooltipTextChanged(this.getBoundDockables());
    }

    @Override
    public void setAcceleratorIsGlobal(boolean global) {
        this.globalAccelerator = global;
    }

    @Override
    public boolean isAcceleratorGlobal() {
        return this.globalAccelerator;
    }

    protected boolean trigger(KeyEvent event, Dockable dockable) {
        return this.trigger(dockable);
    }

    @LayoutLocked(locked=false)
    private class DockableKeyForwarder
    implements KeyboardListener,
    DockHierarchyListener {
        private Dockable dockable;
        private DockController controller;
        private boolean destroyed = false;

        public DockableKeyForwarder(Dockable dockable) {
            this.dockable = dockable;
            dockable.addDockHierarchyListener(this);
            this.setController(dockable.getController());
        }

        @Override
        public void hierarchyChanged(DockHierarchyEvent event) {
        }

        @Override
        public void controllerChanged(DockHierarchyEvent event) {
            this.setController(this.dockable.getController());
        }

        private void setController(DockController controller) {
            if (this.controller != null) {
                this.controller.getKeyboardController().removeListener(this);
            }
            this.controller = this.destroyed ? null : controller;
            if (this.controller != null) {
                this.controller.getKeyboardController().addListener(this);
            }
        }

        public void destroy() {
            this.destroyed = true;
            this.setController(null);
            this.dockable.removeDockHierarchyListener(this);
        }

        private boolean forward(DockElement element, KeyEvent event) {
            if (SimpleDockAction.this.accelerator != null && SimpleDockAction.this.accelerator.equals(KeyStroke.getKeyStrokeForEvent(event))) {
                return SimpleDockAction.this.trigger(event, this.dockable);
            }
            return false;
        }

        @Override
        public boolean keyPressed(DockElement element, KeyEvent event) {
            return this.forward(element, event);
        }

        @Override
        public boolean keyReleased(DockElement element, KeyEvent event) {
            return this.forward(element, event);
        }

        @Override
        public boolean keyTyped(DockElement element, KeyEvent event) {
            return this.forward(element, event);
        }

        @Override
        public DockElement getTreeLocation() {
            if (SimpleDockAction.this.isAcceleratorGlobal()) {
                return null;
            }
            return this.dockable;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " -> " + this.dockable.getTitleText() + " -> " + SimpleDockAction.this.getText();
        }
    }
}

