/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.stats.kde;

import java.util.List;
import org.meteoinfo.math.stats.kde.BallTree;
import org.meteoinfo.math.stats.kde.Event;

public class Ball {
    private static final String NAME = "Ball";
    int numPoints;
    double[] ll;
    double[] ur;
    double minBW;
    double maxBW;
    Event event = null;
    List<Event> events = null;
    Ball leftBall;
    Ball rightBall;

    protected Ball(List<Event> ballData) {
        this.events = ballData;
        this.numPoints = ballData.size();
    }

    protected Ball(double[] ll, double[] ur, Event event, int numPoints, Ball leftBall, Ball rightBall, double minBW, double maxBW) {
        this.ll = ll;
        this.ur = ur;
        this.event = event;
        this.numPoints = numPoints;
        this.leftBall = leftBall;
        this.rightBall = rightBall;
        this.minBW = minBW;
        this.maxBW = maxBW;
    }

    protected double minPdf(Event e) {
        double[] farthest = this.farthestPoint(e.getPoint());
        return BallTree.computeLogKernel(e.getPoint(), farthest, this.maxBW, this.minBW);
    }

    protected double maxPdf(Event e) {
        double[] closest = this.closestPoint(e.getPoint());
        return BallTree.computeLogKernel(e.getPoint(), closest, this.minBW, this.maxBW);
    }

    private double[] closestPoint(double[] point) {
        if (point[0] > this.ur[0]) {
            if (point[1] >= this.ur[1]) {
                return this.ur;
            }
            if (point[1] >= this.ll[1]) {
                double[] closest = new double[]{this.ur[0], point[1]};
                return closest;
            }
            double[] closest = new double[]{this.ur[0], this.ll[1]};
            return closest;
        }
        if (point[0] > this.ll[0]) {
            if (point[1] > this.ur[1]) {
                double[] closest = new double[]{point[0], this.ur[1]};
                return closest;
            }
            if (point[1] >= this.ll[1]) {
                return point;
            }
            double[] closest = new double[]{point[0], this.ll[1]};
            return closest;
        }
        if (point[1] > this.ur[1]) {
            double[] closest = new double[]{this.ll[0], this.ur[1]};
            return closest;
        }
        if (point[1] >= this.ll[1]) {
            double[] closest = new double[]{this.ll[0], point[1]};
            return closest;
        }
        return this.ll;
    }

    private double[] farthestPoint(double[] point) {
        double midy = this.ur[1] - (this.ur[1] - this.ll[1]) / 2.0;
        double midx = this.ur[0] - (this.ur[0] - this.ll[0]) / 2.0;
        double[] ul = new double[]{this.ll[0], this.ur[1]};
        double[] lr = new double[]{this.ur[0], this.ll[1]};
        if (point[0] > midx) {
            if (point[1] > midy) {
                return this.ll;
            }
            return ul;
        }
        if (point[1] > midy) {
            return lr;
        }
        return this.ur;
    }

    private String className() {
        return NAME;
    }

    public static void main(String ... args) throws Exception {
    }
}

