# from https://www.w3schools.com/colors/colors_x11.asp

"""X11 Colors

These color and their names (taken from
https://www.w3schools.com/colors/colors_x11.asp) were developed at the
Massachusetts Intitute of Technology (MIT) during
the development of color based computer display system.

To use the colors from this list, access them directly from the module (which
is exposed to Manim's global name space):

.. code:: pycon

    >>> from manim import X11
    >>> X11.BEIGE
    ManimColor('#F5F5DC')


List of Color Constants
-----------------------

.. automanimcolormodule:: manim.utils.color.X11
"""

from __future__ import annotations

from .core import ManimColor

ALICEBLUE = ManimColor("#F0F8FF")
ANTIQUEWHITE = ManimColor("#FAEBD7")
ANTIQUEWHITE1 = ManimColor("#FFEFDB")
ANTIQUEWHITE2 = ManimColor("#EEDFCC")
ANTIQUEWHITE3 = ManimColor("#CDC0B0")
ANTIQUEWHITE4 = ManimColor("#8B8378")
AQUAMARINE1 = ManimColor("#7FFFD4")
AQUAMARINE2 = ManimColor("#76EEC6")
AQUAMARINE4 = ManimColor("#458B74")
AZURE1 = ManimColor("#F0FFFF")
AZURE2 = ManimColor("#E0EEEE")
AZURE3 = ManimColor("#C1CDCD")
AZURE4 = ManimColor("#838B8B")
BEIGE = ManimColor("#F5F5DC")
BISQUE1 = ManimColor("#FFE4C4")
BISQUE2 = ManimColor("#EED5B7")
BISQUE3 = ManimColor("#CDB79E")
BISQUE4 = ManimColor("#8B7D6B")
BLACK = ManimColor("#000000")
BLANCHEDALMOND = ManimColor("#FFEBCD")
BLUE1 = ManimColor("#0000FF")
BLUE2 = ManimColor("#0000EE")
BLUE4 = ManimColor("#00008B")
BLUEVIOLET = ManimColor("#8A2BE2")
BROWN = ManimColor("#A52A2A")
BROWN1 = ManimColor("#FF4040")
BROWN2 = ManimColor("#EE3B3B")
BROWN3 = ManimColor("#CD3333")
BROWN4 = ManimColor("#8B2323")
BURLYWOOD = ManimColor("#DEB887")
BURLYWOOD1 = ManimColor("#FFD39B")
BURLYWOOD2 = ManimColor("#EEC591")
BURLYWOOD3 = ManimColor("#CDAA7D")
BURLYWOOD4 = ManimColor("#8B7355")
CADETBLUE = ManimColor("#5F9EA0")
CADETBLUE1 = ManimColor("#98F5FF")
CADETBLUE2 = ManimColor("#8EE5EE")
CADETBLUE3 = ManimColor("#7AC5CD")
CADETBLUE4 = ManimColor("#53868B")
CHARTREUSE1 = ManimColor("#7FFF00")
CHARTREUSE2 = ManimColor("#76EE00")
CHARTREUSE3 = ManimColor("#66CD00")
CHARTREUSE4 = ManimColor("#458B00")
CHOCOLATE = ManimColor("#D2691E")
CHOCOLATE1 = ManimColor("#FF7F24")
CHOCOLATE2 = ManimColor("#EE7621")
CHOCOLATE3 = ManimColor("#CD661D")
CORAL = ManimColor("#FF7F50")
CORAL1 = ManimColor("#FF7256")
CORAL2 = ManimColor("#EE6A50")
CORAL3 = ManimColor("#CD5B45")
CORAL4 = ManimColor("#8B3E2F")
CORNFLOWERBLUE = ManimColor("#6495ED")
CORNSILK1 = ManimColor("#FFF8DC")
CORNSILK2 = ManimColor("#EEE8CD")
CORNSILK3 = ManimColor("#CDC8B1")
CORNSILK4 = ManimColor("#8B8878")
CYAN1 = ManimColor("#00FFFF")
CYAN2 = ManimColor("#00EEEE")
CYAN3 = ManimColor("#00CDCD")
CYAN4 = ManimColor("#008B8B")
DARKGOLDENROD = ManimColor("#B8860B")
DARKGOLDENROD1 = ManimColor("#FFB90F")
DARKGOLDENROD2 = ManimColor("#EEAD0E")
DARKGOLDENROD3 = ManimColor("#CD950C")
DARKGOLDENROD4 = ManimColor("#8B6508")
DARKGREEN = ManimColor("#006400")
DARKKHAKI = ManimColor("#BDB76B")
DARKOLIVEGREEN = ManimColor("#556B2F")
DARKOLIVEGREEN1 = ManimColor("#CAFF70")
DARKOLIVEGREEN2 = ManimColor("#BCEE68")
DARKOLIVEGREEN3 = ManimColor("#A2CD5A")
DARKOLIVEGREEN4 = ManimColor("#6E8B3D")
DARKORANGE = ManimColor("#FF8C00")
DARKORANGE1 = ManimColor("#FF7F00")
DARKORANGE2 = ManimColor("#EE7600")
DARKORANGE3 = ManimColor("#CD6600")
DARKORANGE4 = ManimColor("#8B4500")
DARKORCHID = ManimColor("#9932CC")
DARKORCHID1 = ManimColor("#BF3EFF")
DARKORCHID2 = ManimColor("#B23AEE")
DARKORCHID3 = ManimColor("#9A32CD")
DARKORCHID4 = ManimColor("#68228B")
DARKSALMON = ManimColor("#E9967A")
DARKSEAGREEN = ManimColor("#8FBC8F")
DARKSEAGREEN1 = ManimColor("#C1FFC1")
DARKSEAGREEN2 = ManimColor("#B4EEB4")
DARKSEAGREEN3 = ManimColor("#9BCD9B")
DARKSEAGREEN4 = ManimColor("#698B69")
DARKSLATEBLUE = ManimColor("#483D8B")
DARKSLATEGRAY = ManimColor("#2F4F4F")
DARKSLATEGRAY1 = ManimColor("#97FFFF")
DARKSLATEGRAY2 = ManimColor("#8DEEEE")
DARKSLATEGRAY3 = ManimColor("#79CDCD")
DARKSLATEGRAY4 = ManimColor("#528B8B")
DARKTURQUOISE = ManimColor("#00CED1")
DARKVIOLET = ManimColor("#9400D3")
DEEPPINK1 = ManimColor("#FF1493")
DEEPPINK2 = ManimColor("#EE1289")
DEEPPINK3 = ManimColor("#CD1076")
DEEPPINK4 = ManimColor("#8B0A50")
DEEPSKYBLUE1 = ManimColor("#00BFFF")
DEEPSKYBLUE2 = ManimColor("#00B2EE")
DEEPSKYBLUE3 = ManimColor("#009ACD")
DEEPSKYBLUE4 = ManimColor("#00688B")
DIMGRAY = ManimColor("#696969")
DODGERBLUE1 = ManimColor("#1E90FF")
DODGERBLUE2 = ManimColor("#1C86EE")
DODGERBLUE3 = ManimColor("#1874CD")
DODGERBLUE4 = ManimColor("#104E8B")
FIREBRICK = ManimColor("#B22222")
FIREBRICK1 = ManimColor("#FF3030")
FIREBRICK2 = ManimColor("#EE2C2C")
FIREBRICK3 = ManimColor("#CD2626")
FIREBRICK4 = ManimColor("#8B1A1A")
FLORALWHITE = ManimColor("#FFFAF0")
FORESTGREEN = ManimColor("#228B22")
GAINSBORO = ManimColor("#DCDCDC")
GHOSTWHITE = ManimColor("#F8F8FF")
GOLD1 = ManimColor("#FFD700")
GOLD2 = ManimColor("#EEC900")
GOLD3 = ManimColor("#CDAD00")
GOLD4 = ManimColor("#8B7500")
GOLDENROD = ManimColor("#DAA520")
GOLDENROD1 = ManimColor("#FFC125")
GOLDENROD2 = ManimColor("#EEB422")
GOLDENROD3 = ManimColor("#CD9B1D")
GOLDENROD4 = ManimColor("#8B6914")
GRAY = ManimColor("#BEBEBE")
GRAY1 = ManimColor("#030303")
GRAY2 = ManimColor("#050505")
GRAY3 = ManimColor("#080808")
GRAY4 = ManimColor("#0A0A0A")
GRAY5 = ManimColor("#0D0D0D")
GRAY6 = ManimColor("#0F0F0F")
GRAY7 = ManimColor("#121212")
GRAY8 = ManimColor("#141414")
GRAY9 = ManimColor("#171717")
GRAY10 = ManimColor("#1A1A1A")
GRAY11 = ManimColor("#1C1C1C")
GRAY12 = ManimColor("#1F1F1F")
GRAY13 = ManimColor("#212121")
GRAY14 = ManimColor("#242424")
GRAY15 = ManimColor("#262626")
GRAY16 = ManimColor("#292929")
GRAY17 = ManimColor("#2B2B2B")
GRAY18 = ManimColor("#2E2E2E")
GRAY19 = ManimColor("#303030")
GRAY20 = ManimColor("#333333")
GRAY21 = ManimColor("#363636")
GRAY22 = ManimColor("#383838")
GRAY23 = ManimColor("#3B3B3B")
GRAY24 = ManimColor("#3D3D3D")
GRAY25 = ManimColor("#404040")
GRAY26 = ManimColor("#424242")
GRAY27 = ManimColor("#454545")
GRAY28 = ManimColor("#474747")
GRAY29 = ManimColor("#4A4A4A")
GRAY30 = ManimColor("#4D4D4D")
GRAY31 = ManimColor("#4F4F4F")
GRAY32 = ManimColor("#525252")
GRAY33 = ManimColor("#545454")
GRAY34 = ManimColor("#575757")
GRAY35 = ManimColor("#595959")
GRAY36 = ManimColor("#5C5C5C")
GRAY37 = ManimColor("#5E5E5E")
GRAY38 = ManimColor("#616161")
GRAY39 = ManimColor("#636363")
GRAY40 = ManimColor("#666666")
GRAY41 = ManimColor("#696969")
GRAY42 = ManimColor("#6B6B6B")
GRAY43 = ManimColor("#6E6E6E")
GRAY44 = ManimColor("#707070")
GRAY45 = ManimColor("#737373")
GRAY46 = ManimColor("#757575")
GRAY47 = ManimColor("#787878")
GRAY48 = ManimColor("#7A7A7A")
GRAY49 = ManimColor("#7D7D7D")
GRAY50 = ManimColor("#7F7F7F")
GRAY51 = ManimColor("#828282")
GRAY52 = ManimColor("#858585")
GRAY53 = ManimColor("#878787")
GRAY54 = ManimColor("#8A8A8A")
GRAY55 = ManimColor("#8C8C8C")
GRAY56 = ManimColor("#8F8F8F")
GRAY57 = ManimColor("#919191")
GRAY58 = ManimColor("#949494")
GRAY59 = ManimColor("#969696")
GRAY60 = ManimColor("#999999")
GRAY61 = ManimColor("#9C9C9C")
GRAY62 = ManimColor("#9E9E9E")
GRAY63 = ManimColor("#A1A1A1")
GRAY64 = ManimColor("#A3A3A3")
GRAY65 = ManimColor("#A6A6A6")
GRAY66 = ManimColor("#A8A8A8")
GRAY67 = ManimColor("#ABABAB")
GRAY68 = ManimColor("#ADADAD")
GRAY69 = ManimColor("#B0B0B0")
GRAY70 = ManimColor("#B3B3B3")
GRAY71 = ManimColor("#B5B5B5")
GRAY72 = ManimColor("#B8B8B8")
GRAY73 = ManimColor("#BABABA")
GRAY74 = ManimColor("#BDBDBD")
GRAY75 = ManimColor("#BFBFBF")
GRAY76 = ManimColor("#C2C2C2")
GRAY77 = ManimColor("#C4C4C4")
GRAY78 = ManimColor("#C7C7C7")
GRAY79 = ManimColor("#C9C9C9")
GRAY80 = ManimColor("#CCCCCC")
GRAY81 = ManimColor("#CFCFCF")
GRAY82 = ManimColor("#D1D1D1")
GRAY83 = ManimColor("#D4D4D4")
GRAY84 = ManimColor("#D6D6D6")
GRAY85 = ManimColor("#D9D9D9")
GRAY86 = ManimColor("#DBDBDB")
GRAY87 = ManimColor("#DEDEDE")
GRAY88 = ManimColor("#E0E0E0")
GRAY89 = ManimColor("#E3E3E3")
GRAY90 = ManimColor("#E5E5E5")
GRAY91 = ManimColor("#E8E8E8")
GRAY92 = ManimColor("#EBEBEB")
GRAY93 = ManimColor("#EDEDED")
GRAY94 = ManimColor("#F0F0F0")
GRAY95 = ManimColor("#F2F2F2")
GRAY97 = ManimColor("#F7F7F7")
GRAY98 = ManimColor("#FAFAFA")
GRAY99 = ManimColor("#FCFCFC")
GREEN1 = ManimColor("#00FF00")
GREEN2 = ManimColor("#00EE00")
GREEN3 = ManimColor("#00CD00")
GREEN4 = ManimColor("#008B00")
GREENYELLOW = ManimColor("#ADFF2F")
HONEYDEW1 = ManimColor("#F0FFF0")
HONEYDEW2 = ManimColor("#E0EEE0")
HONEYDEW3 = ManimColor("#C1CDC1")
HONEYDEW4 = ManimColor("#838B83")
HOTPINK = ManimColor("#FF69B4")
HOTPINK1 = ManimColor("#FF6EB4")
HOTPINK2 = ManimColor("#EE6AA7")
HOTPINK3 = ManimColor("#CD6090")
HOTPINK4 = ManimColor("#8B3A62")
INDIANRED = ManimColor("#CD5C5C")
INDIANRED1 = ManimColor("#FF6A6A")
INDIANRED2 = ManimColor("#EE6363")
INDIANRED3 = ManimColor("#CD5555")
INDIANRED4 = ManimColor("#8B3A3A")
IVORY1 = ManimColor("#FFFFF0")
IVORY2 = ManimColor("#EEEEE0")
IVORY3 = ManimColor("#CDCDC1")
IVORY4 = ManimColor("#8B8B83")
KHAKI = ManimColor("#F0E68C")
KHAKI1 = ManimColor("#FFF68F")
KHAKI2 = ManimColor("#EEE685")
KHAKI3 = ManimColor("#CDC673")
KHAKI4 = ManimColor("#8B864E")
LAVENDER = ManimColor("#E6E6FA")
LAVENDERBLUSH1 = ManimColor("#FFF0F5")
LAVENDERBLUSH2 = ManimColor("#EEE0E5")
LAVENDERBLUSH3 = ManimColor("#CDC1C5")
LAVENDERBLUSH4 = ManimColor("#8B8386")
LAWNGREEN = ManimColor("#7CFC00")
LEMONCHIFFON1 = ManimColor("#FFFACD")
LEMONCHIFFON2 = ManimColor("#EEE9BF")
LEMONCHIFFON3 = ManimColor("#CDC9A5")
LEMONCHIFFON4 = ManimColor("#8B8970")
LIGHT = ManimColor("#EEDD82")
LIGHTBLUE = ManimColor("#ADD8E6")
LIGHTBLUE1 = ManimColor("#BFEFFF")
LIGHTBLUE2 = ManimColor("#B2DFEE")
LIGHTBLUE3 = ManimColor("#9AC0CD")
LIGHTBLUE4 = ManimColor("#68838B")
LIGHTCORAL = ManimColor("#F08080")
LIGHTCYAN1 = ManimColor("#E0FFFF")
LIGHTCYAN2 = ManimColor("#D1EEEE")
LIGHTCYAN3 = ManimColor("#B4CDCD")
LIGHTCYAN4 = ManimColor("#7A8B8B")
LIGHTGOLDENROD1 = ManimColor("#FFEC8B")
LIGHTGOLDENROD2 = ManimColor("#EEDC82")
LIGHTGOLDENROD3 = ManimColor("#CDBE70")
LIGHTGOLDENROD4 = ManimColor("#8B814C")
LIGHTGOLDENRODYELLOW = ManimColor("#FAFAD2")
LIGHTGRAY = ManimColor("#D3D3D3")
LIGHTPINK = ManimColor("#FFB6C1")
LIGHTPINK1 = ManimColor("#FFAEB9")
LIGHTPINK2 = ManimColor("#EEA2AD")
LIGHTPINK3 = ManimColor("#CD8C95")
LIGHTPINK4 = ManimColor("#8B5F65")
LIGHTSALMON1 = ManimColor("#FFA07A")
LIGHTSALMON2 = ManimColor("#EE9572")
LIGHTSALMON3 = ManimColor("#CD8162")
LIGHTSALMON4 = ManimColor("#8B5742")
LIGHTSEAGREEN = ManimColor("#20B2AA")
LIGHTSKYBLUE = ManimColor("#87CEFA")
LIGHTSKYBLUE1 = ManimColor("#B0E2FF")
LIGHTSKYBLUE2 = ManimColor("#A4D3EE")
LIGHTSKYBLUE3 = ManimColor("#8DB6CD")
LIGHTSKYBLUE4 = ManimColor("#607B8B")
LIGHTSLATEBLUE = ManimColor("#8470FF")
LIGHTSLATEGRAY = ManimColor("#778899")
LIGHTSTEELBLUE = ManimColor("#B0C4DE")
LIGHTSTEELBLUE1 = ManimColor("#CAE1FF")
LIGHTSTEELBLUE2 = ManimColor("#BCD2EE")
LIGHTSTEELBLUE3 = ManimColor("#A2B5CD")
LIGHTSTEELBLUE4 = ManimColor("#6E7B8B")
LIGHTYELLOW1 = ManimColor("#FFFFE0")
LIGHTYELLOW2 = ManimColor("#EEEED1")
LIGHTYELLOW3 = ManimColor("#CDCDB4")
LIGHTYELLOW4 = ManimColor("#8B8B7A")
LIMEGREEN = ManimColor("#32CD32")
LINEN = ManimColor("#FAF0E6")
MAGENTA = ManimColor("#FF00FF")
MAGENTA2 = ManimColor("#EE00EE")
MAGENTA3 = ManimColor("#CD00CD")
MAGENTA4 = ManimColor("#8B008B")
MAROON = ManimColor("#B03060")
MAROON1 = ManimColor("#FF34B3")
MAROON2 = ManimColor("#EE30A7")
MAROON3 = ManimColor("#CD2990")
MAROON4 = ManimColor("#8B1C62")
MEDIUM = ManimColor("#66CDAA")
MEDIUMAQUAMARINE = ManimColor("#66CDAA")
MEDIUMBLUE = ManimColor("#0000CD")
MEDIUMORCHID = ManimColor("#BA55D3")
MEDIUMORCHID1 = ManimColor("#E066FF")
MEDIUMORCHID2 = ManimColor("#D15FEE")
MEDIUMORCHID3 = ManimColor("#B452CD")
MEDIUMORCHID4 = ManimColor("#7A378B")
MEDIUMPURPLE = ManimColor("#9370DB")
MEDIUMPURPLE1 = ManimColor("#AB82FF")
MEDIUMPURPLE2 = ManimColor("#9F79EE")
MEDIUMPURPLE3 = ManimColor("#8968CD")
MEDIUMPURPLE4 = ManimColor("#5D478B")
MEDIUMSEAGREEN = ManimColor("#3CB371")
MEDIUMSLATEBLUE = ManimColor("#7B68EE")
MEDIUMSPRINGGREEN = ManimColor("#00FA9A")
MEDIUMTURQUOISE = ManimColor("#48D1CC")
MEDIUMVIOLETRED = ManimColor("#C71585")
MIDNIGHTBLUE = ManimColor("#191970")
MINTCREAM = ManimColor("#F5FFFA")
MISTYROSE1 = ManimColor("#FFE4E1")
MISTYROSE2 = ManimColor("#EED5D2")
MISTYROSE3 = ManimColor("#CDB7B5")
MISTYROSE4 = ManimColor("#8B7D7B")
MOCCASIN = ManimColor("#FFE4B5")
NAVAJOWHITE1 = ManimColor("#FFDEAD")
NAVAJOWHITE2 = ManimColor("#EECFA1")
NAVAJOWHITE3 = ManimColor("#CDB38B")
NAVAJOWHITE4 = ManimColor("#8B795E")
NAVYBLUE = ManimColor("#000080")
OLDLACE = ManimColor("#FDF5E6")
OLIVEDRAB = ManimColor("#6B8E23")
OLIVEDRAB1 = ManimColor("#C0FF3E")
OLIVEDRAB2 = ManimColor("#B3EE3A")
OLIVEDRAB4 = ManimColor("#698B22")
ORANGE1 = ManimColor("#FFA500")
ORANGE2 = ManimColor("#EE9A00")
ORANGE3 = ManimColor("#CD8500")
ORANGE4 = ManimColor("#8B5A00")
ORANGERED1 = ManimColor("#FF4500")
ORANGERED2 = ManimColor("#EE4000")
ORANGERED3 = ManimColor("#CD3700")
ORANGERED4 = ManimColor("#8B2500")
ORCHID = ManimColor("#DA70D6")
ORCHID1 = ManimColor("#FF83FA")
ORCHID2 = ManimColor("#EE7AE9")
ORCHID3 = ManimColor("#CD69C9")
ORCHID4 = ManimColor("#8B4789")
PALE = ManimColor("#DB7093")
PALEGOLDENROD = ManimColor("#EEE8AA")
PALEGREEN = ManimColor("#98FB98")
PALEGREEN1 = ManimColor("#9AFF9A")
PALEGREEN2 = ManimColor("#90EE90")
PALEGREEN3 = ManimColor("#7CCD7C")
PALEGREEN4 = ManimColor("#548B54")
PALETURQUOISE = ManimColor("#AFEEEE")
PALETURQUOISE1 = ManimColor("#BBFFFF")
PALETURQUOISE2 = ManimColor("#AEEEEE")
PALETURQUOISE3 = ManimColor("#96CDCD")
PALETURQUOISE4 = ManimColor("#668B8B")
PALEVIOLETRED = ManimColor("#DB7093")
PALEVIOLETRED1 = ManimColor("#FF82AB")
PALEVIOLETRED2 = ManimColor("#EE799F")
PALEVIOLETRED3 = ManimColor("#CD6889")
PALEVIOLETRED4 = ManimColor("#8B475D")
PAPAYAWHIP = ManimColor("#FFEFD5")
PEACHPUFF1 = ManimColor("#FFDAB9")
PEACHPUFF2 = ManimColor("#EECBAD")
PEACHPUFF3 = ManimColor("#CDAF95")
PEACHPUFF4 = ManimColor("#8B7765")
PINK = ManimColor("#FFC0CB")
PINK1 = ManimColor("#FFB5C5")
PINK2 = ManimColor("#EEA9B8")
PINK3 = ManimColor("#CD919E")
PINK4 = ManimColor("#8B636C")
PLUM = ManimColor("#DDA0DD")
PLUM1 = ManimColor("#FFBBFF")
PLUM2 = ManimColor("#EEAEEE")
PLUM3 = ManimColor("#CD96CD")
PLUM4 = ManimColor("#8B668B")
POWDERBLUE = ManimColor("#B0E0E6")
PURPLE = ManimColor("#A020F0")
PURPLE1 = ManimColor("#9B30FF")
PURPLE2 = ManimColor("#912CEE")
PURPLE3 = ManimColor("#7D26CD")
PURPLE4 = ManimColor("#551A8B")
RED1 = ManimColor("#FF0000")
RED2 = ManimColor("#EE0000")
RED3 = ManimColor("#CD0000")
RED4 = ManimColor("#8B0000")
ROSYBROWN = ManimColor("#BC8F8F")
ROSYBROWN1 = ManimColor("#FFC1C1")
ROSYBROWN2 = ManimColor("#EEB4B4")
ROSYBROWN3 = ManimColor("#CD9B9B")
ROSYBROWN4 = ManimColor("#8B6969")
ROYALBLUE = ManimColor("#4169E1")
ROYALBLUE1 = ManimColor("#4876FF")
ROYALBLUE2 = ManimColor("#436EEE")
ROYALBLUE3 = ManimColor("#3A5FCD")
ROYALBLUE4 = ManimColor("#27408B")
SADDLEBROWN = ManimColor("#8B4513")
SALMON = ManimColor("#FA8072")
SALMON1 = ManimColor("#FF8C69")
SALMON2 = ManimColor("#EE8262")
SALMON3 = ManimColor("#CD7054")
SALMON4 = ManimColor("#8B4C39")
SANDYBROWN = ManimColor("#F4A460")
SEAGREEN1 = ManimColor("#54FF9F")
SEAGREEN2 = ManimColor("#4EEE94")
SEAGREEN3 = ManimColor("#43CD80")
SEAGREEN4 = ManimColor("#2E8B57")
SEASHELL1 = ManimColor("#FFF5EE")
SEASHELL2 = ManimColor("#EEE5DE")
SEASHELL3 = ManimColor("#CDC5BF")
SEASHELL4 = ManimColor("#8B8682")
SIENNA = ManimColor("#A0522D")
SIENNA1 = ManimColor("#FF8247")
SIENNA2 = ManimColor("#EE7942")
SIENNA3 = ManimColor("#CD6839")
SIENNA4 = ManimColor("#8B4726")
SKYBLUE = ManimColor("#87CEEB")
SKYBLUE1 = ManimColor("#87CEFF")
SKYBLUE2 = ManimColor("#7EC0EE")
SKYBLUE3 = ManimColor("#6CA6CD")
SKYBLUE4 = ManimColor("#4A708B")
SLATEBLUE = ManimColor("#6A5ACD")
SLATEBLUE1 = ManimColor("#836FFF")
SLATEBLUE2 = ManimColor("#7A67EE")
SLATEBLUE3 = ManimColor("#6959CD")
SLATEBLUE4 = ManimColor("#473C8B")
SLATEGRAY = ManimColor("#708090")
SLATEGRAY1 = ManimColor("#C6E2FF")
SLATEGRAY2 = ManimColor("#B9D3EE")
SLATEGRAY3 = ManimColor("#9FB6CD")
SLATEGRAY4 = ManimColor("#6C7B8B")
SNOW1 = ManimColor("#FFFAFA")
SNOW2 = ManimColor("#EEE9E9")
SNOW3 = ManimColor("#CDC9C9")
SNOW4 = ManimColor("#8B8989")
SPRINGGREEN1 = ManimColor("#00FF7F")
SPRINGGREEN2 = ManimColor("#00EE76")
SPRINGGREEN3 = ManimColor("#00CD66")
SPRINGGREEN4 = ManimColor("#008B45")
STEELBLUE = ManimColor("#4682B4")
STEELBLUE1 = ManimColor("#63B8FF")
STEELBLUE2 = ManimColor("#5CACEE")
STEELBLUE3 = ManimColor("#4F94CD")
STEELBLUE4 = ManimColor("#36648B")
TAN = ManimColor("#D2B48C")
TAN1 = ManimColor("#FFA54F")
TAN2 = ManimColor("#EE9A49")
TAN3 = ManimColor("#CD853F")
TAN4 = ManimColor("#8B5A2B")
THISTLE = ManimColor("#D8BFD8")
THISTLE1 = ManimColor("#FFE1FF")
THISTLE2 = ManimColor("#EED2EE")
THISTLE3 = ManimColor("#CDB5CD")
THISTLE4 = ManimColor("#8B7B8B")
TOMATO1 = ManimColor("#FF6347")
TOMATO2 = ManimColor("#EE5C42")
TOMATO3 = ManimColor("#CD4F39")
TOMATO4 = ManimColor("#8B3626")
TURQUOISE = ManimColor("#40E0D0")
TURQUOISE1 = ManimColor("#00F5FF")
TURQUOISE2 = ManimColor("#00E5EE")
TURQUOISE3 = ManimColor("#00C5CD")
TURQUOISE4 = ManimColor("#00868B")
VIOLET = ManimColor("#EE82EE")
VIOLETRED = ManimColor("#D02090")
VIOLETRED1 = ManimColor("#FF3E96")
VIOLETRED2 = ManimColor("#EE3A8C")
VIOLETRED3 = ManimColor("#CD3278")
VIOLETRED4 = ManimColor("#8B2252")
WHEAT = ManimColor("#F5DEB3")
WHEAT1 = ManimColor("#FFE7BA")
WHEAT2 = ManimColor("#EED8AE")
WHEAT3 = ManimColor("#CDBA96")
WHEAT4 = ManimColor("#8B7E66")
WHITE = ManimColor("#FFFFFF")
WHITESMOKE = ManimColor("#F5F5F5")
YELLOW1 = ManimColor("#FFFF00")
YELLOW2 = ManimColor("#EEEE00")
YELLOW3 = ManimColor("#CDCD00")
YELLOW4 = ManimColor("#8B8B00")
YELLOWGREEN = ManimColor("#9ACD32")
