/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.vhdl.gui;

import com.cburch.logisim.proj.Project;
import com.cburch.logisim.util.SmartScroller;
import com.cburch.logisim.vhdl.sim.VhdlSimulatorListener;
import com.cburch.logisim.vhdl.sim.VhdlSimulatorTop;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class VhdlSimulatorConsole
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JLabel label = new JLabel();
    private final JScrollPane log = new JScrollPane();
    private final JTextArea logContent = new JTextArea();
    private final VhdlSimState vhdlSimState;
    private final Project project;

    public VhdlSimulatorConsole(Project proj) {
        this.project = proj;
        this.setLayout(new BorderLayout());
        this.label.setText("VHDL simulator log");
        this.add((Component)this.label, "First");
        this.logContent.setEditable(false);
        this.log.setViewportView(this.logContent);
        new SmartScroller(this.log);
        this.add((Component)this.log, "Center");
        this.vhdlSimState = new VhdlSimState();
        this.vhdlSimState.stateChanged();
        this.project.getVhdlSimulator().addVhdlSimStateListener(this.vhdlSimState);
        this.add((Component)this.vhdlSimState, "Last");
    }

    public void append(String s) {
        this.logContent.append(s);
    }

    public void clear() {
        this.logContent.setText("");
    }

    private class VhdlSimState
    extends JPanel
    implements VhdlSimulatorListener {
        private static final long serialVersionUID = 1L;
        final Ellipse2D.Double circle;
        Color color;
        private final int margin = 5;

        public VhdlSimState() {
            int radius = 15;
            this.circle = new Ellipse2D.Double(5.0, 5.0, radius, radius);
            this.setOpaque(false);
            this.color = Color.GRAY;
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
        }

        @Override
        public Dimension getPreferredSize() {
            Rectangle bounds = this.circle.getBounds();
            return new Dimension(bounds.width + 10, bounds.height + 10);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(this.color);
            g2.fill(this.circle);
        }

        @Override
        public void stateChanged() {
            VhdlSimulatorTop vsim = VhdlSimulatorConsole.this.project.getVhdlSimulator();
            switch (vsim.getState()) {
                case DISABLED: {
                    this.color = Color.GRAY;
                    break;
                }
                case ENABLED: {
                    this.color = Color.RED;
                    break;
                }
                case STARTING: {
                    this.color = Color.ORANGE;
                    break;
                }
                case RUNNING: {
                    this.color = new Color(40, 180, 40);
                }
            }
            this.repaint();
        }
    }
}

