/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import com.cburch.logisim.data.Direction;
import com.cburch.logisim.prefs.AppPreferences;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class IconsUtil {
    private static final String PATH = "resources/logisim/icons";

    private IconsUtil() {
        throw new IllegalStateException("Utility class. No instantiation allowed.");
    }

    public static ImageIcon getIcon(String name) {
        URL url = IconsUtil.class.getClassLoader().getResource("resources/logisim/icons/" + name);
        if (url == null) {
            return null;
        }
        ImageIcon icon = new ImageIcon(url);
        icon.setImage(icon.getImage().getScaledInstance(AppPreferences.getScaled(16), AppPreferences.getScaled(16), 4));
        return icon;
    }

    public static void paintRotated(Graphics g, int x, int y, Direction dir, Icon icon, Component dest) {
        if (!(g instanceof Graphics2D) || dir == Direction.EAST) {
            icon.paintIcon(dest, g, x, y);
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        double cx = (double)x + (double)icon.getIconWidth() / 2.0;
        double cy = (double)y + (double)icon.getIconHeight() / 2.0;
        if (dir == Direction.WEST) {
            g2.rotate(Math.PI, cx, cy);
        } else if (dir == Direction.NORTH) {
            g2.rotate(-1.5707963267948966, cx, cy);
        } else if (dir == Direction.SOUTH) {
            g2.rotate(1.5707963267948966, cx, cy);
        } else {
            g2.translate(-x, -y);
        }
        icon.paintIcon(dest, g2, x, y);
        g2.dispose();
    }
}

