/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.wiring;

import com.cburch.logisim.circuit.SplitterFactory;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.wiring.BitExtender;
import com.cburch.logisim.std.wiring.Clock;
import com.cburch.logisim.std.wiring.Constant;
import com.cburch.logisim.std.wiring.DoNotConnect;
import com.cburch.logisim.std.wiring.Ground;
import com.cburch.logisim.std.wiring.Pin;
import com.cburch.logisim.std.wiring.Power;
import com.cburch.logisim.std.wiring.PowerOnReset;
import com.cburch.logisim.std.wiring.Probe;
import com.cburch.logisim.std.wiring.PullResistor;
import com.cburch.logisim.std.wiring.Transistor;
import com.cburch.logisim.std.wiring.TransmissionGate;
import com.cburch.logisim.std.wiring.Tunnel;
import com.cburch.logisim.tools.AddTool;
import com.cburch.logisim.tools.FactoryDescription;
import com.cburch.logisim.tools.Library;
import com.cburch.logisim.tools.Tool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class WiringLibrary
extends Library {
    public static final String _ID = "Wiring";
    private static final Tool[] ADD_TOOLS = new Tool[]{new AddTool(SplitterFactory.instance), new AddTool(Pin.FACTORY), new AddTool(Probe.FACTORY), new AddTool(Tunnel.FACTORY), new AddTool(PullResistor.FACTORY), new AddTool(Clock.FACTORY), new AddTool(PowerOnReset.FACTORY), new AddTool(Constant.FACTORY)};
    private static final FactoryDescription[] DESCRIPTIONS = new FactoryDescription[]{new FactoryDescription(Power.class, Strings.S.getter("powerComponent"), "power.gif"), new FactoryDescription(Ground.class, Strings.S.getter("groundComponent"), "ground.gif"), new FactoryDescription(DoNotConnect.class, Strings.S.getter("noConnectionComponent"), "noconnect.gif"), new FactoryDescription(Transistor.class, Strings.S.getter("transistorComponent"), "trans0.gif"), new FactoryDescription(TransmissionGate.class, Strings.S.getter("transmissionGateComponent"), "transmis.gif"), new FactoryDescription(BitExtender.class, Strings.S.getter("extenderComponent"), "extender.gif")};
    private List<Tool> tools = null;

    @Override
    public String getDisplayName() {
        return Strings.S.get("wiringLibrary");
    }

    public List<Tool> getTools() {
        if (this.tools == null) {
            ArrayList<Tool> ret = new ArrayList<Tool>(ADD_TOOLS.length + DESCRIPTIONS.length);
            ret.addAll(Arrays.asList(ADD_TOOLS));
            ret.addAll(FactoryDescription.getTools(WiringLibrary.class, DESCRIPTIONS));
            this.tools = ret;
        }
        return this.tools;
    }
}

