/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.fpga.hdlgenerator.WithSelectHdlGenerator;
import com.cburch.logisim.std.ttl.TtlLibrary;
import com.cburch.logisim.util.LineBuffer;

public class Ttl7485HdlGenerator
extends AbstractHdlGeneratorFactory {
    public Ttl7485HdlGenerator() {
        this.myWires.addWire("oppA", 4).addWire("oppB", 4).addWire("gt", 1).addWire("eq", 1).addWire("lt", 1).addWire("compIn", 3).addWire("compOut", 3);
        this.myPorts.add("input", "A0", 1, 8).add("input", "A1", 1, 10).add("input", "A2", 1, 11).add("input", "A3", 1, 13).add("input", "B0", 1, 7).add("input", "B1", 1, 9).add("input", "B2", 1, 12).add("input", "B3", 1, 0).add("input", "AltBin", 1, 1).add("input", "AeqBin", 1, 2).add("input", "AgtBin", 1, 3).add("output", "AltBout", 1, 6).add("output", "AeqBout", 1, 5).add("output", "AgtBout", 1, 4);
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist netlist, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getHdlBuffer();
        WithSelectHdlGenerator decoder = new WithSelectHdlGenerator("dec1", "compIn", 3, "compOut", 3).setDefault("001").add("100", "100").add("010", "010").add("110", "000").add("000", "110");
        contents.add(decoder.getHdlCode()).empty();
        if (Hdl.isVhdl()) {
            contents.addVhdlKeywords().add("oppA   <= A3&A2&A1&A0;\noppB   <= B3&B2&B1&B0;\ngt     <= '1' {{when}} unsigned(oppA) > unsigned(oppB) {{else}} '0';\neq     <= '1' {{when}} unsigned(oppA) = unsigned(oppB) {{else}} '0';\nlt     <= '1' {{when}} unsigned(oppA) < unsigned(oppB) {{else}} '0';\n\ncompIn <= AgtBin&AltBin&AeqBin;\n\nAgtBout <= '1' {{when}} gt = '1' {{else}} '0' {{when}} lt = '1' {{else}} compOut(2);\nAltBout <= '0' {{when}} gt = '1' {{else}} '1' {{when}} lt = '1' {{else}} compOut(1);\nAeqBout <= '0' {{when}} (gt = '1') {{or}} (lt = '1') {{else}} compOut(0);\n");
        } else {
            contents.add("assign oppA    = {A3, A2, A1, A0};\nassign oppB    = {B3, B2, B1, B0};\nassign gt      = oppA > oppB ? 1 : 0;\nassign eq      = oppA == oppB ? 1 : 0;\nassign lt      = oppA < oppB ? 1 : 0;\nassign compIn  = {AgtBin, AltBin, AeqBin};\nassign AgtBout = gt == 1 ? 1 : lt == 1 ? 0 : compOut[2];\nassign AltBout = gt == 1 ? 0 : lt == 1 ? 1 : compOut[1];\nassign AeqBout = gt == 1 || lt == 1 ? 0 : compOut[0];\n");
        }
        return contents.empty();
    }

    @Override
    public boolean isHdlSupportedTarget(AttributeSet attrs) {
        if (attrs == null) {
            return false;
        }
        return attrs.getValue(TtlLibrary.VCC_GND) == false;
    }
}

