/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.StdAttr;

class ClockState
implements Cloneable {
    private Value lastClock = Value.FALSE;

    public ClockState clone() {
        try {
            return (ClockState)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    private boolean isTriggered(Value oldClock, Value newClock, Object trigger) {
        if (trigger == null || trigger == StdAttr.TRIG_RISING) {
            return oldClock == Value.FALSE && newClock == Value.TRUE;
        }
        if (trigger == StdAttr.TRIG_FALLING) {
            return oldClock == Value.TRUE && newClock == Value.FALSE;
        }
        if (trigger == StdAttr.TRIG_HIGH) {
            return newClock == Value.TRUE;
        }
        if (trigger == StdAttr.TRIG_LOW) {
            return newClock == Value.FALSE;
        }
        return oldClock == Value.FALSE && newClock == Value.TRUE;
    }

    public boolean updateClock(Value newClock, int which, Object trigger) {
        if (newClock == null || newClock == Value.NIL) {
            return false;
        }
        if (this.lastClock.getWidth() <= which) {
            this.lastClock = this.lastClock.extendWidth(which + 1, Value.FALSE);
        }
        Value oldClock = this.lastClock.get(which);
        this.lastClock = this.lastClock.set(which, newClock);
        return this.isTriggered(oldClock, newClock, trigger);
    }

    public boolean updateClock(Value newClock, int which) {
        return this.updateClock(newClock, which, StdAttr.TRIG_RISING);
    }

    public boolean updateClock(Value newClock, Object trigger) {
        return this.updateClock(newClock, 0, trigger);
    }

    public boolean updateClock(Value newClock) {
        return this.updateClock(newClock, 0, StdAttr.TRIG_RISING);
    }
}

