/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.memory.MemContents;
import java.util.Random;

class MemContentsSub {
    static MemContents.Page createPage(int size, int bits, boolean randomize) {
        long mask;
        long l = mask = bits == 64 ? -1L : (1L << bits) - 1L;
        if (bits <= 8) {
            return new BytePage(size, mask, randomize);
        }
        if (bits <= 16) {
            return new ShortPage(size, mask, randomize);
        }
        if (bits <= 32) {
            return new IntPage(size, mask, randomize);
        }
        return new LongPage(size, mask, randomize);
    }

    private MemContentsSub() {
    }

    private static class BytePage
    extends MemContents.Page {
        private byte[] data;

        public BytePage(int size, long mask, boolean randomize) {
            this.data = new byte[size];
            if (AppPreferences.Memory_Startup_Unknown.get().booleanValue() && randomize) {
                Random generator = new Random();
                for (int i = 0; i < size; ++i) {
                    this.data[i] = (byte)((long)generator.nextInt(256) & mask);
                }
            }
        }

        @Override
        public BytePage clone() {
            BytePage ret = (BytePage)super.clone();
            ret.data = new byte[this.data.length];
            System.arraycopy(this.data, 0, ret.data, 0, this.data.length);
            return ret;
        }

        @Override
        long get(long addr) {
            return addr >= 0L && addr < (long)this.data.length ? (long)this.data[(int)addr] : 0L;
        }

        @Override
        int getLength() {
            return this.data.length;
        }

        @Override
        void load(long start, long[] values, long mask) {
            int n = Math.min(values.length, this.data.length - (int)start);
            for (int i = 0; i < n; ++i) {
                this.data[(int)start + i] = (byte)(values[i] & mask);
            }
        }

        @Override
        void set(long addr, long value) {
            byte oldValue;
            if (addr >= 0L && addr < (long)this.data.length && value != (long)(oldValue = this.data[(int)addr])) {
                this.data[(int)addr] = (byte)value;
            }
        }
    }

    private static class ShortPage
    extends MemContents.Page {
        private short[] data;

        public ShortPage(int size, long mask, boolean randomize) {
            this.data = new short[size];
            if (AppPreferences.Memory_Startup_Unknown.get().booleanValue() && randomize) {
                Random generator = new Random();
                for (int i = 0; i < size; ++i) {
                    this.data[i] = (short)((long)generator.nextInt(65536) & mask);
                }
            }
        }

        @Override
        public ShortPage clone() {
            ShortPage ret = (ShortPage)super.clone();
            ret.data = new short[this.data.length];
            System.arraycopy(this.data, 0, ret.data, 0, this.data.length);
            return ret;
        }

        @Override
        long get(long addr) {
            return addr >= 0L && addr < (long)this.data.length ? (long)this.data[(int)addr] : 0L;
        }

        @Override
        int getLength() {
            return this.data.length;
        }

        @Override
        void load(long start, long[] values, long mask) {
            int n = Math.min(values.length, this.data.length - (int)start);
            for (int i = (int)start; i < n; ++i) {
                this.data[(int)start + i] = (short)(values[i] & mask);
            }
        }

        @Override
        void set(long addr, long value) {
            short oldValue;
            if (addr >= 0L && addr < (long)this.data.length && value != (long)(oldValue = this.data[(int)addr])) {
                this.data[(int)addr] = (short)value;
            }
        }
    }

    private static class IntPage
    extends MemContents.Page {
        private int[] data;

        public IntPage(int size, long mask, boolean randomize) {
            this.data = new int[size];
            if (AppPreferences.Memory_Startup_Unknown.get().booleanValue() && randomize) {
                Random generator = new Random();
                for (int i = 0; i < size; ++i) {
                    this.data[i] = (int)((long)generator.nextInt() & mask);
                }
            }
        }

        @Override
        public IntPage clone() {
            IntPage ret = (IntPage)super.clone();
            ret.data = new int[this.data.length];
            System.arraycopy(this.data, 0, ret.data, 0, this.data.length);
            return ret;
        }

        @Override
        long get(long addr) {
            return addr >= 0L && addr < (long)this.data.length ? (long)this.data[(int)addr] : 0L;
        }

        @Override
        int getLength() {
            return this.data.length;
        }

        @Override
        void load(long start, long[] values, long mask) {
            int n = Math.min(values.length, this.data.length - (int)start);
            for (int i = 0; i < n; ++i) {
                this.data[(int)start + i] = (int)(values[i] & mask);
            }
        }

        @Override
        void set(long addr, long value) {
            int oldValue;
            if (addr >= 0L && addr < (long)this.data.length && value != (long)(oldValue = this.data[(int)addr])) {
                this.data[(int)addr] = (int)value;
            }
        }
    }

    private static class LongPage
    extends MemContents.Page {
        private long[] data;

        public LongPage(int size, long mask, boolean randomize) {
            this.data = new long[size];
            if (AppPreferences.Memory_Startup_Unknown.get().booleanValue() && randomize) {
                Random generator = new Random();
                for (int i = 0; i < size; ++i) {
                    this.data[i] = (long)((int)generator.nextLong()) & mask;
                }
            }
        }

        @Override
        public LongPage clone() {
            LongPage ret = (LongPage)super.clone();
            ret.data = new long[this.data.length];
            System.arraycopy(this.data, 0, ret.data, 0, this.data.length);
            return ret;
        }

        @Override
        long get(long addr) {
            return addr >= 0L && addr < (long)this.data.length ? this.data[(int)addr] : 0L;
        }

        @Override
        int getLength() {
            return this.data.length;
        }

        @Override
        void load(long start, long[] values, long mask) {
            int n = Math.min(values.length, this.data.length - (int)start);
            for (int i = 0; i < n; ++i) {
                this.data[(int)start + i] = values[i] & mask;
            }
        }

        @Override
        void set(long addr, long value) {
            long oldValue;
            if (addr >= 0L && addr < (long)this.data.length && value != (oldValue = this.data[(int)addr])) {
                this.data[(int)addr] = value;
            }
        }
    }
}

