/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.logisim.data.AbstractAttributeSet;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.AttributeSets;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.memory.Counter;
import java.util.List;
import java.util.Objects;

class CounterAttributes
extends AbstractAttributeSet {
    private AttributeSet base = AttributeSets.fixedSet(new Attribute[]{StdAttr.WIDTH, Counter.ATTR_MAX, Counter.ATTR_ON_GOAL, StdAttr.EDGE_TRIGGER, StdAttr.LABEL, StdAttr.LABEL_FONT, StdAttr.LABEL_LOC, StdAttr.APPEARANCE}, new Object[]{BitWidth.create(8), 255L, Counter.ON_GOAL_WRAP, StdAttr.TRIG_RISING, "", StdAttr.DEFAULT_LABEL_FONT, Direction.NORTH, AppPreferences.getDefaultAppearance()});

    @Override
    public boolean containsAttribute(Attribute<?> attr) {
        return this.base.containsAttribute(attr);
    }

    @Override
    public void copyInto(AbstractAttributeSet dest) {
        ((CounterAttributes)dest).base = (AttributeSet)this.base.clone();
    }

    @Override
    public Attribute<?> getAttribute(String name) {
        return this.base.getAttribute(name);
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return this.base.getAttributes();
    }

    @Override
    public <V> V getValue(Attribute<V> attr) {
        return this.base.getValue(attr);
    }

    @Override
    public boolean isReadOnly(Attribute<?> attr) {
        return this.base.isReadOnly(attr);
    }

    @Override
    public void setReadOnly(Attribute<?> attr, boolean value) {
        this.base.setReadOnly(attr, value);
    }

    @Override
    public <V> void setValue(Attribute<V> attr, V value) {
        BitWidth width;
        V oldValue = this.base.getValue(attr);
        if (Objects.equals(oldValue, value)) {
            return;
        }
        Object newValue = value;
        if (attr == StdAttr.WIDTH) {
            long newMax;
            BitWidth oldWidth = (BitWidth)oldValue;
            BitWidth newWidth = (BitWidth)newValue;
            long mask = newWidth.getMask();
            Long oldMax = this.base.getValue(Counter.ATTR_MAX);
            long l = newMax = newWidth.getWidth() < oldWidth.getWidth() ? mask & oldMax : mask;
            if (oldMax != newMax) {
                this.base.setValue(Counter.ATTR_MAX, newMax);
                this.fireAttributeValueChanged(Counter.ATTR_MAX, newMax, oldMax);
            }
        } else if (attr == Counter.ATTR_MAX && Objects.equals(oldValue, newValue = Long.valueOf((width = this.base.getValue(StdAttr.WIDTH)).getMask() & (Long)newValue))) {
            return;
        }
        this.base.setValue(attr, newValue);
        this.fireAttributeValueChanged(attr, newValue, oldValue);
    }

    @Override
    public <V> List<Attribute<?>> attributesMayAlsoBeChanged(Attribute<V> attr, V value) {
        if (attr != StdAttr.WIDTH || Objects.equals(this.base.getValue(attr), value)) {
            return null;
        }
        return List.of(Counter.ATTR_MAX);
    }
}

