/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io.extra;

import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.util.LocaleManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class ProgrammableGeneratorState
implements InstanceData,
Cloneable {
    Value sending = Value.FALSE;
    private int[] durationHigh;
    private int[] durationLow;
    private String SavedData = "";
    private int ticks;
    private int currentstate;
    private JTextField[] inputs;

    public ProgrammableGeneratorState(int i) {
        this.durationHigh = new int[i];
        this.durationLow = new int[i];
        this.clearValues();
    }

    public void clearValues() {
        this.ticks = 0;
        this.currentstate = 0;
        for (int i = 0; i < this.durationHigh.length; i = (int)((byte)(i + 1))) {
            this.durationHigh[i] = 1;
            this.durationLow[i] = 1;
        }
        this.SavedData = "";
    }

    @Override
    public ProgrammableGeneratorState clone() {
        try {
            return (ProgrammableGeneratorState)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void decodeSavedData(String s) {
        if (s == null || s.equals("")) {
            return;
        }
        String[] data = s.split(" ");
        int cnt = 0;
        for (String datum : data) {
            int value;
            if (datum.contains("*")) {
                String[] tmp = datum.split("\\*");
                for (int j = 0; j < Integer.parseInt(tmp[1]); ++j) {
                    value = Integer.parseInt(tmp[0]);
                    this.writeData(value, cnt);
                    ++cnt;
                }
                continue;
            }
            value = Integer.parseInt(datum);
            this.writeData(value, cnt);
            ++cnt;
        }
    }

    public void editWindow() {
        this.inputs = new JTextField[this.durationHigh.length * 2];
        Object[] options = new String[]{new LocaleManager("resources/logisim", "gui").get("saveOption"), Strings.S.get("ramClearMenuItem")};
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        Insets inset = new Insets(5, 0, 5, 0);
        Font state = new Font("SansSerif", 1, 18);
        JLabel up = new JLabel("<html><div style='text-align:center'>" + Strings.S.get("clockHighAttr") + "<br>(" + Strings.S.get("clockDurationValue", "") + ")</div></html>");
        gbc.ipadx = 10;
        gbc.ipady = 5;
        gbc.gridx = 1;
        gbc.anchor = 10;
        gbc.insets = inset;
        panel.add((Component)up, gbc);
        JLabel down = new JLabel("<html><div style='text-align:center'>" + Strings.S.get("clockLowAttr") + "<br>(" + Strings.S.get("clockDurationValue", "") + ")</div></html>");
        gbc.gridx = 2;
        panel.add((Component)down, gbc);
        for (int i = 0; i < this.inputs.length; i += 2) {
            JLabel statenumber = new JLabel(String.valueOf(i / 2 + 1));
            statenumber.setFont(state);
            statenumber.setForeground(Color.DARK_GRAY);
            gbc.gridx = 0;
            gbc.gridy = i + 1;
            panel.add((Component)statenumber, gbc);
            this.inputs[i] = new JTextField(String.valueOf(this.getdurationHigh(i / 2)), 3);
            this.inputs[i].setHorizontalAlignment(0);
            gbc.gridx = 1;
            panel.add((Component)this.inputs[i], gbc);
            this.inputs[i + 1] = new JTextField(String.valueOf(this.getdurationLow(i / 2)), 3);
            this.inputs[i + 1].setHorizontalAlignment(0);
            gbc.gridx = 2;
            panel.add((Component)this.inputs[i + 1], gbc);
        }
        JScrollPane scrollable = new JScrollPane(panel);
        scrollable.setPreferredSize(new Dimension(250, 250));
        scrollable.setBorder(null);
        scrollable.getVerticalScrollBar().setUnitIncrement(13);
        int option = OptionPane.showOptionDialog(null, scrollable, Strings.S.getter("ProgrammableGeneratorComponent").toString(), 2, -1, null, options, null);
        if (option == 0) {
            this.saveValues(this.inputs);
            this.saveData();
        } else if (option == 1) {
            this.clearValues();
            this.editWindow();
        }
    }

    private int getdurationHigh(int i) {
        return this.durationHigh[i];
    }

    public int getdurationHighValue() {
        return this.durationHigh[this.currentstate];
    }

    private int getdurationLow(int i) {
        return this.durationLow[i];
    }

    public int getdurationLowValue() {
        return this.durationLow[this.currentstate];
    }

    public String getSavedData() {
        return this.SavedData;
    }

    public int getStateTick() {
        return this.ticks;
    }

    public void incrementCurrentState() {
        this.ticks = 1;
        ++this.currentstate;
        if (this.currentstate >= this.durationHigh.length) {
            this.currentstate = 0;
        }
    }

    public void incrementTicks() {
        ++this.ticks;
        if (this.ticks > this.getdurationHighValue() + this.getdurationLowValue()) {
            this.incrementCurrentState();
        }
    }

    public void saveData() {
        int size = this.durationHigh.length * 2;
        int count = 0;
        StringBuilder data = new StringBuilder();
        String last = "x";
        boolean dirty = false;
        for (int i = 0; i < size; ++i) {
            String val = i < this.durationHigh.length ? String.valueOf(this.getdurationHigh(i)) : String.valueOf(this.getdurationLow(i - this.durationHigh.length));
            if (!dirty && !val.equals("1")) {
                dirty = true;
            }
            if (val.equals(last)) {
                ++count;
            } else if (last.equals("x")) {
                last = val;
                ++count;
            }
            if (val.equals(last) && i != size - 1) continue;
            if (count >= 3) {
                data.append(last).append("*").append(count).append(" ");
            } else {
                for (int j = 0; j < count; ++j) {
                    data.append(last).append(" ");
                }
            }
            if (!val.equals(last) && i == size - 1) {
                data.append(val).append(" ");
            }
            count = 1;
            last = val;
        }
        if (!dirty) {
            data = new StringBuilder();
        }
        this.SavedData = data.toString();
    }

    private void saveValues(JTextField[] inputs) {
        for (int i = 0; i < inputs.length; i = (int)((byte)(i + 1))) {
            StringBuilder onlynumber = new StringBuilder();
            int value = 0;
            for (int j = 0; j < inputs[i].getText().length(); j = (int)((byte)(j + 1))) {
                if (!Character.isDigit(inputs[i].getText().charAt(j))) continue;
                onlynumber.append(inputs[i].getText().charAt(j));
            }
            if (onlynumber.length() != 0) {
                value = Integer.parseInt(onlynumber.toString());
            }
            if (value < true) continue;
            if (i % 2 == 0) {
                this.setdurationHigh(i / 2, value);
                continue;
            }
            this.setdurationLow(i / 2, value);
        }
    }

    public void setdurationHigh(int i, int value) {
        if (value != this.getdurationHigh(i)) {
            this.durationHigh[i] = value;
        }
    }

    public void setdurationLow(int i, int value) {
        if (value != this.getdurationLow(i)) {
            this.durationLow[i] = value;
        }
    }

    public boolean updateSize(int newsize) {
        if (newsize != this.durationHigh.length) {
            int[] oldDurationHigh = Arrays.copyOf(this.durationHigh, this.durationHigh.length);
            int[] oldDurationLow = Arrays.copyOf(this.durationLow, this.durationLow.length);
            this.durationHigh = new int[newsize];
            this.durationLow = new int[newsize];
            this.clearValues();
            int lowerlength = Math.min(oldDurationHigh.length, newsize);
            for (int i = 0; i < lowerlength; i = (int)((byte)(i + 1))) {
                this.durationHigh[i] = oldDurationHigh[i];
                this.durationLow[i] = oldDurationLow[i];
            }
            this.saveData();
            return true;
        }
        return false;
    }

    private void writeData(int value, int cnt) {
        if (cnt < this.durationHigh.length) {
            this.setdurationHigh(cnt, value);
        } else if (cnt < this.durationHigh.length + this.durationLow.length) {
            this.setdurationLow(cnt - this.durationHigh.length, value);
        }
    }
}

