/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.fpga.data.FpgaIoInformationContainer;
import com.cburch.logisim.fpga.data.LedArrayDriving;
import com.cburch.logisim.fpga.data.MapComponent;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.std.io.IoLibrary;
import com.cburch.logisim.std.io.LedArrayColumnScanningHdlGeneratorFactory;
import com.cburch.logisim.std.io.LedArrayLedDefaultHdlGeneratorFactory;
import com.cburch.logisim.std.io.LedArrayRowScanningHdlGeneratorFactory;
import com.cburch.logisim.std.io.RgbArrayColumnScanningHdlGeneratorFactory;
import com.cburch.logisim.std.io.RgbArrayLedDefaultHdlGeneratorFactory;
import com.cburch.logisim.std.io.RgbArrayRowScanningHdlGeneratorFactory;
import com.cburch.logisim.std.io.RgbLed;
import com.cburch.logisim.util.LineBuffer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class LedArrayGenericHdlGeneratorFactory {
    public static String LedArrayOutputs = "externalLeds";
    public static String LedArrayRedOutputs = "externalRedLeds";
    public static String LedArrayGreenOutputs = "externalGreenLeds";
    public static String LedArrayBlueOutputs = "externalBlueLeds";
    public static String LedArrayRowOutputs = "rowLeds";
    public static String LedArrayRowRedOutputs = "rowRedLeds";
    public static String LedArrayRowGreenOutputs = "rowGreenLeds";
    public static String LedArrayRowBlueOutputs = "rowBlueLeds";
    public static String LedArrayRowAddress = "rowAddress";
    public static String LedArrayColumnOutputs = "columnLeds";
    public static String LedArrayColumnRedOutputs = "columnRedLeds";
    public static String LedArrayColumnGreenOutputs = "columnGreenLeds";
    public static String LedArrayColumnBlueOutputs = "columnBlueLeds";
    public static String LedArrayColumnAddress = "columnAddress";
    public static String LedArrayInputs = "internalLeds";
    public static String LedArrayRedInputs = "internalRedLeds";
    public static String LedArrayGreenInputs = "internalGreenLeds";
    public static String LedArrayBlueInputs = "internalBlueLeds";

    public static AbstractHdlGeneratorFactory getSpecificHDLGenerator(String type) {
        char typeId = LedArrayDriving.getId(type);
        return switch (typeId) {
            case '\u0000' -> new LedArrayLedDefaultHdlGeneratorFactory();
            case '\u0001' -> new LedArrayRowScanningHdlGeneratorFactory();
            case '\u0002' -> new LedArrayColumnScanningHdlGeneratorFactory();
            case '\u0003' -> new RgbArrayLedDefaultHdlGeneratorFactory();
            case '\u0004' -> new RgbArrayRowScanningHdlGeneratorFactory();
            case '\u0005' -> new RgbArrayColumnScanningHdlGeneratorFactory();
            default -> null;
        };
    }

    public static String getSpecificHDLName(char typeId) {
        return switch (typeId) {
            case '\u0000' -> "LedArrayLedDefault";
            case '\u0001' -> "LedArrayRowScanning";
            case '\u0002' -> "LedArrayColumnScanning";
            case '\u0003' -> "RGBArrayLedDefault";
            case '\u0004' -> "RGBArrayRowScanning";
            case '\u0005' -> "RGBArrayColumnScanning";
            default -> null;
        };
    }

    public static String getSpecificHDLName(String type) {
        return LedArrayGenericHdlGeneratorFactory.getSpecificHDLName(LedArrayDriving.getId(type));
    }

    public static int getNrOfBitsRequired(int value) {
        double nrBitsDouble = Math.log(value) / Math.log(2.0);
        return (int)Math.ceil(nrBitsDouble);
    }

    public static String getExternalSignalName(char typeId, int nrOfRows, int nrOfColumns, int identifier, int pinNr) {
        int nrRowAddressBits = LedArrayGenericHdlGeneratorFactory.getNrOfBitsRequired(nrOfRows);
        int nrColumnAddressBits = LedArrayGenericHdlGeneratorFactory.getNrOfBitsRequired(nrOfColumns);
        switch (typeId) {
            case '\u0000': {
                return LineBuffer.format("{{1}}{{2}}[{{3}}]", LedArrayOutputs, identifier, pinNr);
            }
            case '\u0001': {
                return pinNr < nrRowAddressBits ? LineBuffer.format("{{1}}{{2}}[{{3}}]", LedArrayRowAddress, identifier, pinNr) : LineBuffer.format("{{1}}{{2}}[{{3}}]", LedArrayColumnOutputs, identifier, pinNr - nrRowAddressBits);
            }
            case '\u0002': {
                return pinNr < nrColumnAddressBits ? LineBuffer.format("{{1}}{{2}}[{{3}}]", LedArrayColumnAddress, identifier, pinNr) : LineBuffer.format("{{1}}{{2}}[{{3}}]", LedArrayRowOutputs, identifier, pinNr - nrColumnAddressBits);
            }
            case '\u0003': {
                int index = pinNr % 3;
                int col = pinNr / 3;
                return switch (col) {
                    case 0 -> LineBuffer.format("{{1}}{{2}}[{{3}}]", LedArrayRedOutputs, identifier, index);
                    case 1 -> LineBuffer.format("{{1}}{{2}}[{{3}}]", LedArrayGreenOutputs, identifier, index);
                    case 2 -> LineBuffer.format("{{1}}{{2}}[{{3}}]", LedArrayBlueOutputs, identifier, index);
                    default -> "";
                };
            }
            case '\u0004': {
                int index = (pinNr - nrRowAddressBits) % nrOfColumns;
                int col = (pinNr - nrRowAddressBits) / nrOfColumns;
                if (pinNr < nrRowAddressBits) {
                    return LineBuffer.format("{{1}}{{2}}[{{3}}]", LedArrayRowAddress, identifier, pinNr);
                }
                return switch (col) {
                    case 0 -> LineBuffer.format("{{1}}{{2}}[{{3}}]", LedArrayColumnRedOutputs, identifier, index);
                    case 1 -> LineBuffer.format("{{1}}{{2}}[{{3}}]", LedArrayColumnGreenOutputs, identifier, index);
                    case 2 -> LineBuffer.format("{{1}}{{2}}[{{3}}]", LedArrayColumnBlueOutputs, identifier, index);
                    default -> "";
                };
            }
            case '\u0005': {
                int index = (pinNr - nrColumnAddressBits) % nrOfRows;
                int col = (pinNr - nrColumnAddressBits) / nrOfRows;
                if (pinNr < nrColumnAddressBits) {
                    return LineBuffer.format("{{1}}{{2}}[{{3}}]", LedArrayColumnAddress, identifier, pinNr);
                }
                return switch (col) {
                    case 0 -> LineBuffer.format("{{1}}{{2}}[{{3}}]", LedArrayRowRedOutputs, identifier, index);
                    case 1 -> LineBuffer.format("{{1}}{{2}}[{{3}}]", LedArrayRowGreenOutputs, identifier, index);
                    case 2 -> LineBuffer.format("{{1}}{{2}}[{{3}}]", LedArrayRowBlueOutputs, identifier, index);
                    default -> "";
                };
            }
        }
        return "";
    }

    public static boolean requiresClock(char typeId) {
        return typeId != '\u0000' && typeId != '\u0003';
    }

    public static SortedMap<String, Integer> getExternalSignals(char typeId, int nrOfRows, int nrOfColumns, int identifier) {
        TreeMap<String, Integer> externals = new TreeMap<String, Integer>();
        int nrRowAddressBits = LedArrayGenericHdlGeneratorFactory.getNrOfBitsRequired(nrOfRows);
        int nrColumnAddressBits = LedArrayGenericHdlGeneratorFactory.getNrOfBitsRequired(nrOfColumns);
        switch (typeId) {
            case '\u0000': {
                externals.put(String.format("%s%d", LedArrayOutputs, identifier), nrOfRows * nrOfColumns);
                break;
            }
            case '\u0001': {
                externals.put(String.format("%s%d", LedArrayRowAddress, identifier), nrRowAddressBits);
                externals.put(String.format("%s%d", LedArrayColumnOutputs, identifier), nrOfColumns);
                break;
            }
            case '\u0002': {
                externals.put(String.format("%s%d", LedArrayColumnAddress, identifier), nrColumnAddressBits);
                externals.put(String.format("%s%d", LedArrayRowOutputs, identifier), nrOfRows);
                break;
            }
            case '\u0003': {
                externals.put(String.format("%s%d", LedArrayRedOutputs, identifier), nrOfRows * nrOfColumns);
                externals.put(String.format("%s%d", LedArrayGreenOutputs, identifier), nrOfRows * nrOfColumns);
                externals.put(String.format("%s%d", LedArrayBlueOutputs, identifier), nrOfRows * nrOfColumns);
                break;
            }
            case '\u0004': {
                externals.put(String.format("%s%d", LedArrayRowAddress, identifier), nrRowAddressBits);
                externals.put(String.format("%s%d", LedArrayColumnRedOutputs, identifier), nrOfColumns);
                externals.put(String.format("%s%d", LedArrayColumnGreenOutputs, identifier), nrOfColumns);
                externals.put(String.format("%s%d", LedArrayColumnBlueOutputs, identifier), nrOfColumns);
                break;
            }
            case '\u0005': {
                externals.put(String.format("%s%d", LedArrayColumnAddress, identifier), nrColumnAddressBits);
                externals.put(String.format("%s%d", LedArrayRowRedOutputs, identifier), nrOfRows);
                externals.put(String.format("%s%d", LedArrayRowGreenOutputs, identifier), nrOfRows);
                externals.put(String.format("%s%d", LedArrayRowBlueOutputs, identifier), nrOfRows);
            }
        }
        return externals;
    }

    public static Map<String, Integer> getInternalSignals(char typeId, int nrOfRows, int nrOfColumns, int identifier) {
        TreeMap<String, Integer> wires = new TreeMap<String, Integer>();
        switch (typeId) {
            case '\u0000': 
            case '\u0001': 
            case '\u0002': {
                wires.put(String.format("s_%s%d", LedArrayInputs, identifier), nrOfRows * nrOfColumns);
                break;
            }
            case '\u0003': 
            case '\u0004': 
            case '\u0005': {
                wires.put(String.format("s_%s%d", LedArrayRedInputs, identifier), nrOfRows * nrOfColumns);
                wires.put(String.format("s_%s%d", LedArrayGreenInputs, identifier), nrOfRows * nrOfColumns);
                wires.put(String.format("s_%s%d", LedArrayBlueInputs, identifier), nrOfRows * nrOfColumns);
            }
        }
        return wires;
    }

    public static List<String> getComponentMap(char typeId, int nrOfRows, int nrOfColumns, int identifier, long FpgaClockFrequency, boolean isActiveLow) {
        LineBuffer componentMap = LineBuffer.getBuffer().add(Hdl.isVhdl() ? LineBuffer.format("array{{1}} : {{2}}", identifier, LedArrayGenericHdlGeneratorFactory.getSpecificHDLName(typeId)) : LedArrayGenericHdlGeneratorFactory.getSpecificHDLName(typeId));
        switch (typeId) {
            case '\u0000': 
            case '\u0003': {
                componentMap.add(LedArrayLedDefaultHdlGeneratorFactory.getGenericMap(nrOfRows, nrOfColumns, FpgaClockFrequency, isActiveLow).getWithIndent());
                break;
            }
            case '\u0002': 
            case '\u0005': {
                componentMap.add(LedArrayColumnScanningHdlGeneratorFactory.getGenericMap(nrOfRows, nrOfColumns, FpgaClockFrequency, isActiveLow).getWithIndent());
                break;
            }
            case '\u0001': 
            case '\u0004': {
                componentMap.add(LedArrayRowScanningHdlGeneratorFactory.getGenericMap(nrOfRows, nrOfColumns, FpgaClockFrequency, isActiveLow).getWithIndent());
            }
        }
        if (Hdl.isVerilog()) {
            componentMap.add("   array{{1}}", identifier);
        }
        switch (typeId) {
            case '\u0000': {
                componentMap.add(LedArrayLedDefaultHdlGeneratorFactory.getPortMap(identifier));
                break;
            }
            case '\u0003': {
                componentMap.add(RgbArrayLedDefaultHdlGeneratorFactory.getPortMap(identifier));
                break;
            }
            case '\u0001': {
                componentMap.add(LedArrayRowScanningHdlGeneratorFactory.getPortMap(identifier).getWithIndent());
                break;
            }
            case '\u0004': {
                componentMap.add(RgbArrayRowScanningHdlGeneratorFactory.getPortMap(identifier).getWithIndent());
                break;
            }
            case '\u0002': {
                componentMap.add(LedArrayColumnScanningHdlGeneratorFactory.getPortMap(identifier).getWithIndent());
                break;
            }
            case '\u0005': {
                componentMap.add(RgbArrayColumnScanningHdlGeneratorFactory.getPortMap(identifier).getWithIndent());
            }
        }
        return componentMap.empty().get();
    }

    public static List<String> getArrayConnections(FpgaIoInformationContainer array, int id) {
        ArrayList<String> connections = new ArrayList<String>(switch (array.getArrayDriveMode()) {
            case '\u0000', '\u0001', '\u0002' -> LedArrayGenericHdlGeneratorFactory.getLedArrayConnections(array, id);
            case '\u0003', '\u0004', '\u0005' -> LedArrayGenericHdlGeneratorFactory.getRGBArrayConnections(array, id);
            default -> throw new IllegalStateException("Unexpected value: " + array.getArrayDriveMode());
        });
        connections.add("");
        return connections;
    }

    public static List<String> getLedArrayConnections(FpgaIoInformationContainer info, int id) {
        LineBuffer connections = LineBuffer.getHdlBuffer();
        HashMap<String, String> wires = new HashMap<String, String>();
        for (int pin = 0; pin < info.getNrOfPins(); ++pin) {
            String led = LineBuffer.formatHdl("s_{{1}}{{2}}{{<}}{{3}}{{>}}", LedArrayInputs, id, pin);
            if (!info.isPinMapped(pin)) {
                wires.put(led, Hdl.zeroBit());
                continue;
            }
            wires.put(led, info.getPinMap(pin).getHdlSignalName(info.getMapPin(pin)));
        }
        Hdl.addAllWiresSorted(connections, wires);
        return connections.get();
    }

    public static List<String> getRGBArrayConnections(FpgaIoInformationContainer array, int id) {
        HashMap<String, String> wires = new HashMap<String, String>();
        LineBuffer connections = LineBuffer.getHdlBuffer().pair("id", id).pair("insR", LedArrayRedInputs).pair("insG", LedArrayGreenInputs).pair("insB", LedArrayBlueInputs);
        for (int pin = 0; pin < array.getNrOfPins(); ++pin) {
            String red = LineBuffer.formatHdl("s_{{1}}{{2}}{{<}}{{3}}{{>}}", LedArrayRedInputs, id, pin);
            String green = LineBuffer.formatHdl("s_{{1}}{{2}}{{<}}{{3}}{{>}}", LedArrayGreenInputs, id, pin);
            String blue = LineBuffer.formatHdl("s_{{1}}{{2}}{{<}}{{3}}{{>}}", LedArrayBlueInputs, id, pin);
            if (!array.isPinMapped(pin)) {
                wires.put(red, Hdl.zeroBit());
                wires.put(green, Hdl.zeroBit());
                wires.put(blue, Hdl.zeroBit());
                continue;
            }
            MapComponent map = array.getPinMap(pin);
            if (map.getComponentFactory() instanceof RgbLed) {
                wires.put(red, map.getHdlSignalName(0));
                wires.put(green, map.getHdlSignalName(1));
                wires.put(blue, map.getHdlSignalName(2));
                continue;
            }
            if (map.getAttributeSet().containsAttribute(IoLibrary.ATTR_ON_COLOR) && map.getAttributeSet().containsAttribute(IoLibrary.ATTR_OFF_COLOR)) {
                Color onColor = map.getAttributeSet().getValue(IoLibrary.ATTR_ON_COLOR);
                Color offColor = map.getAttributeSet().getValue(IoLibrary.ATTR_OFF_COLOR);
                int rOn = onColor.getRed();
                int gOn = onColor.getGreen();
                int bOn = onColor.getBlue();
                int rOff = offColor.getRed();
                int gOff = offColor.getGreen();
                int bOff = offColor.getBlue();
                String pinName = map.getHdlSignalName(array.getMapPin(pin));
                wires.putAll(LedArrayGenericHdlGeneratorFactory.getColorMap(red, rOn, rOff, pinName));
                wires.putAll(LedArrayGenericHdlGeneratorFactory.getColorMap(green, gOn, gOff, pinName));
                wires.putAll(LedArrayGenericHdlGeneratorFactory.getColorMap(blue, bOn, bOff, pinName));
                continue;
            }
            String pinName = map.getHdlSignalName(array.getMapPin(pin));
            wires.put(red, pinName);
            wires.put(green, pinName);
            wires.put(blue, pinName);
        }
        Hdl.addAllWiresSorted(connections, wires);
        return connections.get();
    }

    private static Map<String, String> getColorMap(String dest, int onColor, int offColor, String source) {
        boolean onBit = onColor > 128;
        boolean offBit = offColor > 128;
        HashMap<String, String> result = new HashMap<String, String>();
        if (onBit == offBit) {
            result.put(dest, onBit ? Hdl.oneBit() : Hdl.zeroBit());
        } else if (onBit) {
            result.put(dest, source);
        } else {
            result.put(dest, LineBuffer.format("{{1}}{{2}}", Hdl.notOperator(), source));
        }
        return result;
    }

    public static LineBuffer getGenericPortMapAlligned(Map<String, String> generics, boolean isGeneric) {
        String preamble;
        String string = preamble = Hdl.isVhdl() ? LineBuffer.formatVhdl("{{port}} {{map}} ( ", new Object[0]) : "( ";
        if (isGeneric) {
            preamble = Hdl.isVhdl() ? LineBuffer.formatVhdl("{{generic}} {{map}} ( ", new Object[0]) : "#( ";
        }
        LineBuffer contents = LineBuffer.getHdlBuffer();
        int maxNameLength = 0;
        boolean first = true;
        int nrOfGenerics = 0;
        for (String generic : generics.keySet()) {
            maxNameLength = Math.max(maxNameLength, generic.length());
            ++nrOfGenerics;
        }
        for (String generic : generics.keySet()) {
            String map;
            String intro = first ? preamble : " ".repeat(preamble.length());
            String string2 = map = Hdl.isVhdl() ? LineBuffer.formatHdl("{{1}}{{2}} => {{3}}", generic, " ".repeat(maxNameLength - generic.length()), generics.get(generic)) : LineBuffer.formatHdl(".{{1}}({{2}})", generic, generics.get(generic));
            String end = --nrOfGenerics == 0 ? (isGeneric ? " )" : " );") : ",";
            contents.add(LineBuffer.format("{{1}}{{2}}{{3}}", intro, map, end));
            first = false;
        }
        return contents;
    }
}

