/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.hdl;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.hdlgenerator.HdlGeneratorFactory;
import com.cburch.logisim.gui.icons.ArithmeticIcon;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.hdl.HdlCircuitComponent;
import com.cburch.logisim.std.hdl.HdlContentAttribute;
import com.cburch.logisim.std.hdl.VhdlContentComponent;
import com.cburch.logisim.std.hdl.VhdlEntityAttributes;
import com.cburch.logisim.std.hdl.VhdlHdlGeneratorFactory;
import com.cburch.logisim.vhdl.Strings;
import com.cburch.logisim.vhdl.base.VhdlSimConstants;
import com.cburch.logisim.vhdl.sim.VhdlSimulatorTop;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VhdlEntityComponent
extends HdlCircuitComponent<VhdlContentComponent> {
    public static final String _ID = "VHDL Entity";
    static final Logger logger = LoggerFactory.getLogger(VhdlEntityComponent.class);
    public static final Attribute<VhdlContentComponent> CONTENT_ATTR = new HdlContentAttribute<VhdlContentComponent>(VhdlContentComponent::create);

    public VhdlEntityComponent() {
        super(_ID, Strings.S.getter("vhdlComponent"), (HdlGeneratorFactory)new VhdlHdlGeneratorFactory(), true, CONTENT_ATTR);
        this.setIcon(new ArithmeticIcon("VHDL"));
    }

    public void setSimName(AttributeSet attrs, String simName) {
        String label;
        if (attrs == null) {
            return;
        }
        VhdlEntityAttributes atrs = (VhdlEntityAttributes)attrs;
        String string = label = !attrs.getValue(StdAttr.LABEL).equals("") ? this.getHDLTopName(attrs) : simName;
        if (atrs.containsAttribute(VhdlSimConstants.SIM_NAME_ATTR)) {
            atrs.setValue(VhdlSimConstants.SIM_NAME_ATTR, label);
        }
    }

    public String getSimName(AttributeSet attrs) {
        if (attrs == null) {
            return null;
        }
        VhdlEntityAttributes atrs = (VhdlEntityAttributes)attrs;
        return atrs.getValue(VhdlSimConstants.SIM_NAME_ATTR);
    }

    @Override
    public AttributeSet createAttributeSet() {
        return new VhdlEntityAttributes();
    }

    @Override
    public String getHDLName(AttributeSet attrs) {
        return attrs.getValue(CONTENT_ATTR).getName().toLowerCase();
    }

    @Override
    public String getHDLTopName(AttributeSet attrs) {
        Object label = "";
        if (!attrs.getValue(StdAttr.LABEL).equals("")) {
            label = "_" + attrs.getValue(StdAttr.LABEL).toLowerCase();
        }
        return this.getHDLName(attrs) + (String)label;
    }

    @Override
    public void propagate(InstanceState state) {
        if (state.getProject().getVhdlSimulator().isEnabled() && state.getProject().getVhdlSimulator().isRunning()) {
            String serverResponse;
            VhdlSimulatorTop vhdlSimulator = state.getProject().getVhdlSimulator();
            for (Port p : state.getInstance().getPorts()) {
                int index = state.getPortIndex(p);
                Value val = state.getPortValue(index);
                String vhdlEntityName = this.getSimName(state.getAttributeSet());
                String message = p.getType() + ":" + vhdlEntityName + "_" + p.getToolTip() + ":" + val.toBinaryString() + ":" + index;
                vhdlSimulator.send(message);
            }
            vhdlSimulator.send("sync");
            while ((serverResponse = vhdlSimulator.receive()) != null && serverResponse.length() > 0 && !serverResponse.equals("sync")) {
                String[] parameters = serverResponse.split(":");
                String busValue = parameters[1];
                Value[] vector_values = new Value[busValue.length()];
                int k = busValue.length() - 1;
                for (char bit : busValue.toCharArray()) {
                    try {
                        switch (Character.getNumericValue(bit)) {
                            case 0: {
                                vector_values[k] = Value.FALSE;
                                break;
                            }
                            case 1: {
                                vector_values[k] = Value.TRUE;
                                break;
                            }
                            default: {
                                vector_values[k] = Value.UNKNOWN;
                                break;
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        vector_values[k] = Value.UNKNOWN;
                    }
                    --k;
                }
                state.setPort(Integer.parseInt(parameters[2]), Value.create(vector_values), 1);
            }
        } else {
            for (Port p : state.getInstance().getPorts()) {
                int index = state.getPortIndex(p);
                if (p.getType() != 2) continue;
                Value[] vector_values = new Value[p.getFixedBitWidth().getWidth()];
                for (int k = 0; k < p.getFixedBitWidth().getWidth(); ++k) {
                    vector_values[k] = Value.UNKNOWN;
                }
                state.setPort(index, Value.create(vector_values), 1);
            }
            throw new UnsupportedOperationException("VHDL component simulation is not supported. This could be because there is no Questasim/Modelsim simulation server running.");
        }
    }

    public void saveFile(AttributeSet attrs) {
        try {
            PrintWriter writer = new PrintWriter(VhdlSimConstants.SIM_SRC_PATH + this.getSimName(attrs) + ".vhdl", StandardCharsets.UTF_8);
            String content = attrs.getValue(CONTENT_ATTR).getContent().replaceAll("(?i)" + this.getHDLName(attrs), this.getSimName(attrs));
            writer.print(content);
            writer.close();
        }
        catch (IOException e) {
            logger.error("Could not create vhdl file: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }
}

