/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.gates;

import com.cburch.logisim.analyze.model.Expression;
import com.cburch.logisim.analyze.model.Expressions;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.gates.AbstractGate;
import com.cburch.logisim.std.gates.AbstractGateHdlGenerator;
import com.cburch.logisim.std.gates.GateFunctions;
import com.cburch.logisim.std.gates.PainterDin;
import com.cburch.logisim.std.gates.PainterShaped;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.LineBuffer;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

class AndGate
extends AbstractGate {
    public static final AndGate FACTORY = new AndGate();

    private AndGate() {
        super("AND Gate", Strings.S.getter("andGateComponent"), new AndGateHdlGeneratorFactory());
        this.setRectangularLabel("&");
    }

    @Override
    protected Expression computeExpression(Expression[] inputs, int numInputs) {
        Expression ret = inputs[0];
        for (int i = 1; i < numInputs; ++i) {
            ret = Expressions.and(ret, inputs[i]);
        }
        return ret;
    }

    @Override
    protected Value computeOutput(Value[] inputs, int numInputs, InstanceState state) {
        return GateFunctions.computeAnd(inputs, numInputs);
    }

    @Override
    protected Value getIdentity() {
        return Value.TRUE;
    }

    @Override
    protected void paintDinShape(InstancePainter painter, int width, int height, int inputs) {
        PainterDin.paintAnd(painter, width, height, false);
    }

    @Override
    protected void paintIconANSI(Graphics2D g, int iconSize, int borderSize, int negateSize) {
        AndGate.paintIconANSI(g, iconSize, borderSize, negateSize, false);
    }

    protected static void paintIconANSI(Graphics2D g, int iconSize, int borderSize, int negateSize, boolean inverted) {
        int ystart = negateSize >> 1;
        int yend = iconSize - ystart;
        int rad = yend - ystart >> 1;
        boolean xstart = false;
        int xend = iconSize - negateSize - rad;
        int[] xp = new int[]{xend, 0, 0, xend};
        int[] yp = new int[]{ystart, ystart, yend, yend};
        AffineTransform af = g.getTransform();
        g.translate(borderSize, borderSize);
        g.drawPolyline(xp, yp, 4);
        GraphicsUtil.drawCenteredArc(g, xend, iconSize >> 1, rad, -90, 180);
        AndGate.paintIconPins(g, iconSize, borderSize, negateSize, inverted, false);
        g.setTransform(af);
    }

    @Override
    protected void paintShape(InstancePainter painter, int width, int height) {
        PainterShaped.paintAnd(painter, width, height);
    }

    private static class AndGateHdlGeneratorFactory
    extends AbstractGateHdlGenerator {
        private AndGateHdlGeneratorFactory() {
        }

        @Override
        public boolean getFloatingValue(boolean isInverted) {
            return isInverted;
        }

        @Override
        public LineBuffer getLogicFunction(int nrOfInputs, int bitwidth, boolean isOneHot) {
            LineBuffer contents = LineBuffer.getHdlBuffer();
            StringBuilder oneLine = new StringBuilder();
            oneLine.append(Hdl.assignPreamble()).append("result").append(Hdl.assignOperator());
            int tabWidth = oneLine.length();
            boolean first = true;
            for (int i = 0; i < nrOfInputs; ++i) {
                if (!first) {
                    oneLine.append(Hdl.andOperator());
                    contents.add(oneLine.toString());
                    oneLine.setLength(0);
                    oneLine.append(" ".repeat(tabWidth));
                } else {
                    first = false;
                }
                oneLine.append(String.format("s_realInput%d", i + 1));
            }
            oneLine.append(";");
            contents.add(oneLine.toString());
            return contents;
        }
    }
}

