/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.rv32im;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.file.ElfHeader;
import com.cburch.logisim.soc.rv32im.RV32imState;
import com.cburch.logisim.soc.rv32im.RV32imSupport;
import com.cburch.logisim.soc.util.AssemblerAsmInstruction;
import com.cburch.logisim.soc.util.AssemblerExecutionInterface;
import com.cburch.logisim.soc.util.AssemblerToken;
import java.util.ArrayList;
import java.util.Arrays;

public class RV32imIntegerRegisterRegisterOperations
implements AssemblerExecutionInterface {
    private static final int OP = 51;
    private static final int ADD_SUB = 0;
    private static final int SRL_SRA = 5;
    private static final int INSTR_ADD = 0;
    private static final int INSTR_SLL = 1;
    private static final int INSTR_SLT = 2;
    private static final int INSTR_SLTU = 3;
    private static final int INSTR_XOR = 4;
    private static final int INSTR_SRL = 5;
    private static final int INSTR_OR = 6;
    private static final int INSTR_AND = 7;
    private static final int INSTR_SUB = 8;
    private static final int INSTR_SRA = 9;
    private static final int INSTR_SNEZ = 10;
    private static final String[] AsmOpcodes = new String[]{"ADD", "SLL", "SLT", "SLTU", "XOR", "SRL", "OR", "AND", "SUB", "SRA", "SNEZ"};
    private int instruction = 0;
    private int destination;
    private int source1;
    private int source2;
    private int operation;
    private boolean valid = false;

    @Override
    public ArrayList<String> getInstructions() {
        return new ArrayList<String>(Arrays.asList(AsmOpcodes));
    }

    @Override
    public boolean execute(Object state, CircuitState cState) {
        if (!this.valid) {
            return false;
        }
        RV32imState.ProcessorState cpuState = (RV32imState.ProcessorState)state;
        int opp1 = cpuState.getRegisterValue(this.source1);
        int opp2 = cpuState.getRegisterValue(this.source2);
        int result = 0;
        switch (this.operation) {
            case 0: {
                result = opp1 + opp2;
                break;
            }
            case 8: {
                result = opp1 - opp2;
                break;
            }
            case 1: {
                result = opp1 << (opp2 & 0x1F);
                break;
            }
            case 2: {
                result = opp1 < opp2 ? 1 : 0;
                break;
            }
            case 3: 
            case 10: {
                result = ElfHeader.getLongValue(opp1) < ElfHeader.getLongValue(opp2) ? 1 : 0;
                break;
            }
            case 4: {
                result = opp1 ^ opp2;
                break;
            }
            case 5: {
                long val1 = ElfHeader.getLongValue(opp1);
                result = ElfHeader.getIntValue(val1 >>= opp2 & 0x1F);
                break;
            }
            case 6: {
                result = opp1 | opp2;
                break;
            }
            case 7: {
                result = opp1 & opp2;
                break;
            }
            case 9: {
                result = opp1 >> (opp2 & 0x1F);
                break;
            }
            default: {
                return false;
            }
        }
        cpuState.writeRegister(this.destination, result);
        return true;
    }

    @Override
    public String getAsmInstruction() {
        if (!this.valid) {
            return "Unknown";
        }
        StringBuilder s = new StringBuilder();
        s.append(AsmOpcodes[this.operation].toLowerCase());
        while (s.length() < 10) {
            s.append(" ");
        }
        s.append(RV32imState.registerABINames[this.destination]).append(",").append((String)(this.operation == 10 ? "" : RV32imState.registerABINames[this.source1] + ",")).append(RV32imState.registerABINames[this.source2]);
        return s.toString();
    }

    @Override
    public int getBinInstruction() {
        return this.instruction;
    }

    @Override
    public boolean setBinInstruction(int instr) {
        this.instruction = instr;
        this.valid = this.decodeBin();
        return this.valid;
    }

    @Override
    public boolean performedJump() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    private boolean decodeBin() {
        if (RV32imSupport.getOpcode(this.instruction) != 51) {
            return false;
        }
        int funct7 = RV32imSupport.getFunct7(this.instruction);
        int funct3 = RV32imSupport.getFunct3(this.instruction);
        this.destination = RV32imSupport.getDestinationRegisterIndex(this.instruction);
        this.source1 = RV32imSupport.getSourceRegister1Index(this.instruction);
        this.source2 = RV32imSupport.getSourceRegister2Index(this.instruction);
        switch (funct3) {
            case 0: {
                if (funct7 == 0) {
                    this.operation = 0;
                    break;
                }
                if (funct7 == 32) {
                    this.operation = 8;
                    break;
                }
                return false;
            }
            case 5: {
                if (funct7 == 0) {
                    this.operation = 5;
                    break;
                }
                if (funct7 == 32) {
                    this.operation = 9;
                    break;
                }
                return false;
            }
            default: {
                if (funct7 != 0) {
                    return false;
                }
                this.operation = funct3;
            }
        }
        if (this.operation == 3 && this.source1 == 0) {
            this.operation = 10;
        }
        return true;
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public int getInstructionSizeInBytes(String instruction) {
        if (this.getInstructions().contains(instruction.toUpperCase())) {
            return 4;
        }
        return -1;
    }

    @Override
    public boolean setAsmInstruction(AssemblerAsmInstruction instr) {
        int operation = -1;
        for (int i = 0; i < AsmOpcodes.length; ++i) {
            if (!AsmOpcodes[i].equals(instr.getOpcode().toUpperCase())) continue;
            operation = i;
        }
        if (operation < 0) {
            this.valid = false;
            return false;
        }
        boolean errors = false;
        if (instr.getNrOfParameters() != (operation == 10 ? 2 : 3)) {
            instr.setError(instr.getInstruction(), Strings.S.getter("AssemblerExpectedThreeArguments"));
            this.valid = false;
            return true;
        }
        AssemblerToken[] param1 = instr.getParameter(0);
        AssemblerToken[] param2 = instr.getParameter(1);
        AssemblerToken[] param3 = operation != 10 ? instr.getParameter(2) : param2;
        if (param1.length != 1 || param1[0].getType() != 5) {
            errors = true;
            instr.setError(param1[0], Strings.S.getter("AssemblerExpectedRegister"));
        }
        if (param2.length != 1 || param2[0].getType() != 5) {
            errors = true;
            instr.setError(param2[0], Strings.S.getter("AssemblerExpectedRegister"));
        }
        if (param3 != param2 && (param3.length != 1 || param3[0].getType() != 5)) {
            errors = true;
            instr.setError(param3[0], Strings.S.getter("AssemblerExpectedRegister"));
        }
        this.destination = RV32imState.getRegisterIndex(param1[0].getValue());
        this.source1 = RV32imState.getRegisterIndex(param2[0].getValue());
        this.source2 = RV32imState.getRegisterIndex(param3[0].getValue());
        if (this.destination < 0 || this.destination > 31) {
            errors = true;
            instr.setError(param1[0], Strings.S.getter("AssemblerUnknownRegister"));
        }
        if (this.source1 < 0 || this.source1 > 31) {
            errors = true;
            instr.setError(param2[0], Strings.S.getter("AssemblerUnknownRegister"));
        }
        if (param3 != param2 && (this.source2 < 0 || this.source2 > 31)) {
            errors = true;
            instr.setError(param3[0], Strings.S.getter("AssemblerUnknownRegister"));
        }
        if (operation == 10) {
            this.source1 = 0;
            operation = 3;
        }
        boolean bl = this.valid = !errors;
        if (this.valid) {
            int funct7;
            int n = funct7 = operation == 8 || operation == 9 ? 32 : 0;
            int funct3 = operation == 8 ? 0 : (operation == 9 ? 5 : operation);
            this.instruction = RV32imSupport.getRTypeInstruction(51, this.destination, funct3, this.source1, this.source2, funct7);
            instr.setInstructionByteCode(this.instruction, 4);
        }
        return true;
    }
}

