/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.nios2;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.data.SocSupport;
import com.cburch.logisim.soc.nios2.Nios2State;
import com.cburch.logisim.soc.nios2.Nios2Support;
import com.cburch.logisim.soc.util.AssemblerAsmInstruction;
import com.cburch.logisim.soc.util.AssemblerExecutionInterface;
import com.cburch.logisim.soc.util.AssemblerToken;
import java.util.ArrayList;

public class Nios2OtherControlInstructions
implements AssemblerExecutionInterface {
    private static final int INSTR_TRAP = 0;
    private static final int INSTR_ERET = 1;
    private static final int INSTR_BREAK = 2;
    private static final int INSTR_BRET = 3;
    private static final int INSTR_RDCTL = 4;
    private static final int INSTR_WRCTL = 5;
    private static final int INSTR_FLUSHD = 6;
    private static final int INSTR_FLUSHDA = 7;
    private static final int INSTR_FLUSHI = 8;
    private static final int INSTR_INITD = 9;
    private static final int INSTR_INITDA = 10;
    private static final int INSTR_INITI = 11;
    private static final int INSTR_FLUSHP = 12;
    private static final int INSTR_SYNC = 13;
    private static final int SIGN_EXTEND = 256;
    private static final String[] AsmOpcodes = new String[]{"TRAP", "ERET", "BREAK", "BRET", "RDCTL", "WRCTL", "FLUSHD", "FLUSHDA", "FLUSHI", "INITD", "INITDA", "INITI", "FLUSHP", "SYNC"};
    private static final Integer[] AsmOpcs = new Integer[]{58, 58, 58, 58, 58, 58, 59, 27, 58, 51, 19, 58, 58, 58};
    private static final Integer[] AsmOpxs = new Integer[]{45, 1, 52, 9, 38, 46, 256, 256, 12, 256, 256, 41, 4, 54};
    private final ArrayList<String> Opcodes = new ArrayList();
    private final ArrayList<Integer> OpcCodes = new ArrayList();
    private final ArrayList<Integer> OpxCodes = new ArrayList();
    private int instruction;
    private boolean valid;
    private boolean jumped;
    private int operation;
    private int sourceA;
    private int immediate;

    public Nios2OtherControlInstructions() {
        for (int i = 0; i < AsmOpcodes.length; ++i) {
            this.Opcodes.add(AsmOpcodes[i].toLowerCase());
            this.OpcCodes.add(AsmOpcs[i]);
            this.OpxCodes.add(AsmOpxs[i]);
        }
    }

    @Override
    public boolean execute(Object processorState, CircuitState circuitState) {
        this.jumped = false;
        if (!this.valid) {
            return false;
        }
        Nios2State.ProcessorState cpuState = (Nios2State.ProcessorState)processorState;
        long pc = SocSupport.convUnsignedInt(cpuState.getProgramCounter());
        long nextPc = pc + 4L;
        switch (this.operation) {
            case 0: {
                cpuState.writeRegister(29, SocSupport.convUnsignedLong(nextPc));
                cpuState.interrupt();
                this.jumped = true;
                break;
            }
            case 1: {
                cpuState.endofInterrupt();
                this.jumped = true;
                break;
            }
            case 2: {
                cpuState.breakReq();
                this.jumped = true;
                break;
            }
            case 3: {
                cpuState.breakRet();
                this.jumped = true;
                break;
            }
            case 4: {
                cpuState.writeRegister(this.sourceA, cpuState.getControlRegister(this.immediate));
                break;
            }
            case 5: {
                cpuState.setControlRegister(this.immediate, cpuState.getRegisterValue(this.sourceA));
                break;
            }
        }
        return true;
    }

    @Override
    public String getAsmInstruction() {
        if (!this.valid) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        s.append(this.Opcodes.get(this.operation));
        while (s.length() < 10) {
            s.append(" ");
        }
        switch (this.operation) {
            case 0: 
            case 2: {
                if (this.immediate == 0) break;
                s.append(this.immediate);
                break;
            }
            case 4: {
                s.append(Nios2State.registerABINames[this.sourceA]).append(",ctl").append(this.immediate);
                break;
            }
            case 5: {
                s.append("ctl").append(this.immediate).append(",").append(Nios2State.registerABINames[this.sourceA]);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                int imm = this.immediate << 16 >> 16;
                s.append(imm).append("(").append(Nios2State.registerABINames[this.sourceA]).append(")");
                break;
            }
            case 8: 
            case 11: {
                s.append(Nios2State.registerABINames[this.sourceA]);
            }
        }
        return s.toString();
    }

    @Override
    public int getBinInstruction() {
        return this.instruction;
    }

    @Override
    public boolean setAsmInstruction(AssemblerAsmInstruction instr) {
        this.valid = false;
        if (!this.Opcodes.contains(instr.getOpcode().toLowerCase())) {
            return false;
        }
        this.operation = this.Opcodes.indexOf(instr.getOpcode().toLowerCase());
        this.valid = true;
        int first = -1;
        switch (this.operation) {
            case 0: 
            case 2: {
                if (instr.getNrOfParameters() == 0) {
                    this.immediate = 0;
                    this.sourceA = 0;
                    break;
                }
                if (instr.getNrOfParameters() == 1) {
                    AssemblerToken[] imm = instr.getParameter(0);
                    if (imm.length != 1 || !imm[0].isNumber()) {
                        this.valid = false;
                        instr.setError(imm[0], Strings.S.getter("AssemblerExpectedImmediateValue"));
                    }
                    this.immediate = imm[0].getNumberValue();
                    if (this.immediate <= 31 && this.immediate >= 0) break;
                    this.valid = false;
                    instr.setError(imm[0], Strings.S.getter("AssemblerImmediateOutOfRange"));
                    break;
                }
                this.valid = false;
                instr.setError(instr.getInstruction(), Strings.S.getter("AssemblerExpectedZeroOrOneArgument"));
                break;
            }
            case 5: {
                first = 1;
            }
            case 4: {
                if (instr.getNrOfParameters() != 2) {
                    this.valid = false;
                    instr.setError(instr.getInstruction(), Strings.S.getter("AssemblerExpectedTwoArguments"));
                    return true;
                }
                if (first < 0) {
                    first = 0;
                }
                this.valid &= Nios2Support.isCorrectRegister(instr, first);
                this.sourceA = Nios2Support.getRegisterIndex(instr, first);
                ++first;
                AssemblerToken[] ctl = instr.getParameter(first &= 1);
                if (ctl.length != 1 || ctl[0].getType() != 257) {
                    this.valid = false;
                    instr.setError(ctl[0], Strings.S.getter("Nios2ExpectedControlRegister"));
                }
                this.immediate = Nios2State.getRegisterIndex(ctl[0].getValue());
                if (this.immediate >= 0 && this.immediate <= 31) break;
                this.valid = false;
                instr.setError(ctl[0], Strings.S.getter("AssemblerUnknownRegister"));
                break;
            }
            case 8: 
            case 11: {
                if (instr.getNrOfParameters() != 1) {
                    this.valid = false;
                    instr.setError(instr.getInstruction(), Strings.S.getter("AssemblerExpectedOneArgument"));
                    return true;
                }
                this.valid &= Nios2Support.isCorrectRegister(instr, 0);
                this.sourceA = Nios2Support.getRegisterIndex(instr, 0);
                this.immediate = 0;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                if (instr.getNrOfParameters() != 1) {
                    this.valid = false;
                    instr.setError(instr.getInstruction(), Strings.S.getter("AssemblerExpectedOneArgument"));
                    return true;
                }
                AssemblerToken[] ireg = instr.getParameter(0);
                if (ireg.length != 2) {
                    this.valid = false;
                    instr.setError(ireg[0], Strings.S.getter("Nios2AssemblerExpectedImmediateIndexedRegister"));
                    return true;
                }
                if (!ireg[0].isNumber()) {
                    this.valid = false;
                    instr.setError(ireg[0], Strings.S.getter("AssemblerExpectedImmediateValue"));
                }
                this.immediate = ireg[0].getNumberValue();
                if (this.immediate >= 32768 || this.immediate < Short.MIN_VALUE) {
                    this.valid = false;
                    instr.setError(ireg[0], Strings.S.getter("AssemblerImmediateOutOfRange"));
                }
                if (ireg[1].getType() != 4) {
                    this.valid = false;
                    instr.setError(ireg[1], Strings.S.getter("Nios2AssemblerExpectedBracketedRegister"));
                    return true;
                }
                if (Nios2State.isCustomRegister(ireg[1].getValue())) {
                    this.valid = false;
                    instr.setError(ireg[1], Strings.S.getter("Nios2CannotUseCustomRegister"));
                    return true;
                }
                if (Nios2State.isControlRegister(ireg[1].getValue())) {
                    this.valid = false;
                    instr.setError(ireg[1], Strings.S.getter("Nios2CannotUseControlRegister"));
                    return true;
                }
                this.sourceA = Nios2State.getRegisterIndex(ireg[1].getValue());
                if (this.sourceA >= 0 && this.sourceA <= 31) break;
                this.valid = false;
                instr.setError(ireg[1], Strings.S.getter("AssemblerUnknownRegister"));
                break;
            }
            default: {
                if (instr.getNrOfParameters() == 0) break;
                this.valid = false;
                instr.setError(instr.getInstruction(), Strings.S.getter("AssemblerExpectedNoArguments"));
            }
        }
        if (this.valid) {
            switch (this.operation) {
                case 0: {
                    this.instruction = Nios2Support.getRTypeInstructionCode(0, 0, 29, 45, this.immediate);
                    break;
                }
                case 1: {
                    this.instruction = Nios2Support.getRTypeInstructionCode(29, 30, 0, 1);
                    break;
                }
                case 2: {
                    this.instruction = Nios2Support.getRTypeInstructionCode(0, 0, 30, 52, this.immediate);
                    break;
                }
                case 3: {
                    this.instruction = Nios2Support.getRTypeInstructionCode(30, 0, 30, 9);
                    break;
                }
                case 4: {
                    this.instruction = Nios2Support.getRTypeInstructionCode(0, 0, this.sourceA, 38, this.immediate);
                    break;
                }
                case 5: {
                    this.instruction = Nios2Support.getRTypeInstructionCode(this.sourceA, 0, 0, 46, this.immediate);
                    break;
                }
                case 8: 
                case 11: 
                case 12: {
                    this.instruction = Nios2Support.getRTypeInstructionCode(this.sourceA, 0, 0, this.OpxCodes.get(this.operation));
                    break;
                }
                case 13: {
                    this.instruction = Nios2Support.getRTypeInstructionCode(0, 0, 0, 54);
                    break;
                }
                case 6: 
                case 7: 
                case 9: 
                case 10: {
                    this.instruction = Nios2Support.getITypeInstructionCode(this.sourceA, 0, this.immediate, this.OpcCodes.get(this.operation));
                    break;
                }
                default: {
                    this.valid = false;
                    return false;
                }
            }
            instr.setInstructionByteCode(this.instruction, 4);
        }
        return true;
    }

    @Override
    public boolean setBinInstruction(int instr) {
        block25: {
            int opcode;
            block24: {
                this.valid = false;
                this.instruction = instr;
                opcode = Nios2Support.getOpcode(instr);
                if (opcode != 58) break block24;
                int opx = Nios2Support.getOPXCode(instr, 1);
                if (!this.OpxCodes.contains(opx)) {
                    return false;
                }
                this.valid = true;
                this.operation = this.OpxCodes.indexOf(opx);
                int ra = Nios2Support.getRegAIndex(instr, 1);
                int rb = Nios2Support.getRegBIndex(instr, 1);
                int rc = Nios2Support.getRegCIndex(instr, 1);
                int imm5 = Nios2Support.getOPXImm(instr, 1);
                switch (this.operation) {
                    case 0: {
                        if (ra != 0 || rb != 0 || rc != 29) {
                            this.valid = false;
                        }
                        this.immediate = imm5;
                        break;
                    }
                    case 1: {
                        if (ra != 29 || rb != 30 || rc != 0 || imm5 != 0) {
                            this.valid = false;
                            break;
                        }
                        break block25;
                    }
                    case 2: {
                        if (ra != 0 || rb != 0 || rc != 30) {
                            this.valid = false;
                        }
                        this.immediate = imm5;
                        break;
                    }
                    case 3: {
                        if (ra != 30 || rb != 0 || rc != 30 || imm5 != 0) {
                            this.valid = false;
                            break;
                        }
                        break block25;
                    }
                    case 4: {
                        if (ra != 0 || rb != 0) {
                            this.valid = false;
                        }
                        this.sourceA = rc;
                        this.immediate = imm5;
                        break;
                    }
                    case 5: {
                        if (rb != 0 || rc != 0) {
                            this.valid = false;
                        }
                        this.sourceA = ra;
                        this.immediate = imm5;
                        break;
                    }
                    case 8: 
                    case 11: 
                    case 12: {
                        if (rb != 0 || rc != 0 || imm5 != 0) {
                            this.valid = false;
                        }
                        this.sourceA = ra;
                        break;
                    }
                    case 13: {
                        if (ra != 0 || rb != 0 || rc != 0 || imm5 != 0) {
                            this.valid = false;
                            break;
                        }
                        break block25;
                    }
                    default: {
                        this.valid = false;
                        break;
                    }
                }
                break block25;
            }
            if (!this.OpcCodes.contains(opcode)) {
                return false;
            }
            this.operation = this.OpcCodes.indexOf(opcode);
            this.valid = true;
            switch (this.operation) {
                case 6: 
                case 7: 
                case 9: 
                case 10: {
                    if (Nios2Support.getRegBIndex(instr, 0) != 0) {
                        this.valid = false;
                    }
                    this.sourceA = Nios2Support.getRegAIndex(instr, 0);
                    this.immediate = Nios2Support.getImmediate(instr, 0);
                    break;
                }
                default: {
                    this.valid = false;
                }
            }
        }
        return this.valid;
    }

    @Override
    public boolean performedJump() {
        return this.jumped && this.valid;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public ArrayList<String> getInstructions() {
        return this.Opcodes;
    }

    @Override
    public int getInstructionSizeInBytes(String instruction) {
        if (this.Opcodes.contains(instruction.toLowerCase())) {
            return 4;
        }
        return -1;
    }
}

