/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.data;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.gui.main.Frame;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.data.SocUpStateInterface;
import com.cburch.logisim.soc.file.ProcessorReadElf;
import com.cburch.logisim.soc.gui.AssemblerPanel;
import com.cburch.logisim.soc.gui.ListeningFrame;
import com.cburch.logisim.soc.util.AssemblerInterface;
import com.cburch.logisim.tools.CircuitStateHolder;
import com.cburch.logisim.tools.MenuExtender;
import com.cburch.logisim.util.StringUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class SocUpMenuProvider
implements ActionListener {
    public static final SocUpMenuProvider SOCUPMENUPROVIDER = new SocUpMenuProvider();
    private static final int LOAD_ELF_FUNCTION = 1;
    private static final int SHOW_STATE_FUNCTION = 2;
    private static final int SHOW_PROGRAM = 3;
    private static final int SHOW_ASM = 4;
    private final HashMap<Instance, InstanceInformation> myInfo = new HashMap();

    public MenuExtender getMenu(Instance inst) {
        if (!this.myInfo.containsKey(inst)) {
            InstanceInformation instInfo = new InstanceInformation(inst, this);
            this.myInfo.put(inst, instInfo);
        }
        return new MenuProvider(inst, this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        InstanceMenuItem info;
        Instance inst;
        Object source = e.getSource();
        if (source instanceof InstanceMenuItem && this.myInfo.containsKey(inst = (info = (InstanceMenuItem)source).getInstance())) {
            switch (info.getFunction()) {
                case 1: {
                    this.myInfo.get(inst).readElf(inst, info.getCircuitState());
                    return;
                }
                case 2: {
                    this.myInfo.get(inst).showState(info.getState(), info.getHierarchyInfo());
                    return;
                }
                case 3: {
                    this.myInfo.get(inst).showProgram(info.getState(), info.getHierarchyInfo(), info.getCircuitState());
                    return;
                }
                case 4: {
                    this.myInfo.get(inst).showAsmWindow(inst, info.getState(), info.getHierarchyInfo(), info.getCircuitState());
                    return;
                }
            }
        }
    }

    private void setParentFrame(Instance inst, Frame frame) {
        if (this.myInfo.containsKey(inst)) {
            this.myInfo.get(inst).setParentFrame(frame);
        }
    }

    public void registerCpuState(SocUpStateInterface data, Instance inst) {
        if (!this.myInfo.containsKey(inst)) {
            this.myInfo.put(inst, new InstanceInformation(inst, this));
        }
        this.myInfo.get(inst).registerCpuState(data);
    }

    public void deregisterCpuState(SocUpStateInterface data, Instance inst) {
        if (this.myInfo.containsKey(inst)) {
            this.myInfo.get(inst).destroyCpuState(data);
        }
    }

    public void repaintStates(Instance inst) {
        if (this.myInfo.containsKey(inst)) {
            this.myInfo.get(inst).repaintStates();
        }
    }

    private static class InstanceInformation {
        private Frame parentFrame = null;
        private final HashMap<SocUpStateInterface, ListeningFrame> myStates = new HashMap();
        private final HashMap<SocUpStateInterface, ListeningFrame> myPrograms = new HashMap();
        private final HashMap<SocUpStateInterface, ListeningFrame> myAsmWindows = new HashMap();

        public InstanceInformation(Instance inst, SocUpMenuProvider parent) {
        }

        public void readElf(Instance instance, CircuitState circuitState) {
            JFileChooser fc = new JFileChooser();
            fc.setDialogTitle(Strings.S.get("SocUpMenuSelectElfFile"));
            int retVal = fc.showOpenDialog(this.parentFrame);
            if (retVal != 0) {
                return;
            }
            SocUpStateInterface data = (SocUpStateInterface)circuitState.getData(instance.getComponent());
            ProcessorReadElf reader = new ProcessorReadElf(fc.getSelectedFile(), instance, data.getElfType(), true);
            if (!reader.canExecute() || !reader.execute(circuitState)) {
                OptionPane.showMessageDialog(this.parentFrame, reader.getErrorMessage(), Strings.S.get("SocUpMenuErrorReadingElfTitle"), 0);
                return;
            }
            OptionPane.showMessageDialog(this.parentFrame, Strings.S.get("ProcReadElfLoadedAndEntrySet"));
        }

        public void registerCpuState(SocUpStateInterface data) {
            if (!this.myStates.containsKey(data)) {
                this.myStates.put(data, null);
            }
            if (!this.myPrograms.containsKey(data)) {
                this.myPrograms.put(data, null);
            }
            if (!this.myAsmWindows.containsKey(data)) {
                this.myAsmWindows.put(data, null);
            }
        }

        public void destroyCpuState(SocUpStateInterface data) {
            if (this.myStates.containsKey(data)) {
                if (this.myStates.get(data) != null) {
                    this.myStates.get(data).setVisible(false);
                    this.myStates.get(data).dispose();
                }
                this.myStates.remove(data);
            }
            if (this.myPrograms.containsKey(data)) {
                if (this.myPrograms.get(data) != null) {
                    this.myPrograms.get(data).setVisible(false);
                    this.myPrograms.get(data).dispose();
                }
                this.myPrograms.remove(data);
            }
            if (this.myAsmWindows.containsKey(data) && this.myAsmWindows.get(data) != null) {
                this.myAsmWindows.get(data).setVisible(false);
                this.myAsmWindows.get(data).dispose();
            }
        }

        public void showState(SocUpStateInterface data, CircuitStateHolder.HierarchyInfo csh) {
            if (this.parentFrame == null || data == null) {
                return;
            }
            if (this.myStates.containsKey(data) && this.myStates.get(data) != null) {
                ListeningFrame frame = this.myStates.get(data);
                frame.setVisible(true);
                int state = frame.getExtendedState();
                frame.setExtendedState(state &= 0xFFFFFFFE);
                return;
            }
            ListeningFrame frame = new ListeningFrame(data.getProcessorType(), Strings.S.getter("SocUpMenuCpuStateWindowTitle"), csh);
            JPanel statePanel = data.getStatePanel();
            frame.setSize(statePanel.getSize());
            frame.setResizable(false);
            this.parentFrame.addWindowListener(frame);
            frame.setVisible(true);
            frame.getContentPane().add(statePanel);
            frame.addWindowListener(data.getWindowListener());
            this.myStates.put(data, frame);
        }

        public void showProgram(SocUpStateInterface data, CircuitStateHolder.HierarchyInfo csh, CircuitState state) {
            if (this.parentFrame == null || data == null) {
                return;
            }
            if (this.myPrograms.containsKey(data) && this.myPrograms.get(data) != null) {
                ListeningFrame frame = this.myPrograms.get(data);
                frame.setVisible(true);
                int frameState = frame.getExtendedState();
                frame.setExtendedState(frameState &= 0xFFFFFFFE);
                return;
            }
            ListeningFrame frame = new ListeningFrame(data.getProcessorType(), Strings.S.getter("SocUpMenuCpuProgramWindowTitle"), csh);
            this.parentFrame.addWindowListener(frame);
            JPanel pan = data.getAsmWindow();
            frame.add(pan);
            frame.setVisible(true);
            frame.pack();
            frame.addWindowListener(data.getWindowListener());
            this.myPrograms.put(data, frame);
        }

        public void showAsmWindow(Instance inst, SocUpStateInterface data, CircuitStateHolder.HierarchyInfo csh, CircuitState state) {
            if (this.parentFrame == null || data == null) {
                return;
            }
            if (this.myAsmWindows.containsKey(data) && this.myAsmWindows.get(data) != null) {
                ListeningFrame frame = this.myAsmWindows.get(data);
                frame.setVisible(true);
                int fstate = frame.getExtendedState();
                frame.setExtendedState(fstate &= 0xFFFFFFFE);
                return;
            }
            ListeningFrame frame = new ListeningFrame(data.getProcessorType(), Strings.S.getter("SocUpMenuCpuAsmWindowTitle"), csh);
            this.parentFrame.addWindowListener(frame);
            AssemblerInterface assembler = data.getAssembler();
            AssemblerPanel pan = new AssemblerPanel(frame, assembler.getHighlightStringIdentifier(), assembler, data.getProcessorInterface(), state);
            frame.add(pan);
            frame.setVisible(true);
            frame.pack();
            frame.addWindowListener(data.getWindowListener());
            this.myAsmWindows.put(data, frame);
        }

        public void setParentFrame(Frame frame) {
            this.parentFrame = frame;
        }

        public void repaintStates() {
            for (SocUpStateInterface data : this.myStates.keySet()) {
                data.repaint();
            }
        }
    }

    private class MenuProvider
    implements MenuExtender,
    CircuitStateHolder {
        private final Instance instance;
        private final SocUpMenuProvider parent;
        SocUpStateInterface data;
        CircuitState circuitState;
        CircuitStateHolder.HierarchyInfo hierarchy;

        public MenuProvider(Instance inst, SocUpMenuProvider parent) {
            this.instance = inst;
            this.parent = parent;
            this.circuitState = null;
            this.data = null;
            this.hierarchy = null;
        }

        @Override
        public void configureMenu(JPopupMenu menu, Project proj) {
            CircuitStateHolder.HierarchyInfo hinfo;
            SocUpMenuProvider.this.setParentFrame(this.instance, proj.getFrame());
            Object instName = this.instance.getAttributeValue(StdAttr.LABEL);
            if (StringUtil.isNullOrEmpty((CharSequence)instName)) {
                Location loc = this.instance.getLocation();
                instName = this.instance.getFactory().getHDLName(this.instance.getAttributeSet()) + "@" + loc.getX() + "," + loc.getY();
            }
            String name = this.circuitState != null ? (String)instName + " : " + Strings.S.get("SocUpMenuAsmWindow") : Strings.S.get("SocUpMenuAsmWindow");
            CircuitState state = this.circuitState == null ? proj.getCircuitState() : this.circuitState;
            menu.addSeparator();
            if (this.circuitState == null) {
                hinfo = new CircuitStateHolder.HierarchyInfo(proj.getCurrentCircuit());
                hinfo.addComponent(this.instance.getComponent());
            } else {
                hinfo = this.hierarchy;
            }
            InstanceMenuItem asm = new InstanceMenuItem(this.instance, name, 4, this.instance.getData(state), state, hinfo);
            asm.addActionListener(this.parent);
            asm.setEnabled(true);
            menu.add(asm);
            name = this.circuitState != null ? (String)instName + " : " + Strings.S.get("SocUpMenuReadElf") : Strings.S.get("SocUpMenuReadElf");
            InstanceMenuItem readElf = new InstanceMenuItem(this.instance, name, 1, state);
            readElf.addActionListener(this.parent);
            readElf.setEnabled(true);
            menu.add(readElf);
            if (this.circuitState != null) {
                InstanceMenuItem showState = new InstanceMenuItem(this.instance, (String)instName + " : " + Strings.S.get("SocUpMenuShowState"), 2, this.data, this.hierarchy);
                showState.addActionListener(this.parent);
                showState.setEnabled(true);
                menu.add(showState);
            }
            String string = name = this.circuitState != null ? (String)instName + " : " + Strings.S.get("SocUpMenuShowProgram") : Strings.S.get("SocUpMenuShowProgram");
            if (state != null && ((SocUpStateInterface)((Object)this.instance.getData(state))).programLoaded()) {
                InstanceMenuItem showProg = new InstanceMenuItem(this.instance, name, 3, this.instance.getData(state), state, hinfo);
                showProg.addActionListener(this.parent);
                showProg.setEnabled(true);
                menu.add(showProg);
            }
        }

        @Override
        public void setCircuitState(CircuitState state) {
            if (state == null) {
                return;
            }
            this.circuitState = state;
            this.data = (SocUpStateInterface)state.getData(this.instance.getComponent());
        }

        @Override
        public void setHierarchyName(CircuitStateHolder.HierarchyInfo csh) {
            this.hierarchy = csh;
            this.hierarchy.addComponent(this.instance.getComponent());
        }
    }

    private static class InstanceMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;
        private final Instance instance;
        private final int function;
        private final SocUpStateInterface data;
        private final CircuitState circuitState;
        private final CircuitStateHolder.HierarchyInfo csh;

        public InstanceMenuItem(Instance inst, String label, int function, Object data, CircuitStateHolder.HierarchyInfo csh) {
            super(label);
            this.instance = inst;
            this.function = function;
            this.data = (SocUpStateInterface)data;
            this.circuitState = null;
            this.csh = csh;
        }

        public InstanceMenuItem(Instance inst, String label, int function, Object data, CircuitState state, CircuitStateHolder.HierarchyInfo csh) {
            super(label);
            this.instance = inst;
            this.function = function;
            this.data = (SocUpStateInterface)data;
            this.circuitState = state;
            this.csh = csh;
        }

        public InstanceMenuItem(Instance inst, String label, int function, CircuitState state) {
            super(label);
            this.instance = inst;
            this.function = function;
            this.data = null;
            this.circuitState = state;
            this.csh = null;
        }

        public Instance getInstance() {
            return this.instance;
        }

        public int getFunction() {
            return this.function;
        }

        public SocUpStateInterface getState() {
            return this.data;
        }

        public CircuitState getCircuitState() {
            return this.circuitState;
        }

        public CircuitStateHolder.HierarchyInfo getHierarchyInfo() {
            return this.csh;
        }
    }
}

