/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.data;

import com.cburch.contracts.BaseMouseListenerContract;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.gui.main.Frame;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.bus.SocBusAttributes;
import com.cburch.logisim.soc.data.SocBusInfo;
import com.cburch.logisim.soc.data.SocBusMasterInterface;
import com.cburch.logisim.soc.data.SocBusStateInfo;
import com.cburch.logisim.soc.data.SocBusTransaction;
import com.cburch.logisim.soc.data.SocInstanceFactory;
import com.cburch.logisim.util.StringUtil;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JLabel;

public class SocSimulationManager
implements SocBusMasterInterface {
    public static final Attribute<SocBusInfo> SOC_BUS_SELECT = new SocBusSelectAttribute();
    private final HashMap<String, SocBusStateInfo> socBusses = new HashMap();
    private final ArrayList<com.cburch.logisim.comp.Component> toBeChecked = new ArrayList();
    private CircuitState state;

    public String getSocBusDisplayString(String id) {
        if (StringUtil.isNullOrEmpty(id) || !this.socBusses.containsKey(id)) {
            return null;
        }
        SocBusStateInfo bus = this.socBusses.get(id);
        com.cburch.logisim.comp.Component comp = bus.getComponent();
        String name = null;
        if (comp != null && StringUtil.isNullOrEmpty(name = comp.getAttributeSet().getValue(StdAttr.LABEL))) {
            Location loc = comp.getLocation();
            name = String.format("%s@%d,%d", comp.getFactory().getDisplayName(), loc.getX(), loc.getY());
        }
        return name;
    }

    public boolean registerComponent(com.cburch.logisim.comp.Component c) {
        if (!c.getFactory().isSocComponent()) {
            return false;
        }
        SocInstanceFactory fact = (SocInstanceFactory)c.getFactory();
        if (fact.isSocUnknown()) {
            return false;
        }
        if (fact.isSocBus()) {
            SocBusInfo id = c.getAttributeSet().getValue(SocBusAttributes.SOC_BUS_ID);
            if (this.socBusses.containsKey(id.getBusId())) {
                this.socBusses.get(id.getBusId()).setComponent(c);
            } else {
                this.socBusses.put(id.getBusId(), new SocBusStateInfo(this, c));
            }
            c.getAttributeSet().getValue(SocBusAttributes.SOC_BUS_ID).setSocSimulationManager(this, c);
        }
        if (c.getAttributeSet().containsAttribute(SOC_BUS_SELECT)) {
            c.getAttributeSet().getValue(SOC_BUS_SELECT).setSocSimulationManager(this, c);
            if (fact.isSocSlave() || fact.isSocSniffer()) {
                this.toBeChecked.add(c);
                Iterator<com.cburch.logisim.comp.Component> iter = this.toBeChecked.iterator();
                while (iter.hasNext()) {
                    com.cburch.logisim.comp.Component comp = iter.next();
                    if (!comp.getAttributeSet().containsAttribute(SOC_BUS_SELECT)) continue;
                    String id = comp.getAttributeSet().getValue(SOC_BUS_SELECT).getBusId();
                    if (id != null && this.socBusses.containsKey(id)) {
                        SocBusStateInfo binfo = this.socBusses.get(id);
                        SocInstanceFactory factory = (SocInstanceFactory)comp.getFactory();
                        if (factory.isSocSlave()) {
                            binfo.registerSocBusSlave(factory.getSlaveInterface(comp.getAttributeSet()));
                        }
                        if (factory.isSocSniffer()) {
                            binfo.registerSocBusSniffer(factory.getSnifferInterface(comp.getAttributeSet()));
                        }
                        iter.remove();
                        continue;
                    }
                    if (id != null && !id.isEmpty()) continue;
                    iter.remove();
                }
            }
        }
        return true;
    }

    public boolean removeComponent(com.cburch.logisim.comp.Component c) {
        SocBusInfo binfo;
        SocBusStateInfo info;
        if (!c.getFactory().isSocComponent()) {
            return false;
        }
        SocInstanceFactory fact = (SocInstanceFactory)c.getFactory();
        if (fact.isSocUnknown()) {
            return false;
        }
        if (fact.isSocBus() && (info = this.socBusses.get(c.getAttributeSet().getValue(SocBusAttributes.SOC_BUS_ID).getBusId())) != null) {
            info.setComponent(null);
        }
        if ((fact.isSocSlave() || fact.isSocSniffer()) && (binfo = c.getAttributeSet().getValue(SOC_BUS_SELECT)) != null) {
            this.reRegisterSlaveSniffer(binfo.getBusId(), null, c);
        }
        return true;
    }

    public int nrOfSocBusses() {
        int result = 0;
        for (String s : this.socBusses.keySet()) {
            if (this.socBusses.get(s).getComponent() == null) continue;
            ++result;
        }
        return result;
    }

    public boolean hasSocBusses() {
        return this.nrOfSocBusses() != 0;
    }

    public String getGuiBusId() {
        HashMap<String, String> busses = new HashMap<String, String>();
        for (String id : this.socBusses.keySet()) {
            if (this.socBusses.get(id).getComponent() == null) continue;
            busses.put(this.getSocBusDisplayString(id), id);
        }
        String res = (String)OptionPane.showInputDialog(null, Strings.S.get("SocBusManagerSelectBus"), Strings.S.get("SocBusSelectAttr"), -1, null, busses.keySet().toArray(), "");
        return StringUtil.isNotEmpty(res) ? (String)busses.get(res) : "";
    }

    public SocBusStateInfo getSocBusState(String busId) {
        return this.socBusses.get(busId);
    }

    public void reRegisterSlaveSniffer(String oldId, String newId, com.cburch.logisim.comp.Component comp) {
        SocInstanceFactory fact = (SocInstanceFactory)comp.getFactory();
        if (oldId != null && this.socBusses.containsKey(oldId)) {
            SocBusStateInfo binfo = this.socBusses.get(oldId);
            if (fact.isSocSlave()) {
                binfo.removeSocBusSlave(fact.getSlaveInterface(comp.getAttributeSet()));
            }
            if (fact.isSocSniffer()) {
                binfo.removeSocBusSniffer(fact.getSnifferInterface(comp.getAttributeSet()));
            }
        }
        if (newId != null && this.socBusses.containsKey(newId)) {
            SocBusStateInfo busInfo = this.socBusses.get(newId);
            if (fact.isSocSlave()) {
                busInfo.registerSocBusSlave(fact.getSlaveInterface(comp.getAttributeSet()));
            }
            if (fact.isSocSniffer()) {
                busInfo.registerSocBusSniffer(fact.getSnifferInterface(comp.getAttributeSet()));
            }
        }
        this.toBeChecked.remove(comp);
    }

    public Object getdata(com.cburch.logisim.comp.Component comp) {
        if (this.state == null) {
            return null;
        }
        return this.state.getData(comp);
    }

    public InstanceState getState(com.cburch.logisim.comp.Component comp) {
        if (this.state == null) {
            return null;
        }
        return this.state.getInstanceState(comp);
    }

    @Override
    public void initializeTransaction(SocBusTransaction trans, String busId, CircuitState cState) {
        this.state = cState;
        SocBusStateInfo info = this.socBusses.get(busId);
        if (info == null || info.getComponent() == null) {
            trans.setError(5);
            return;
        }
        Iterator<com.cburch.logisim.comp.Component> iter = this.toBeChecked.iterator();
        while (iter.hasNext()) {
            com.cburch.logisim.comp.Component comp = iter.next();
            if (comp.getAttributeSet().containsAttribute(SOC_BUS_SELECT)) {
                String id = comp.getAttributeSet().getValue(SOC_BUS_SELECT).getBusId();
                if (id != null && this.socBusses.containsKey(id)) {
                    binfo = this.socBusses.get(id);
                    SocInstanceFactory fact = (SocInstanceFactory)comp.getFactory();
                    if (fact.isSocSlave()) {
                        ((SocBusStateInfo)binfo).registerSocBusSlave(fact.getSlaveInterface(comp.getAttributeSet()));
                    }
                    if (fact.isSocSniffer()) {
                        ((SocBusStateInfo)binfo).registerSocBusSniffer(fact.getSnifferInterface(comp.getAttributeSet()));
                    }
                } else {
                    binfo = comp.getAttributeSet().getValue(SOC_BUS_SELECT);
                    ((SocBusInfo)binfo).setBusId("");
                    comp.getAttributeSet().setValue(SOC_BUS_SELECT, binfo);
                }
            }
            iter.remove();
        }
        info.initializeTransaction(trans, busId);
    }

    private static class SocBusSelectAttribute
    extends Attribute<SocBusInfo> {
        private SocBusSelectAttribute() {
            super("SocBusSelection", Strings.S.getter("SocBusSelectAttr"));
        }

        @Override
        public SocBusInfo parse(String value) {
            return new SocBusInfo(value);
        }

        @Override
        public Component getCellEditor(Window source, SocBusInfo value) {
            SocBusSelector ret = new SocBusSelector(source, value);
            ret.mouseClicked(null);
            return ret;
        }

        @Override
        public String toDisplayString(SocBusInfo f) {
            return Strings.S.get("SocBusSelectAttrClick");
        }

        @Override
        public String toStandardString(SocBusInfo value) {
            return value.getBusId();
        }
    }

    private static class SocBusSelector
    extends JLabel
    implements BaseMouseListenerContract {
        private static final long serialVersionUID = 1L;
        private Circuit myCirc = null;
        private final SocBusInfo myValue;

        public SocBusSelector(Window source, SocBusInfo value) {
            super(Strings.S.get("SocBusSelectAttrClick"));
            this.repaint();
            if (source instanceof Frame) {
                Frame frame = (Frame)source;
                this.myCirc = frame.getProject().getCurrentCircuit();
            }
            this.myValue = value;
            this.addMouseListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.myCirc == null) {
                return;
            }
            SocSimulationManager socMan = this.myCirc.getSocSimulationManager();
            if (!socMan.hasSocBusses()) {
                OptionPane.showMessageDialog(null, Strings.S.get("SocManagerNoBusses"), Strings.S.get("SocBusSelectAttr"), 0);
                return;
            }
            String id = socMan.getGuiBusId();
            if (StringUtil.isNotEmpty(id)) {
                String oldId = this.myValue.getBusId();
                com.cburch.logisim.comp.Component comp = this.myValue.getComponent();
                if (comp == null) {
                    return;
                }
                if (oldId != null && !oldId.equals(id)) {
                    this.myValue.getSocSimulationManager().reRegisterSlaveSniffer(oldId, id, comp);
                    SocBusInfo newId = new SocBusInfo(id);
                    newId.setSocSimulationManager(this.myValue.getSocSimulationManager(), comp);
                    comp.getAttributeSet().setValue(SOC_BUS_SELECT, newId);
                }
            }
        }
    }
}

