/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.data;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.soc.data.SocBusSlaveInterface;
import com.cburch.logisim.soc.data.SocBusSnifferInterface;
import com.cburch.logisim.soc.data.SocProcessorInterface;
import com.cburch.logisim.util.StringGetter;

public abstract class SocInstanceFactory
extends InstanceFactory {
    public static final int SOC_UNKNOWN = 0;
    public static final int SOC_MASTER = 1;
    public static final int SOC_SLAVE = 2;
    public static final int SOC_BUS = 4;
    public static final int SOC_SNIFFER = 8;
    private int myType = 0;

    public SocInstanceFactory(String name, StringGetter displayName, int type) {
        super(name, displayName);
        this.myType = type;
    }

    @Override
    public void paintInstance(InstancePainter painter) {
    }

    @Override
    public void propagate(InstanceState state) {
    }

    @Override
    public boolean isSocComponent() {
        return true;
    }

    public int getSocType() {
        return this.myType;
    }

    public boolean isSocSlave() {
        return (this.myType & 2) != 0;
    }

    public boolean isSocSniffer() {
        return (this.myType & 8) != 0;
    }

    public boolean isSocBus() {
        return (this.myType & 4) != 0;
    }

    public boolean isSocMaster() {
        return (this.myType & 1) != 0;
    }

    public boolean isSocUnknown() {
        return this.myType == 0;
    }

    public abstract SocBusSlaveInterface getSlaveInterface(AttributeSet var1);

    public abstract SocBusSnifferInterface getSnifferInterface(AttributeSet var1);

    public abstract SocProcessorInterface getProcessorInterface(AttributeSet var1);
}

