/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.prefs;

import com.cburch.logisim.prefs.AppPreferences;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;

class RecentProjects
implements PreferenceChangeListener {
    private static final String BASE_PROPERTY = "recent";
    private static final int NUM_RECENT = 10;
    private final File[] recentFiles = new File[10];
    private final long[] recentTimes = new long[10];

    private static boolean isSame(Object a, Object b) {
        return Objects.equals(a, b);
    }

    RecentProjects() {
        Arrays.fill(this.recentTimes, System.currentTimeMillis());
        Preferences prefs = AppPreferences.getPrefs();
        prefs.addPreferenceChangeListener(this);
        for (int index = 0; index < 10; ++index) {
            this.getAndDecode(prefs, index);
        }
    }

    private void getAndDecode(Preferences prefs, int index) {
        String encoding = prefs.get(BASE_PROPERTY + index, null);
        if (encoding == null) {
            return;
        }
        int semi = encoding.indexOf(59);
        if (semi < 0) {
            return;
        }
        try {
            long time = Long.parseLong(encoding.substring(0, semi));
            File file = new File(encoding.substring(semi + 1));
            this.updateInto(index, time, file);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public List<File> getRecentFiles() {
        long now = System.currentTimeMillis();
        long[] ages = new long[10];
        long[] toSort = new long[10];
        for (int i = 0; i < 10; ++i) {
            ages[i] = this.recentFiles[i] == null ? -1L : now - this.recentTimes[i];
            toSort[i] = ages[i];
        }
        Arrays.sort(toSort);
        ArrayList<File> ret = new ArrayList<File>();
        for (long age : toSort) {
            if (age < 0L) continue;
            int index = -1;
            for (int i = 0; i < 10; ++i) {
                if (ages[i] != age) continue;
                index = i;
                ages[i] = -1L;
                break;
            }
            if (index < 0) continue;
            ret.add(this.recentFiles[index]);
        }
        return ret;
    }

    private int getReplacementIndex(long now, File f) {
        long oldestAge = -1L;
        int oldestIndex = 0;
        int nullIndex = -1;
        for (int i = 0; i < 10; ++i) {
            long age;
            if (f.equals(this.recentFiles[i])) {
                return i;
            }
            if (this.recentFiles[i] == null) {
                nullIndex = i;
            }
            if ((age = now - this.recentTimes[i]) <= oldestAge) continue;
            oldestIndex = i;
            oldestAge = age;
        }
        if (nullIndex != -1) {
            return nullIndex;
        }
        return oldestIndex;
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent event) {
        Preferences prefs = event.getNode();
        String prop = event.getKey();
        if (prop.startsWith(BASE_PROPERTY)) {
            String rest = prop.substring(BASE_PROPERTY.length());
            int index = -1;
            try {
                index = Integer.parseInt(rest);
                if (index < 0 || index >= 10) {
                    index = -1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (index >= 0) {
                File oldValue = this.recentFiles[index];
                long oldTime = this.recentTimes[index];
                this.getAndDecode(prefs, index);
                File newValue = this.recentFiles[index];
                long newTime = this.recentTimes[index];
                if (!RecentProjects.isSame(oldValue, newValue) || oldTime != newTime) {
                    AppPreferences.firePropertyChange("recentProjects", new FileTime(oldValue, oldTime), new FileTime(newValue, newTime));
                }
            }
        }
    }

    private void updateInto(int index, long time, File file) {
        File oldFile = this.recentFiles[index];
        long oldTime = this.recentTimes[index];
        if (!RecentProjects.isSame(oldFile, file) || oldTime != time) {
            this.recentFiles[index] = file;
            this.recentTimes[index] = time;
            try {
                AppPreferences.getPrefs().put(BASE_PROPERTY + index, time + ";" + file.getCanonicalPath());
                AppPreferences.firePropertyChange("recentProjects", new FileTime(oldFile, oldTime), new FileTime(file, time));
            }
            catch (IOException e) {
                this.recentFiles[index] = oldFile;
                this.recentTimes[index] = oldTime;
            }
        }
    }

    public void updateRecent(File file) {
        File fileToSave = file;
        try {
            fileToSave = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        long now = System.currentTimeMillis();
        int index = this.getReplacementIndex(now, fileToSave);
        this.updateInto(index, now, fileToSave);
    }

    private static class FileTime {
        private final long time;
        private final File file;

        public FileTime(File file, long time) {
            this.time = time;
            this.file = file;
        }

        public boolean equals(Object other) {
            boolean bl;
            if (other instanceof FileTime) {
                FileTime o = (FileTime)other;
                bl = this.time == o.time && RecentProjects.isSame(this.file, o.file);
            } else {
                bl = false;
            }
            return bl;
        }
    }
}

