/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.prefs;

import com.cburch.logisim.circuit.RadixOption;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.prefs.OptionsPanel;
import com.cburch.logisim.gui.prefs.PrefBoolean;
import com.cburch.logisim.gui.prefs.PrefOption;
import com.cburch.logisim.gui.prefs.PrefOptionList;
import com.cburch.logisim.gui.prefs.PreferencesFrame;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.Projects;
import com.cburch.logisim.util.TableLayout;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.JPanel;

class LayoutOptions
extends OptionsPanel {
    private static final long serialVersionUID = 1L;
    private final PrefBoolean[] checks;
    private final PrefOptionList afterAdd;
    private final PrefOptionList defaultAppearance;
    private final PrefOptionList prefPinAppearance;
    private PrefOptionList radix1;
    private PrefOptionList radix2;

    public LayoutOptions(PreferencesFrame window) {
        super(window);
        AppPreferences.getPrefs().addPreferenceChangeListener(new MyListener());
        this.checks = new PrefBoolean[]{new PrefBoolean(AppPreferences.AntiAliassing, Strings.S.getter("layoutAntiAliasing")), new PrefBoolean(AppPreferences.ATTRIBUTE_HALO, Strings.S.getter("layoutAttributeHalo")), new PrefBoolean(AppPreferences.COMPONENT_TIPS, Strings.S.getter("layoutShowTips")), new PrefBoolean(AppPreferences.MOVE_KEEP_CONNECT, Strings.S.getter("layoutMoveKeepConnect")), new PrefBoolean(AppPreferences.ADD_SHOW_GHOSTS, Strings.S.getter("layoutAddShowGhosts")), new PrefBoolean(AppPreferences.NAMED_CIRCUIT_BOXES_FIXED_SIZE, Strings.S.getter("layoutNamedCircuitBoxesFixedSize")), new PrefBoolean(AppPreferences.NEW_INPUT_OUTPUT_SHAPES, Strings.S.getter("layoutUseNewInputOutputSymbols"))};
        for (int i = 0; i < 2; ++i) {
            RadixOption[] opts = RadixOption.OPTIONS;
            PrefOption[] items = new PrefOption[opts.length];
            for (int j = 0; j < RadixOption.OPTIONS.length; ++j) {
                items[j] = new PrefOption(opts[j].getSaveString(), opts[j].getDisplayGetter());
            }
            if (i == 0) {
                this.radix1 = new PrefOptionList(AppPreferences.POKE_WIRE_RADIX1, Strings.S.getter("layoutRadix1"), items);
                continue;
            }
            this.radix2 = new PrefOptionList(AppPreferences.POKE_WIRE_RADIX2, Strings.S.getter("layoutRadix2"), items);
        }
        this.afterAdd = new PrefOptionList(AppPreferences.ADD_AFTER, Strings.S.getter("layoutAddAfter"), new PrefOption[]{new PrefOption("unchanged", Strings.S.getter("layoutAddAfterUnchanged")), new PrefOption("edit", Strings.S.getter("layoutAddAfterEdit"))});
        this.defaultAppearance = new PrefOptionList(AppPreferences.DefaultAppearance, Strings.S.getter("layoutDefaultAppearance"), new PrefOption[]{new PrefOption(StdAttr.APPEAR_CLASSIC.toString(), StdAttr.APPEAR_CLASSIC.getDisplayGetter()), new PrefOption(StdAttr.APPEAR_FPGA.toString(), StdAttr.APPEAR_FPGA.getDisplayGetter()), new PrefOption(StdAttr.APPEAR_EVOLUTION.toString(), StdAttr.APPEAR_EVOLUTION.getDisplayGetter())});
        this.prefPinAppearance = new PrefOptionList(AppPreferences.PinAppearance, Strings.S.getter("layoutPinAppearance"), new PrefOption[]{new PrefOption("dot-small", Strings.S.getter("layoutPinAppearanceDotSmall")), new PrefOption("dot-medium", Strings.S.getter("layoutPinAppearanceDotMedium")), new PrefOption("dot-big", Strings.S.getter("layoutPinAppearanceDotBig")), new PrefOption("dot-bigger", Strings.S.getter("layoutPinAppearanceDotBigger"))});
        JPanel panel = new JPanel(new TableLayout(2));
        panel.add(this.defaultAppearance.getJLabel());
        panel.add(this.defaultAppearance.getJComboBox());
        panel.add(this.afterAdd.getJLabel());
        panel.add(this.afterAdd.getJComboBox());
        panel.add(this.radix1.getJLabel());
        panel.add(this.radix1.getJComboBox());
        panel.add(this.radix2.getJLabel());
        panel.add(this.radix2.getJComboBox());
        panel.add(this.prefPinAppearance.getJLabel());
        panel.add(this.prefPinAppearance.getJComboBox());
        this.setLayout(new TableLayout(1));
        for (PrefBoolean check : this.checks) {
            this.add(check);
        }
        this.add(panel);
    }

    @Override
    public String getHelpText() {
        return Strings.S.get("layoutHelp");
    }

    @Override
    public String getTitle() {
        return Strings.S.get("layoutTitle");
    }

    @Override
    public void localeChanged() {
        for (PrefBoolean check : this.checks) {
            check.localeChanged();
        }
        this.radix1.localeChanged();
        this.radix2.localeChanged();
        this.afterAdd.localeChanged();
        this.defaultAppearance.localeChanged();
    }

    private static class MyListener
    implements PreferenceChangeListener {
        private MyListener() {
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            boolean update = evt.getKey().equals(AppPreferences.PinAppearance.getIdentifier());
            if (update) {
                for (Project proj : Projects.getOpenProjects()) {
                    proj.getFrame().repaint();
                }
            }
        }
    }
}

