/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.file.FileStatistics;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.tools.Library;
import com.cburch.logisim.util.TableSorter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class StatisticsDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;

    private StatisticsDialog(JFrame parent, String circuitName, StatisticsTableModel model) {
        super((Frame)parent, true);
        this.setDefaultCloseOperation(2);
        this.setTitle(Strings.S.get("statsDialogTitle", circuitName));
        StatisticsTable table = new StatisticsTable();
        TableSorter mySorter = new TableSorter(model, table.getTableHeader());
        CompareString comp = new CompareString("", Strings.S.get("statsTotalWithout"), Strings.S.get("statsTotalWith"));
        mySorter.setColumnComparator(String.class, comp);
        table.setModel(mySorter);
        JScrollPane tablePane = new JScrollPane(table);
        JButton button = new JButton(Strings.S.get("statsCloseButton"));
        button.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(button);
        Container contents = this.getContentPane();
        contents.setLayout(new BorderLayout());
        contents.add((Component)tablePane, "Center");
        contents.add((Component)buttonPanel, "Last");
        this.pack();
        Dimension pref = contents.getPreferredSize();
        if (pref.width > 750 || pref.height > 550) {
            if (pref.width > 750) {
                pref.width = 750;
            }
            if (pref.height > 550) {
                pref.height = 550;
            }
            this.setSize(pref);
        }
    }

    public static void show(JFrame parent, LogisimFile file, Circuit circuit) {
        FileStatistics stats = FileStatistics.compute(file, circuit);
        StatisticsDialog dlog = new StatisticsDialog(parent, circuit.getName(), new StatisticsTableModel(stats));
        dlog.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.dispose();
    }

    private static class StatisticsTable
    extends JTable {
        private static final long serialVersionUID = 1L;

        private StatisticsTable() {
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(x, y, width, height);
            this.setPreferredColumnWidths(new double[]{0.45, 0.25, 0.1, 0.1, 0.1});
        }

        protected void setPreferredColumnWidths(double[] percentages) {
            int i;
            Dimension tableDim = this.getPreferredSize();
            double total = 0.0;
            for (i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
                total += percentages[i];
            }
            for (i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
                TableColumn column = this.getColumnModel().getColumn(i);
                double width = (double)tableDim.width * (percentages[i] / total);
                column.setPreferredWidth((int)width);
            }
        }
    }

    private static class CompareString
    implements Comparator<String> {
        private final String[] fixedAtBottom;

        public CompareString(String ... fixedAtBottom) {
            this.fixedAtBottom = fixedAtBottom;
        }

        @Override
        public int compare(String a, String b) {
            for (int i = this.fixedAtBottom.length - 1; i >= 0; --i) {
                String s = this.fixedAtBottom[i];
                if (a.equals(s)) {
                    return b.equals(s) ? 0 : 1;
                }
                if (!b.equals(s)) continue;
                return -1;
            }
            return a.compareToIgnoreCase(b);
        }
    }

    private static class StatisticsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final FileStatistics stats;

        StatisticsTableModel(FileStatistics stats) {
            this.stats = stats;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return column < 2 ? String.class : Integer.class;
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int column) {
            return switch (column) {
                case 0 -> Strings.S.get("statsComponentColumn");
                case 1 -> Strings.S.get("statsLibraryColumn");
                case 2 -> Strings.S.get("statsSimpleCountColumn");
                case 3 -> Strings.S.get("statsUniqueCountColumn");
                case 4 -> Strings.S.get("statsRecursiveCountColumn");
                default -> "??";
            };
        }

        @Override
        public int getRowCount() {
            return this.stats.getCounts().size() + 2;
        }

        @Override
        public Object getValueAt(int row, int column) {
            List<FileStatistics.Count> counts = this.stats.getCounts();
            int countsLen = counts.size();
            if (row < 0 || row >= countsLen + 2) {
                return "";
            }
            FileStatistics.Count count = row < countsLen ? counts.get(row) : (row == countsLen ? this.stats.getTotalWithoutSubcircuits() : this.stats.getTotalWithSubcircuits());
            switch (column) {
                case 0: {
                    if (row < countsLen) {
                        return count.getFactory().getDisplayName();
                    }
                    if (row == countsLen) {
                        return Strings.S.get("statsTotalWithout");
                    }
                    return Strings.S.get("statsTotalWith");
                }
                case 1: {
                    if (row < countsLen) {
                        Library lib = count.getLibrary();
                        return lib == null ? "-" : lib.getDisplayName();
                    }
                    return "";
                }
                case 2: {
                    return count.getSimpleCount();
                }
                case 3: {
                    return count.getUniqueCount();
                }
                case 4: {
                    return count.getRecursiveCount();
                }
            }
            return "";
        }
    }
}

