/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.icons;

import com.cburch.logisim.gui.icons.BaseIcon;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;

public class FlipFlopIcon
extends BaseIcon {
    public static final int D_FLIPFLOP = 0;
    public static final int T_FLIPFLOP = 1;
    public static final int JK_FLIPFLOP = 2;
    public static final int SR_FLIPFLOP = 3;
    public static final int REGISTER = 4;
    private final int type;

    public FlipFlopIcon(int type) {
        this.type = type;
    }

    @Override
    protected void paintIcon(Graphics2D g2) {
        if (AppPreferences.getDefaultAppearance().equals(StdAttr.APPEAR_CLASSIC)) {
            this.paintClassicIcon(g2);
        } else {
            this.paintEvolutionIcon(g2);
        }
    }

    private void paintClassicIcon(Graphics2D g2) {
        g2.drawRect(this.scale(2), this.scale(2), this.scale(12), this.scale(12));
        String str = "";
        switch (this.type) {
            case 0: {
                str = "D";
                break;
            }
            case 1: {
                str = "T";
                break;
            }
            case 2: {
                str = "JK";
                break;
            }
            case 3: {
                str = "SR";
                break;
            }
            case 4: {
                str = "00";
                break;
            }
        }
        Font f = g2.getFont().deriveFont((float)((double)AppPreferences.getIconSize() / 2.1));
        TextLayout l = new TextLayout(str, f, g2.getFontRenderContext());
        l.draw(g2, (float)((double)(this.getIconWidth() / 2) - l.getBounds().getCenterX()), (float)((double)(this.getIconHeight() / 2) - l.getBounds().getCenterY()));
    }

    private void paintEvolutionIcon(Graphics2D g2) {
        if (this.type == 4) {
            this.paintRegisterIcon(g2);
            return;
        }
        g2.drawRect(this.scale(4), 0, this.scale(8), this.scale(16));
        g2.drawLine(this.scale(0), this.scale(3), this.scale(4), this.scale(3));
        g2.drawLine(this.scale(12), this.scale(3), this.scale(15), this.scale(3));
        if (this.type == 2 || this.type == 3) {
            g2.drawLine(this.scale(0), this.scale(7), this.scale(4), this.scale(7));
        }
        g2.drawLine(this.scale(0), this.scale(12), this.scale(4), this.scale(12));
        int[] xp = new int[]{this.scale(4), this.scale(7), this.scale(4)};
        int[] yp = new int[]{this.scale(11), this.scale(12), this.scale(13)};
        g2.drawPolygon(xp, yp, 3);
        g2.drawOval(this.scale(12), this.scale(10), this.scale(4), this.scale(4));
        GeneralPath p = new GeneralPath();
        switch (this.type) {
            case 0: {
                p.moveTo(this.scale(7), this.scale(5));
                p.lineTo(this.scale(6), this.scale(5));
                p.lineTo(this.scale(6), this.scale(2));
                p.lineTo(this.scale(7), this.scale(2));
                p.quadTo(this.scale(10), this.scale(4), this.scale(7), this.scale(5));
                break;
            }
            case 1: {
                p.moveTo(this.scale(6), this.scale(2));
                p.lineTo(this.scale(8), this.scale(2));
                p.moveTo(this.scale(7), this.scale(2));
                p.lineTo(this.scale(7), this.scale(4));
                break;
            }
            case 2: {
                p.moveTo(this.scale(6), this.scale(2));
                p.lineTo(this.scale(8), this.scale(2));
                p.lineTo(this.scale(8), this.scale(4));
                p.quadTo(this.scale(7), this.scale(6), this.scale(6), this.scale(4));
                p.moveTo(this.scale(6), this.scale(6));
                p.lineTo(this.scale(6), this.scale(8));
                p.moveTo(this.scale(8), this.scale(6));
                p.lineTo(this.scale(7), this.scale(7));
                p.lineTo(this.scale(8), this.scale(8));
                break;
            }
            case 3: {
                p.moveTo(this.scale(7), this.scale(1));
                p.curveTo(this.scale(4), this.scale(2), this.scale(9), this.scale(4), this.scale(6), this.scale(5));
                p.moveTo(this.scale(6), this.scale(9));
                p.lineTo(this.scale(6), this.scale(6));
                p.quadTo(this.scale(9), this.scale(7), this.scale(7), this.scale(8));
                p.lineTo(this.scale(8), this.scale(9));
                break;
            }
        }
        g2.draw(p);
    }

    private void paintRegisterIcon(Graphics2D g2) {
        for (int i = 2; i >= 0; --i) {
            g2.setColor(Color.WHITE);
            g2.fillRect(this.scale((i + 1) * 2), this.scale(4 - i * 2), this.scale(8), this.scale(12));
            g2.setColor(Color.BLACK);
            g2.drawRect(this.scale((i + 1) * 2), this.scale(4 - i * 2), this.scale(8), this.scale(12));
        }
        int[] xp = new int[]{this.scale(2), this.scale(5), this.scale(2)};
        int[] yp = new int[]{this.scale(11), this.scale(12), this.scale(13)};
        g2.drawPolygon(xp, yp, 3);
        g2.drawLine(this.scale(0), this.scale(12), this.scale(2), this.scale(12));
        g2.fillRect(0, this.scale(5), this.scale(2), this.scale(2));
        g2.fillRect(this.scale(10), this.scale(5), this.scale(6), this.scale(2));
    }
}

