/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.hex;

import com.cburch.hex.HexEditor;
import com.cburch.hex.HexModel;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.generic.LFrame;
import com.cburch.logisim.gui.hex.Clip;
import com.cburch.logisim.gui.hex.HexFile;
import com.cburch.logisim.gui.menu.LogisimMenuBar;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.memory.MemContents;
import com.cburch.logisim.util.LocaleListener;
import com.cburch.logisim.util.LocaleManager;
import com.cburch.logisim.util.WindowMenuItemManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HexFrame
extends LFrame.SubWindow {
    private static final long serialVersionUID = 1L;
    private final WindowMenuManager windowManager = new WindowMenuManager();
    private final EditListener editListener = new EditListener();
    private final MyListener myListener = new MyListener();
    private final HexModel model;
    private final HexEditor editor;
    private final JButton open = new JButton();
    private final JButton save = new JButton();
    private final JButton close = new JButton();
    private final Instance instance;

    public HexFrame(Project project, Instance instance, HexModel model) {
        super(project);
        this.setDefaultCloseOperation(1);
        this.model = model;
        this.editor = new HexEditor(model);
        this.instance = instance;
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.open);
        buttonPanel.add(this.save);
        buttonPanel.add(this.close);
        this.open.addActionListener(this.myListener);
        this.save.addActionListener(this.myListener);
        this.close.addActionListener(this.myListener);
        Dimension pref = this.editor.getPreferredSize();
        JScrollPane scroll = new JScrollPane(this.editor, 22, 31);
        pref.height = Math.min(pref.height, pref.width * 3 / 2);
        scroll.setPreferredSize(pref);
        scroll.getViewport().setBackground(this.editor.getBackground());
        Container contents = this.getContentPane();
        contents.add((Component)scroll, "Center");
        contents.add((Component)buttonPanel, "South");
        LocaleManager.addLocaleListener(this.myListener);
        this.myListener.localeChanged();
        this.pack();
        Dimension size = this.getSize();
        Dimension screen = this.getToolkit().getScreenSize();
        if (size.width > screen.width || size.height > screen.height) {
            size.width = Math.min(size.width, screen.width);
            size.height = Math.min(size.height, screen.height);
            this.setSize(size);
        }
        this.editor.getCaret().addChangeListener(this.editListener);
        this.editor.getCaret().setDot(0L, false);
        this.editListener.register(this.menubar);
        this.setLocationRelativeTo(project.getFrame());
    }

    public void closeAndDispose() {
        WindowEvent e = new WindowEvent(this, 201);
        this.processWindowEvent(e);
        this.dispose();
    }

    @Override
    public void setVisible(boolean value) {
        if (value && !this.isVisible()) {
            this.windowManager.frameOpened(this);
        }
        super.setVisible(value);
    }

    private class WindowMenuManager
    extends WindowMenuItemManager
    implements LocaleListener {
        WindowMenuManager() {
            super(Strings.S.get("hexFrameMenuItem"), false);
            LocaleManager.addLocaleListener(this);
        }

        @Override
        public JFrame getJFrame(boolean create, Component parent) {
            return HexFrame.this;
        }

        @Override
        public void localeChanged() {
            this.setText(Strings.S.get("hexFrameMenuItem"));
        }
    }

    private class EditListener
    implements ActionListener,
    ChangeListener {
        private Clip clip = null;

        private EditListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == LogisimMenuBar.CUT) {
                this.getClip().copy();
                HexFrame.this.editor.delete();
            } else if (src == LogisimMenuBar.COPY) {
                this.getClip().copy();
            } else if (src == LogisimMenuBar.PASTE) {
                this.getClip().paste();
            } else if (src == LogisimMenuBar.DELETE) {
                HexFrame.this.editor.delete();
            } else if (src == LogisimMenuBar.SELECT_ALL) {
                HexFrame.this.editor.selectAll();
            }
        }

        private void enableItems(LogisimMenuBar menubar) {
            boolean sel = HexFrame.this.editor.selectionExists();
            boolean clip = true;
            menubar.setEnabled(LogisimMenuBar.CUT, sel);
            menubar.setEnabled(LogisimMenuBar.COPY, sel);
            menubar.setEnabled(LogisimMenuBar.PASTE, true);
            menubar.setEnabled(LogisimMenuBar.DELETE, sel);
            menubar.setEnabled(LogisimMenuBar.SELECT_ALL, true);
        }

        private Clip getClip() {
            if (this.clip == null) {
                this.clip = new Clip(HexFrame.this.editor);
            }
            return this.clip;
        }

        private void register(LogisimMenuBar menubar) {
            menubar.addActionListener(LogisimMenuBar.CUT, this);
            menubar.addActionListener(LogisimMenuBar.COPY, this);
            menubar.addActionListener(LogisimMenuBar.PASTE, this);
            menubar.addActionListener(LogisimMenuBar.DELETE, this);
            menubar.addActionListener(LogisimMenuBar.SELECT_ALL, this);
            this.enableItems(menubar);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.enableItems((LogisimMenuBar)HexFrame.this.getJMenuBar());
        }
    }

    private class MyListener
    implements ActionListener,
    LocaleListener {
        private MyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object src = event.getSource();
            if (src == HexFrame.this.open) {
                HexFile.open((MemContents)HexFrame.this.model, HexFrame.this, HexFrame.this.project, HexFrame.this.instance);
            } else if (src == HexFrame.this.save) {
                HexFile.save((MemContents)HexFrame.this.model, HexFrame.this, HexFrame.this.project, HexFrame.this.instance);
            } else if (src == HexFrame.this.close) {
                WindowEvent e = new WindowEvent(HexFrame.this, 201);
                HexFrame.this.processWindowEvent(e);
            }
        }

        @Override
        public void localeChanged() {
            HexFrame.this.setTitle(Strings.S.get("hexFrameTitle"));
            HexFrame.this.open.setText(Strings.S.get("openButton"));
            HexFrame.this.save.setText(Strings.S.get("saveButton"));
            HexFrame.this.close.setText(Strings.S.get("closeButton"));
        }
    }
}

