/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.generic;

import com.cburch.logisim.gui.generic.CanvasPane;
import com.cburch.logisim.gui.generic.ZoomModel;
import com.cburch.logisim.prefs.PrefMonitor;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import javax.swing.SwingUtilities;

public class BasicZoomModel
implements ZoomModel {
    private final List<Double> zoomOptions;
    private final PropertyChangeSupport support;
    private final CanvasPane canvas;
    private double zoomFactor;
    private boolean showGrid;

    public BasicZoomModel(PrefMonitor<Boolean> gridPref, PrefMonitor<Double> zoomPref, List<Double> zoomOpts, CanvasPane pane) {
        this.zoomOptions = zoomOpts;
        this.support = new PropertyChangeSupport(this);
        this.zoomFactor = 1.0;
        this.showGrid = true;
        this.canvas = pane;
        this.setZoomFactor(zoomPref.get());
        this.setShowGrid(gridPref.getBoolean());
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        this.support.addPropertyChangeListener(prop, l);
    }

    @Override
    public boolean getShowGrid() {
        return this.showGrid;
    }

    @Override
    public void setShowGrid(boolean value) {
        if (value != this.showGrid) {
            this.showGrid = value;
            this.support.firePropertyChange("grid", !value, value);
        }
    }

    @Override
    public double getZoomFactor() {
        return this.zoomFactor;
    }

    @Override
    public List<Double> getZoomOptions() {
        return this.zoomOptions;
    }

    @Override
    public void setZoomFactor(double value) {
        double oldValue = this.zoomFactor;
        if (value != oldValue) {
            this.zoomFactor = value;
            this.support.firePropertyChange("zoom", oldValue, value);
        }
    }

    @Override
    public void setZoomFactor(double value, MouseEvent e) {
        double oldValue = this.zoomFactor;
        if (value != oldValue) {
            if (this.canvas == null) {
                this.setZoomFactor(value);
            }
            int mx = this.canvas.getHorizontalScrollBar().getMaximum();
            int vx = this.canvas.getHorizontalScrollBar().getValue();
            int ex = this.canvas.getHorizontalScrollBar().getVisibleAmount();
            int rx = e.getX() - vx;
            int my = this.canvas.getVerticalScrollBar().getMaximum();
            int vy = this.canvas.getVerticalScrollBar().getValue();
            int ey = this.canvas.getVerticalScrollBar().getVisibleAmount();
            int ry = e.getY() - vy;
            this.zoomFactor = value;
            this.support.firePropertyChange("zoom", oldValue, value);
            double nmx = (double)mx * value / oldValue;
            double px = (double)(vx / mx) + ((double)(ex / mx) - (double)ex / nmx) * (double)(rx / ex);
            int nvx = (int)(nmx * px);
            double nmy = (double)my * value / oldValue;
            double py = (double)(vy / my) + ((double)(ey / my) - (double)ey / nmy) * (double)(ry / ey);
            int nvy = (int)(nmy * py);
            this.canvas.getHorizontalScrollBar().setValue(nvx);
            this.canvas.getVerticalScrollBar().setValue(nvy);
        }
    }

    @Override
    public void removePropertyChangeListener(String prop, PropertyChangeListener l) {
        this.support.removePropertyChangeListener(prop, l);
    }

    @Override
    public void setZoomFactorCenter(double value) {
        double oldValue = this.zoomFactor;
        if (value != oldValue) {
            this.zoomFactor = value;
            this.support.firePropertyChange("zoom", oldValue, value);
            SwingUtilities.invokeLater(() -> this.support.firePropertyChange("center", oldValue, value));
        }
    }
}

