/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.prefs;

import com.cburch.logisim.fpga.Strings;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.gui.prefs.ColorChooserButton;
import com.cburch.logisim.gui.prefs.OptionsPanel;
import com.cburch.logisim.gui.prefs.PrefOption;
import com.cburch.logisim.gui.prefs.PrefOptionList;
import com.cburch.logisim.gui.prefs.PreferencesFrame;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.prefs.PrefMonitorBoolean;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FpgaOptions
extends OptionsPanel {
    private final MyListener myListener = new MyListener();
    private final JLabel WorkspaceLabel = new JLabel();
    private final JTextField WorkSpacePath;
    private final JButton WorkSpaceButton;
    private final JLabel EditSelectLabel = new JLabel();
    private ColorChooserButton EditSelectColor;
    private final JLabel EditHighligtLabel = new JLabel();
    private ColorChooserButton EditHighligtColor;
    private final JLabel EditMoveLabel = new JLabel();
    private ColorChooserButton EditMoveColor;
    private final JLabel EditResizeLabel = new JLabel();
    private ColorChooserButton EditResizeColor;
    private final JLabel MappedLabel = new JLabel();
    private ColorChooserButton MappedColor;
    private final JLabel SelMapLabel = new JLabel();
    private ColorChooserButton SelMapColor;
    private final JLabel SelectMapLabel = new JLabel();
    private ColorChooserButton SelectMapColor;
    private final JLabel SelectLabel = new JLabel();
    private ColorChooserButton SelectColor;
    private JPanel editPan;
    private JPanel mapPan;
    private JPanel ReportPan;
    private JPanel vhdlPan;
    private JCheckBox SupressGated;
    private JCheckBox SupressOpen;
    private JCheckBox vhdlKeywordUpperCase;
    private final PreferencesFrame frame;
    private final PrefOptionList HDL_Used;

    public FpgaOptions(PreferencesFrame frame) {
        super(frame);
        this.frame = frame;
        AppPreferences.getPrefs().addPreferenceChangeListener(this.myListener);
        this.WorkSpacePath = new JTextField(32);
        this.WorkSpacePath.setText(AppPreferences.FPGA_Workspace.get());
        this.WorkSpacePath.setEditable(false);
        this.WorkSpaceButton = new JButton();
        this.WorkSpaceButton.addActionListener(this.myListener);
        this.HDL_Used = new PrefOptionList(AppPreferences.HdlType, Strings.S.getter("HDLLanguageUsed"), new PrefOption[]{new PrefOption("VHDL", Strings.S.getter("VHDL")), new PrefOption("Verilog", Strings.S.getter("Verilog"))});
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(layout);
        gbc.insets = new Insets(2, 4, 4, 2);
        gbc.anchor = 512;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        this.add((Component)this.WorkspaceLabel, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.add((Component)this.WorkSpaceButton, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        this.add((Component)this.WorkSpacePath, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        this.add((Component)this.HDL_Used.getJLabel(), gbc);
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        this.add(this.HDL_Used.getJComboBox(), gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        this.add((Component)this.getVhdlOptions(), gbc);
        ++gbc.gridy;
        this.add((Component)AppPreferences.Boards.addRemovePanel(), gbc);
        ++gbc.gridy;
        this.add((Component)this.getReporterOptions(), gbc);
        ++gbc.gridy;
        this.add((Component)this.getEditCols(), gbc);
        ++gbc.gridy;
        this.add((Component)this.getMapCols(), gbc);
        this.localeChanged();
    }

    private JPanel getVhdlOptions() {
        boolean isVhdl = AppPreferences.HdlType.get().equals("VHDL");
        this.vhdlPan = new JPanel();
        this.vhdlPan.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.vhdlKeywordUpperCase = ((PrefMonitorBoolean)AppPreferences.VhdlKeywordsUpperCase).getCheckBox();
        this.vhdlPan.add((Component)this.vhdlKeywordUpperCase, gbc);
        this.vhdlPan.setEnabled(isVhdl);
        this.vhdlKeywordUpperCase.setEnabled(isVhdl);
        return this.vhdlPan;
    }

    private JPanel getReporterOptions() {
        this.ReportPan = new JPanel();
        this.ReportPan.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.SupressGated = ((PrefMonitorBoolean)AppPreferences.SupressGatedClockWarnings).getCheckBox();
        this.ReportPan.add((Component)this.SupressGated, gbc);
        ++gbc.gridy;
        this.SupressOpen = ((PrefMonitorBoolean)AppPreferences.SupressOpenPinWarnings).getCheckBox();
        this.ReportPan.add((Component)this.SupressOpen, gbc);
        return this.ReportPan;
    }

    private JPanel getEditCols() {
        this.editPan = new JPanel();
        this.editPan.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.editPan.add((Component)this.EditSelectLabel, gbc);
        ++gbc.gridx;
        this.EditSelectColor = new ColorChooserButton(this.frame, AppPreferences.FPGA_DEFINE_COLOR);
        this.editPan.add((Component)this.EditSelectColor, gbc);
        ++gbc.gridx;
        this.editPan.add((Component)this.EditHighligtLabel, gbc);
        this.EditHighligtColor = new ColorChooserButton(this.frame, AppPreferences.FPGA_DEFINE_HIGHLIGHT_COLOR);
        ++gbc.gridx;
        this.editPan.add((Component)this.EditHighligtColor, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.editPan.add((Component)this.EditMoveLabel, gbc);
        this.EditMoveColor = new ColorChooserButton(this.frame, AppPreferences.FPGA_DEFINE_MOVE_COLOR);
        ++gbc.gridx;
        this.editPan.add((Component)this.EditMoveColor, gbc);
        ++gbc.gridx;
        this.editPan.add((Component)this.EditResizeLabel, gbc);
        this.EditResizeColor = new ColorChooserButton(this.frame, AppPreferences.FPGA_DEFINE_RESIZE_COLOR);
        ++gbc.gridx;
        this.editPan.add((Component)this.EditResizeColor, gbc);
        return this.editPan;
    }

    private JPanel getMapCols() {
        this.mapPan = new JPanel();
        this.mapPan.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.mapPan.add(this.MappedLabel);
        ++gbc.gridx;
        this.MappedColor = new ColorChooserButton(this.frame, AppPreferences.FPGA_MAPPED_COLOR);
        this.mapPan.add(this.MappedColor);
        ++gbc.gridx;
        this.mapPan.add(this.SelMapLabel);
        ++gbc.gridx;
        this.SelMapColor = new ColorChooserButton(this.frame, AppPreferences.FPGA_SELECTED_MAPPED_COLOR);
        this.mapPan.add(this.SelMapColor);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.mapPan.add((Component)this.SelectMapLabel, gbc);
        ++gbc.gridx;
        this.SelectMapColor = new ColorChooserButton(this.frame, AppPreferences.FPGA_SELECTABLE_MAPPED_COLOR);
        this.mapPan.add((Component)this.SelectMapColor, gbc);
        ++gbc.gridx;
        this.mapPan.add((Component)this.SelectLabel, gbc);
        ++gbc.gridx;
        this.SelectColor = new ColorChooserButton(this.frame, AppPreferences.FPGA_SELECT_COLOR);
        this.mapPan.add((Component)this.SelectColor, gbc);
        return this.mapPan;
    }

    @Override
    public String getHelpText() {
        return Strings.S.get("FPGAHelp");
    }

    @Override
    public String getTitle() {
        return Strings.S.get("FPGATitle");
    }

    @Override
    public void localeChanged() {
        this.WorkspaceLabel.setText(Strings.S.get("FPGAWorkSpace"));
        this.WorkSpaceButton.setText(Strings.S.get("Browse"));
        this.EditSelectLabel.setText(Strings.S.get("EditColSel"));
        this.EditHighligtLabel.setText(Strings.S.get("EditColHighlight"));
        this.EditMoveLabel.setText(Strings.S.get("EditColMove"));
        this.EditResizeLabel.setText(Strings.S.get("EditColResize"));
        this.MappedLabel.setText(Strings.S.get("MapColor"));
        this.SelMapLabel.setText(Strings.S.get("SelMapCol"));
        this.SelectMapLabel.setText(Strings.S.get("SelectMapCol"));
        this.SelectLabel.setText(Strings.S.get("SelectCol"));
        this.SupressGated.setText(Strings.S.get("SupressGatedClock"));
        this.SupressOpen.setText(Strings.S.get("SupressOpenInput"));
        this.vhdlKeywordUpperCase.setText(Strings.S.get("VhdlKeywordUpperCase"));
        this.editPan.setBorder(BorderFactory.createTitledBorder(Strings.S.get("EditColors")));
        this.mapPan.setBorder(BorderFactory.createTitledBorder(Strings.S.get("MapColors")));
        this.ReportPan.setBorder(BorderFactory.createTitledBorder(Strings.S.get("ReporterOptions")));
        this.vhdlPan.setBorder(BorderFactory.createTitledBorder(Strings.S.get("VhdlOptions")));
        this.HDL_Used.getJLabel().setText(Strings.S.get("HDLLanguageUsed"));
        AppPreferences.Boards.localeChanged();
    }

    private void selectWorkSpace(Component parentComponent) {
        JFileChooser fc = new JFileChooser(AppPreferences.FPGA_Workspace.get());
        fc.setFileSelectionMode(1);
        File test = new File(AppPreferences.FPGA_Workspace.get());
        if (test.exists()) {
            fc.setSelectedFile(test);
        }
        fc.setDialogTitle(Strings.S.get("FpgaGuiWorkspacePath"));
        boolean ValidWorkpath = false;
        while (!ValidWorkpath) {
            int retval = fc.showOpenDialog(null);
            if (retval != 0) {
                return;
            }
            if (fc.getSelectedFile().getAbsolutePath().contains(" ")) {
                OptionPane.showMessageDialog(parentComponent, Strings.S.get("FpgaGuiWorkspaceError"), Strings.S.get("FpgaGuiWorkspacePath"), 0);
                continue;
            }
            ValidWorkpath = true;
        }
        File file = fc.getSelectedFile();
        if (file.getPath().endsWith(File.separator)) {
            AppPreferences.FPGA_Workspace.set(file.getPath());
        } else {
            AppPreferences.FPGA_Workspace.set(file.getPath() + File.separator);
        }
    }

    private class MyListener
    implements ActionListener,
    PreferenceChangeListener {
        private MyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object source = ae.getSource();
            if (source == FpgaOptions.this.WorkSpaceButton) {
                FpgaOptions.this.selectWorkSpace(FpgaOptions.this.frame);
            }
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent pce) {
            String property = pce.getKey();
            if (property.equals(AppPreferences.FPGA_Workspace.getIdentifier())) {
                FpgaOptions.this.WorkSpacePath.setText(AppPreferences.FPGA_Workspace.get());
            } else if (property.equals(AppPreferences.HdlType.getIdentifier())) {
                boolean isVhdl = AppPreferences.HdlType.get().equals("VHDL");
                FpgaOptions.this.vhdlPan.setEnabled(isVhdl);
                FpgaOptions.this.vhdlKeywordUpperCase.setEnabled(isVhdl);
            }
        }
    }
}

