/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.hdlgenerator;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.file.FileWriter;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.fpga.hdlgenerator.SynthesizedClockHdlGeneratorFactory;
import com.cburch.logisim.util.LineBuffer;
import java.util.List;

public class XilinxSeries7SynthesizedClockHdlGeneratorFactory
extends SynthesizedClockHdlGeneratorFactory {
    private final long fpgaClockFrequency;
    private double preMultiplier;
    private double preDivider;
    private final double mmcmPeriodNs;

    public XilinxSeries7SynthesizedClockHdlGeneratorFactory(long fpga_clock_frequency, double preMultiplier, double preDivider) throws Exception {
        this.fpgaClockFrequency = fpga_clock_frequency;
        this.preDivider = preDivider;
        this.preMultiplier = preMultiplier;
        if (fpga_clock_frequency < 10000000L) {
            throw new Exception("MMCM requires external FPGA clock of 10MHz or greater.");
        }
        this.mmcmPeriodNs = (double)Math.round(1.0E12 / (double)this.fpgaClockFrequency) / 1000.0;
        this.myWires.addWire("s_synthesizedClock", 1).addWire("s_unbufferedSynthClk", 1).addWire("s_clkfbout", 1).addWire("s_bufferedFPGAClock", 1);
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist TheNetlist, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getHdlBuffer().pair("synthesizedClock", "s_synthesizedClock").pair("preDivider", String.valueOf(this.preDivider)).pair("preMultiplier", String.valueOf(this.preMultiplier)).pair("clkInPeriodNs", String.valueOf(this.mmcmPeriodNs)).add("").addRemarkBlock("Here the output is defined.").add("{{assign}} SynthesizedClock {{=}} {{synthesizedClock}};").add("").addRemarkBlock("Here the update logic is defined.");
        if (Hdl.isVhdl()) {
            contents.addVhdlKeywords().add("  clkbuf: BUFG port map (I=>s_unbufferedSynthClk, O=>{{synthesizedClock}});\n  iclkbuf: BUFG port map (I=>FPGAClock, O=>s_bufferedFPGAClock);\n\n  clock: MMCM_BASE generic map (\n    clkin1_period  => {{clkInPeriodNs}},\n    clkfbout_mult_f => {{preMultiplier}},\n    clkout0_divide_f => {{preDivider}}\n  )\n  port map(\n      rst      => '0',\n      pwrdwn   => '0',\n      clkin1   => s_bufferedFPGAClock,\n      clkfbin  => s_clkfbout,\n      clkfbout => s_clkfbout,\n      clkout0  => s_unbufferedSynthClk\n  );\n").empty();
        } else {
            contents.add("  BUFG clkbuf (.I(s_unbufferedSynthClk), .O({{synthesizedClock}}));\n  BUFG iclkbuf (.I(FPGAClock), .O(s_bufferedFPGAClock));\n\n  MMCME2_BASE #(\n    .CLKIN1_PERIOD({{clkInPeriodNs}}),\n    .CLKFBOUT_MULT_F({{preMultiplier}}),\n    .CLKOUT0_DIVIDE_F({{preDivider}})\n  ) clock (\n    .RST(1'b0),\n    .PWRDWN(1'b0),\n    .CLKIN1(s_bufferedFPGAClock),\n    .CLKFBIN(s_clkfbout),\n    .CLKFBOUT(s_clkfbout),\n    .CLKOUT0(s_unbufferedSynthClk),\n    .CLKOUT0B(),\n    .CLKOUT1(),\n    .CLKOUT1B(),\n    .CLKOUT2(),\n    .CLKOUT2B(),\n    .CLKOUT3(),\n    .CLKOUT3B(),\n    .CLKOUT4(),\n    .CLKOUT5(),\n    .CLKOUT6(),\n    .CLKFBOUTB(),\n    .LOCKED()\n  );\n").empty();
        }
        return contents;
    }

    public static List<String> getUnisimLibrary() {
        LineBuffer lines = LineBuffer.getBuffer();
        lines.addVhdlKeywords().add("\n  {{library}} unisim;\n  {{use}} unisim.vcomponents.all;\n\n");
        return lines.get();
    }

    @Override
    public List<String> getEntity(Netlist theNetlist, AttributeSet attrs, String componentName) {
        LineBuffer contents = LineBuffer.getHdlBuffer();
        if (Hdl.isVhdl()) {
            contents.add(FileWriter.getGenerateRemark(componentName, theNetlist.projName())).add(Hdl.getExtendedLibrary()).add(XilinxSeries7SynthesizedClockHdlGeneratorFactory.getUnisimLibrary()).add(this.getVHDLBlackBox(theNetlist, attrs, componentName, true));
        }
        return contents.get();
    }
}

