/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.hdlgenerator;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import java.util.ArrayList;
import java.util.List;

public class HdlPorts {
    public static final String CLOCK = "clock";
    public static final String TICK = "tick";
    public static final String PULL_DOWN = "fixed_pull_down";
    public static final String PULL_UP = "fixed_pull_up";
    private final List<PortInfo> myPorts = new ArrayList<PortInfo>();

    public HdlPorts add(String type, String name, int nrOfBits, String fixedMap) {
        String realType = CLOCK.equals(type) ? "input" : type;
        PortInfo newPort = new PortInfo(realType, name, nrOfBits, fixedMap);
        newPort.isClock = CLOCK.equals(type);
        this.myPorts.add(newPort);
        return this;
    }

    public HdlPorts add(String type, String name, int nrOfBits, int compPinId) {
        String realType = CLOCK.equals(type) ? "input" : type;
        PortInfo newPort = new PortInfo(realType, name, nrOfBits, compPinId);
        newPort.isClock = CLOCK.equals(type);
        this.myPorts.add(newPort);
        return this;
    }

    public HdlPorts add(String type, String name, int nrOfBits, int compPinId, boolean pullToZero) {
        String realType = CLOCK.equals(type) ? "input" : type;
        PortInfo newPort = new PortInfo(realType, name, nrOfBits, compPinId, pullToZero);
        newPort.isClock = CLOCK.equals(type);
        this.myPorts.add(newPort);
        return this;
    }

    public HdlPorts add(String type, String name, int nrOfBits, int compPinId, Attribute<?> nrOfBitsAttr) {
        String realType = CLOCK.equals(type) ? "input" : type;
        PortInfo newPort = new PortInfo(realType, name, nrOfBits, compPinId, nrOfBitsAttr);
        newPort.isClock = CLOCK.equals(type);
        this.myPorts.add(newPort);
        return this;
    }

    public boolean isEmpty() {
        return this.myPorts.isEmpty();
    }

    public ArrayList<String> keySet() {
        return this.keySet(null);
    }

    public ArrayList<String> keySet(String type) {
        ArrayList<String> keySet = new ArrayList<String>();
        for (PortInfo port : this.myPorts) {
            if (type != null && !port.myPortType.equals(type)) continue;
            keySet.add(port.myName);
        }
        return keySet;
    }

    public int get(String name, AttributeSet attrs) {
        for (PortInfo port : this.myPorts) {
            if (!port.myName.equals(name)) continue;
            return port.getNrOfBits(attrs);
        }
        throw new ArrayStoreException("port not contained in structure");
    }

    public boolean isFixedMapped(String name) {
        for (PortInfo port : this.myPorts) {
            if (!port.myName.equals(name)) continue;
            return port.myComponentPinId < 0;
        }
        throw new ArrayStoreException("port not contained in structure");
    }

    public String getFixedMap(String name) {
        if (this.isFixedMapped(name)) {
            for (PortInfo port : this.myPorts) {
                if (!port.myName.equals(name)) continue;
                return port.myFixedMap;
            }
        }
        throw new ArrayStoreException("port not contained in structure or not fixed mapped");
    }

    public int getComponentPortId(String name) {
        for (PortInfo port : this.myPorts) {
            if (!port.myName.equals(name)) continue;
            return port.myComponentPinId;
        }
        throw new ArrayStoreException("port not contained in structure");
    }

    public void removePorts() {
        this.myPorts.clear();
    }

    public boolean doPullDownOnFloat(String name) {
        for (PortInfo port : this.myPorts) {
            if (!port.myName.equals(name)) continue;
            return port.myPullToZero;
        }
        throw new ArrayStoreException("port not contained in structure");
    }

    public boolean contains(String name) {
        for (PortInfo port : this.myPorts) {
            if (!port.myName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isClock(String name) {
        for (PortInfo port : this.myPorts) {
            if (!port.myName.equals(name)) continue;
            return port.isClock;
        }
        throw new ArrayStoreException("port not contained in structure");
    }

    public String getTickName(String name) {
        for (PortInfo port : this.myPorts) {
            if (!port.myName.equals(name)) continue;
            return HdlPorts.getTickName(port.myNrOfBits);
        }
        throw new ArrayStoreException("port not contained in structure");
    }

    public static String getTickName(int id) {
        return id == 1 ? TICK : String.format("%s%d", TICK, id);
    }

    public static String getClockName(int id) {
        return id == 1 ? CLOCK : String.format("%s%d", CLOCK, id);
    }

    private static class PortInfo {
        private final String myPortType;
        private final String myName;
        private final int myNrOfBits;
        private final int myComponentPinId;
        private final String myFixedMap;
        private boolean mySinglePinException = false;
        private Attribute<?> myBitWidthAttribute = null;
        private boolean myPullToZero = true;
        private boolean isClock = false;

        public PortInfo(String type, String name, int nrOfBits, String fixedMap) {
            this.myPortType = type;
            this.myName = name;
            this.myNrOfBits = nrOfBits;
            this.myComponentPinId = -1;
            this.myFixedMap = fixedMap;
        }

        public PortInfo(String type, String name, int nrOfBits, int compPinId) {
            this(type, name, nrOfBits, compPinId, null);
            this.mySinglePinException = false;
        }

        public PortInfo(String type, String name, int nrOfBits, int compPinId, boolean pullToZero) {
            this(type, name, nrOfBits, compPinId, null);
            this.mySinglePinException = false;
            this.myPullToZero = pullToZero;
        }

        public PortInfo(String type, String name, int nrOfBits, int compPinId, Attribute<?> nrOfBitsAttr) {
            this.myPortType = type;
            this.myName = name;
            this.myNrOfBits = nrOfBits;
            this.myComponentPinId = compPinId;
            this.myFixedMap = null;
            this.mySinglePinException = true;
            this.myBitWidthAttribute = nrOfBitsAttr;
        }

        int getNrOfBits(AttributeSet attrs) {
            if (this.mySinglePinException) {
                if (!attrs.containsAttribute(this.myBitWidthAttribute)) {
                    throw new IllegalArgumentException("Bitwidth attribute not found");
                }
                Object value = attrs.getValue(this.myBitWidthAttribute);
                int nrOfBits = 0;
                if (value instanceof BitWidth) {
                    nrOfBits = ((BitWidth)value).getWidth();
                } else if (value instanceof Integer) {
                    nrOfBits = (Integer)value;
                } else {
                    throw new IllegalArgumentException("Attribute is not of type Bitwidth or Integer");
                }
                return nrOfBits == 1 ? 1 : (this.myNrOfBits != 0 ? this.myNrOfBits : nrOfBits);
            }
            return this.myNrOfBits;
        }
    }
}

