/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.gui;

import com.cburch.logisim.fpga.Strings;
import com.cburch.logisim.util.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class HdlColorRenderer
extends JLabel
implements TableCellRenderer {
    public static final String NO_SUPPORT_STRING = "HDL_NOT_SUPPORTED";
    public static final String SUPPORT_STRING = "HDL_SUPPORTED";
    public static final String UNKNOWN_STRING = "HDL_UNKNOWN";
    public static final String REQUIRED_FIELD_STRING = ">_HDL_REQUIRED_FIELD_<";
    protected static final int LABEL = 0;
    protected static final int VALUE = 1;
    protected static final ArrayList<String> CorrectStrings = new ArrayList();

    public HdlColorRenderer() {
        this.setOpaque(true);
        CorrectStrings.clear();
        CorrectStrings.add(NO_SUPPORT_STRING);
        CorrectStrings.add(UNKNOWN_STRING);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object infoObj, boolean isSelected, boolean hasFocus, int rowIdx, int columnIdx) {
        String value = infoObj != null ? (String)infoObj : "???";
        this.setBackground(UIManager.getColor("Table.background"));
        this.setForeground(UIManager.getColor("Table.foreground"));
        if (rowIdx == 0) {
            return this.renderFpgaSupportRow(columnIdx, value);
        }
        if (value.equals(REQUIRED_FIELD_STRING)) {
            this.setCellColors(Color.ORANGE);
            this.setHorizontalAlignment(0);
            this.setText(Strings.S.get("FPGAHdlRequired"));
        } else if ((value.length() == 7 || value.length() == 9) && value.indexOf(35) == 0) {
            Integer red = Integer.valueOf(value.substring(1, 3), 16);
            Integer green = Integer.valueOf(value.substring(3, 5), 16);
            Integer blue = Integer.valueOf(value.substring(5, 7), 16);
            int alpha = value.length() == 7 ? 255 : Integer.valueOf(value.substring(7, 9), 16);
            Color bgColor = new Color(red, green, blue, alpha);
            this.setCellColors(bgColor);
            this.setText(value.toUpperCase());
            this.setHorizontalAlignment(0);
        } else {
            if (isSelected) {
                this.setForeground(UIManager.getColor("Table.selectionForeground"));
                this.setBackground(UIManager.getColor("Table.selectionBackground"));
            }
            this.setText(value);
            this.setHorizontalAlignment(2);
        }
        this.setBorder(null);
        return this;
    }

    protected Component renderFpgaSupportRow(int columnIdx, String value) {
        String labelKey;
        if (columnIdx == 0) {
            this.setText(value);
            this.setHorizontalAlignment(2);
            return this;
        }
        Color bg = UIManager.getColor("Table.background");
        if (!value.equals(UNKNOWN_STRING)) {
            if (value.equals(NO_SUPPORT_STRING)) {
                bg = Color.RED;
                labelKey = "FPGANotSupported";
            } else {
                bg = Color.GREEN;
                labelKey = "FPGASupported";
            }
        } else {
            labelKey = "FPGAUnknown";
        }
        this.setText(Strings.S.get(labelKey));
        this.setCellColors(bg);
        this.setHorizontalAlignment(0);
        return this;
    }

    protected void setCellColors(Color bgColor) {
        this.setBackground(bgColor);
        this.setForeground(ColorUtil.getComplementaryBlackWhite(bgColor));
    }
}

