/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.file;

import com.cburch.logisim.fpga.Strings;
import com.cburch.logisim.fpga.gui.Reporter;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;

public class FileWriter {
    public static final String ENTITY_EXTENSION = "_entity";
    public static final String ARCHITECTURE_EXTENSION = "_behavior";

    public static File getFilePointer(String targetDirectory, String componentName, boolean isEntity) {
        StringBuilder fileName = new StringBuilder();
        try {
            File outDir = new File(targetDirectory);
            if (!outDir.exists() && !outDir.mkdirs()) {
                return null;
            }
            fileName.append(targetDirectory);
            if (!targetDirectory.endsWith(File.separator)) {
                fileName.append(File.separator);
            }
            fileName.append(componentName);
            if (isEntity && Hdl.isVhdl()) {
                fileName.append(ENTITY_EXTENSION);
            }
            if (!isEntity && Hdl.isVhdl()) {
                fileName.append(ARCHITECTURE_EXTENSION);
            }
            fileName.append(Hdl.isVhdl() ? ".vhd" : ".v");
            File outFile = new File(fileName.toString());
            Reporter.report.addInfo(Strings.S.fmt("fileCreateHDLFile", fileName.toString()));
            if (outFile.exists()) {
                Reporter.report.addWarning(Strings.S.fmt("fileHDLFileExists", fileName.toString()));
                return null;
            }
            return outFile;
        }
        catch (Exception e) {
            Reporter.report.addFatalError(Strings.S.fmt("fileUnableToCreate", fileName.toString()));
            return null;
        }
    }

    public static File getFilePointer(String targetDirectory, String name) {
        StringBuilder fileName = new StringBuilder();
        try {
            File outDir = new File(targetDirectory);
            if (!outDir.exists() && !outDir.mkdirs()) {
                return null;
            }
            fileName.append(targetDirectory);
            if (!targetDirectory.endsWith(File.separator)) {
                fileName.append(File.separator);
            }
            fileName.append(name);
            File outFile = new File(fileName.toString());
            Reporter.report.addInfo(Strings.S.fmt("fileCreateScriptFile", fileName.toString()));
            if (outFile.exists()) {
                Reporter.report.addWarning(Strings.S.fmt("fileScriptFileExists", fileName.toString()));
                return null;
            }
            return outFile;
        }
        catch (Exception e) {
            Reporter.report.addFatalError(Strings.S.fmt("fileUnableToCreate", fileName.toString()));
            return null;
        }
    }

    public static List<String> getGenerateRemark(String compName, String projName) {
        ArrayList<String> lines = new ArrayList<String>();
        String headText = " Logisim-evolution goes FPGA automatic generated " + (Hdl.isVhdl() ? "VHDL" : "Verilog") + " code";
        String headUrl = " https://github.com/logisim-evolution/";
        String headProj = " Project   : " + projName;
        String headComp = " Component : " + compName;
        if (Hdl.isVhdl()) {
            int headWidth = 74;
            String headOpen = "--==";
            String headClose = "==";
            lines.add(headOpen + "=".repeat(headWidth) + headClose);
            lines.add(headOpen + headText + " ".repeat(Math.max(0, headWidth - headText.length())) + headClose);
            lines.add(headOpen + " https://github.com/logisim-evolution/" + " ".repeat(Math.max(0, headWidth - " https://github.com/logisim-evolution/".length())) + headClose);
            lines.add(headOpen + " ".repeat(headWidth) + headClose);
            lines.add(headOpen + " ".repeat(headWidth) + headClose);
            lines.add(headOpen + headProj + " ".repeat(Math.max(0, headWidth - headProj.length())) + headClose);
            lines.add(headOpen + headComp + " ".repeat(Math.max(0, headWidth - headComp.length())) + headClose);
            lines.add(headOpen + " ".repeat(headWidth) + headClose);
            lines.add(headOpen + "=".repeat(headWidth) + headClose);
            lines.add("");
        } else if (Hdl.isVerilog()) {
            int headWidth = 74;
            String headOpen = " **";
            String headClose = "**";
            lines.add("/**" + "*".repeat(headWidth) + headClose);
            lines.add(headOpen + headText + " ".repeat(Math.max(0, headWidth - headText.length())) + headClose);
            lines.add(headOpen + " https://github.com/logisim-evolution/" + " ".repeat(Math.max(0, headWidth - " https://github.com/logisim-evolution/".length())) + headClose);
            lines.add(headOpen + " ".repeat(headWidth) + headClose);
            lines.add(headOpen + headComp + " ".repeat(Math.max(0, headWidth - headComp.length())) + headClose);
            lines.add(headOpen + " ".repeat(headWidth) + headClose);
            lines.add(headOpen + "*".repeat(headWidth) + "*/");
            lines.add("");
        }
        return lines;
    }

    public static boolean writeContents(File outfile, List<String> contents) {
        try {
            FileOutputStream output = new FileOutputStream(outfile);
            for (String thisLine : contents) {
                if (!thisLine.isEmpty()) {
                    output.write(thisLine.getBytes());
                }
                output.write("\n".getBytes());
            }
            output.flush();
            output.close();
            return true;
        }
        catch (Exception e) {
            Reporter.report.addFatalError(Strings.S.fmt("fileUnableToWrite", outfile.getAbsolutePath()));
            return false;
        }
    }
}

