/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.download;

import com.cburch.logisim.fpga.Strings;
import com.cburch.logisim.fpga.data.BoardInformation;
import com.cburch.logisim.fpga.data.DriveStrength;
import com.cburch.logisim.fpga.data.FpgaIoInformationContainer;
import com.cburch.logisim.fpga.data.IoStandards;
import com.cburch.logisim.fpga.data.MapComponent;
import com.cburch.logisim.fpga.data.MappableResourcesContainer;
import com.cburch.logisim.fpga.data.PullBehaviors;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.download.Download;
import com.cburch.logisim.fpga.download.DownloadBase;
import com.cburch.logisim.fpga.download.VendorDownload;
import com.cburch.logisim.fpga.file.FileWriter;
import com.cburch.logisim.fpga.settings.VendorSoftware;
import com.cburch.logisim.util.LineBuffer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OpenFpgaDownload
implements VendorDownload {
    private final VendorSoftware openfpgaVendor = VendorSoftware.getSoftware('\u0003');
    private final String scriptPath;
    private final String projectPath;
    private final String sandboxPath;
    private final Netlist rootNetList;
    private MappableResourcesContainer mapInfo;
    private final BoardInformation boardInfo;
    private final List<String> entities;
    private final List<String> architectures;
    private final String HdlType;
    private final boolean writeToFlash;
    private final String YOSYS_SCRIPT_FILE = "yosys.script";
    private final String JSON_FILE = "toplevel.json";
    private final String PIN_CONSTRAINT_FILE = "toplevel.lpf";
    private final String NEXT_NPR_RESULT = "toplevel.config";
    private final String BIT_FILE = "toplevel.bit";

    public OpenFpgaDownload(String projectPath, Netlist rootNetList, BoardInformation boardInfo, List<String> entities, List<String> architectures, String hdlType, boolean writeToFlash) {
        this.projectPath = projectPath;
        this.sandboxPath = DownloadBase.getDirectoryLocation(projectPath, DownloadBase.SANDBOX_PATH);
        this.scriptPath = DownloadBase.getDirectoryLocation(projectPath, DownloadBase.SCRIPT_PATH);
        this.rootNetList = rootNetList;
        this.boardInfo = boardInfo;
        this.entities = entities;
        this.architectures = architectures;
        this.HdlType = hdlType;
        this.writeToFlash = writeToFlash;
    }

    @Override
    public int getNumberOfStages() {
        return this.HdlType.equals("VHDL") ? 4 : 3;
    }

    @Override
    public String getStageMessage(int stage) {
        if (this.HdlType.equals("VHDL")) {
            return switch (stage) {
                case 0 -> Strings.S.get("OpenFpgaGhdl");
                case 1 -> Strings.S.get("OpenFpgaYosys");
                case 2 -> Strings.S.get("OpenFpganNextpnr");
                case 3 -> Strings.S.get("OpenFpganEcppack");
                default -> "unknown";
            };
        }
        return switch (stage) {
            case 0 -> Strings.S.get("OpenFpgaYosys");
            case 1 -> Strings.S.get("OpenFpganNextpnr");
            case 2 -> Strings.S.get("OpenFpganEcppack");
            default -> "unknown";
        };
    }

    @Override
    public ProcessBuilder performStep(int stage) {
        if (this.HdlType.equals("VHDL")) {
            return switch (stage) {
                case 0 -> this.stageGhdl();
                case 1 -> this.stageYosys();
                case 2 -> this.stageNextpnrEcp5();
                case 3 -> this.stageEcppack();
                default -> null;
            };
        }
        return switch (stage) {
            case 0 -> this.stageYosys();
            case 1 -> this.stageNextpnrEcp5();
            case 2 -> this.stageEcppack();
            default -> null;
        };
    }

    @Override
    public boolean readyForDownload() {
        return new File(this.sandboxPath + "toplevel.bit").exists();
    }

    @Override
    public ProcessBuilder downloadToBoard() {
        LineBuffer command = LineBuffer.getBuffer();
        command.add(this.openfpgaVendor.getBinaryPath(4));
        if (this.writeToFlash) {
            command.add("-f");
        }
        command.add("toplevel.bit");
        ProcessBuilder stage = new ProcessBuilder(command.get());
        stage.directory(new File(this.sandboxPath));
        return stage;
    }

    @Override
    public boolean createDownloadScripts() {
        File yosysScript = FileWriter.getFilePointer(this.scriptPath, "yosys.script");
        File constraintFile = FileWriter.getFilePointer(this.scriptPath, "toplevel.lpf");
        if (yosysScript == null || constraintFile == null) {
            yosysScript = new File(this.scriptPath + "yosys.script");
            constraintFile = new File(this.scriptPath + "toplevel.lpf");
            return yosysScript.exists() && constraintFile.exists();
        }
        LineBuffer content = LineBuffer.getBuffer();
        if (this.HdlType.equals("VHDL")) {
            content.add("ghdl {{1}}", "logisimTopLevelShell").add("synth_ecp5 -json {{1}}", "toplevel.json");
        } else {
            for (String vfile : this.entities) {
                content.add("read -sv {{1}}", vfile);
            }
            content.add("hierarchy -top {{1}}", "logisimTopLevelShell").add("synth_ecp5 -json {{1}}", "toplevel.json");
        }
        if (!FileWriter.writeContents(yosysScript, content.get())) {
            return false;
        }
        content.clear();
        content.add("BLOCK RESETPATHS;").add("BLOCK ASYNCPATHS;\n");
        if (this.rootNetList.numberOfClockTrees() > 0 || this.rootNetList.requiresGlobalClockConnection()) {
            content.add("LOCATE COMP \"{{1}}\" SITE \"{{2}}\";", "fpgaGlobalClock", this.boardInfo.fpga.getClockPinLocation()).add("FREQUENCY PORT \"{{1}}\" {{2}};", "fpgaGlobalClock", Download.getClockFrequencyString(this.boardInfo).toUpperCase());
        }
        content.add(this.getPinLocations());
        return FileWriter.writeContents(constraintFile, content.get());
    }

    @Override
    public void setMapableResources(MappableResourcesContainer resources) {
        this.mapInfo = resources;
    }

    @Override
    public boolean isBoardConnected() {
        return true;
    }

    private List<String> getPinLocations() {
        LineBuffer pinInfo = LineBuffer.getBuffer();
        for (ArrayList<String> key : this.mapInfo.getMappableResources().keySet()) {
            MapComponent map = this.mapInfo.getMappableResources().get(key);
            for (int pin = 0; pin < map.getNrOfPins(); ++pin) {
                String drive;
                if (!map.isMapped(pin) || map.isOpenMapped(pin) || map.isConstantMapped(pin) || map.isInternalMapped(pin)) continue;
                pinInfo.add("LOCATE COMP \"{{1}}{{2}}\" SITE \"{{3}}\";", map.isExternalInverted(pin) ? "n_" : "", map.getHdlString(pin), map.getPinLocation(pin).toUpperCase());
                FpgaIoInformationContainer info = map.getFpgaInfo(pin);
                if (info == null) continue;
                String pullString = PullBehaviors.getPullString(info.getPullBehavior());
                String pull = pullString == null ? " PULLMODE=NONE" : LineBuffer.format(" PULLMODE={{1}}", pullString.toUpperCase());
                String ioTypeString = IoStandards.getIoString(info.getIoStandard());
                String ioType = ioTypeString == null ? "" : LineBuffer.format(" IO_TYPE={{1}}", ioTypeString.toUpperCase());
                String driveString = DriveStrength.getDriveString(info.getDrive());
                String string = drive = driveString == null ? "" : LineBuffer.format(" DRIVE={{1}}", driveString);
                if (pullString == null && ioTypeString == null && driveString == null) continue;
                pinInfo.add("IOBUF PORT \"{{1}}{{2}}\"{{3}}{{4}}{{5}};", map.isExternalInverted(pin) ? "n_" : "", map.getHdlString(pin), pull, ioType, drive);
            }
        }
        Map<String, String> LedArrayMap = DownloadBase.getScanningMaps(this.mapInfo, this.rootNetList, this.boardInfo);
        for (String key : LedArrayMap.keySet()) {
            pinInfo.add("LOCATE COMP \"{{1}}\" SITE \"{{2}}\";", key, LedArrayMap.get(key));
        }
        return pinInfo.get();
    }

    private ProcessBuilder stageGhdl() {
        LineBuffer command = LineBuffer.getBuffer();
        command.add(this.openfpgaVendor.getBinaryPath(0)).add("-a");
        for (String entity : this.entities) {
            command.add(entity);
        }
        for (String archi : this.architectures) {
            command.add(archi);
        }
        ProcessBuilder stage = new ProcessBuilder(command.get());
        stage.directory(new File(this.sandboxPath));
        return stage;
    }

    private ProcessBuilder stageYosys() {
        LineBuffer command = LineBuffer.getBuffer();
        if (this.HdlType.equals("VHDL")) {
            command.add(this.openfpgaVendor.getBinaryPath(1)).add("-m").add("ghdl.so").add("-s").add("{{1}}{{2}}", this.scriptPath.replace(this.projectPath, "../"), "yosys.script");
        } else {
            command.add(this.openfpgaVendor.getBinaryPath(1)).add("-s").add("{{1}}{{2}}", this.scriptPath.replace(this.projectPath, "../"), "yosys.script");
        }
        ProcessBuilder stage = new ProcessBuilder(command.get());
        stage.directory(new File(this.sandboxPath));
        return stage;
    }

    private ProcessBuilder stageNextpnrEcp5() {
        LineBuffer command = LineBuffer.getBuffer();
        command.add(this.openfpgaVendor.getBinaryPath(2)).add("--{{1}}", this.boardInfo.fpga.getPart()).add("--package").add(this.boardInfo.fpga.getPackage().toUpperCase()).add("--json").add("toplevel.json").add("--lpf").add("{{1}}{{2}}", this.scriptPath.replace(this.projectPath, "../"), "toplevel.lpf").add("--textcfg").add("toplevel.config");
        ProcessBuilder stage = new ProcessBuilder(command.get());
        stage.directory(new File(this.sandboxPath));
        return stage;
    }

    private ProcessBuilder stageEcppack() {
        LineBuffer command = LineBuffer.getBuffer();
        command.add(this.openfpgaVendor.getBinaryPath(3)).add("--compress").add("--freq").add("62.0").add("--input").add("toplevel.config").add("--bit").add("toplevel.bit");
        ProcessBuilder stage = new ProcessBuilder(command.get());
        stage.directory(new File(this.sandboxPath));
        return stage;
    }
}

