/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.designrulecheck;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.Splitter;
import com.cburch.logisim.circuit.Wire;
import com.cburch.logisim.instance.InstanceComponent;
import java.util.HashSet;
import java.util.Set;

public class SimpleDrcContainer {
    public static final int LEVEL_NORMAL = 1;
    public static final int LEVEL_SEVERE = 2;
    public static final int LEVEL_FATAL = 3;
    public static final int MARK_NONE = 0;
    public static final int MARK_INSTANCE = 1;
    public static final int MARK_LABEL = 2;
    public static final int MARK_WIRE = 4;
    private final String message;
    private final int severityLevel;
    private Set<Object> drcComponents;
    private Circuit myCircuit;
    private final int markType;
    private int listNumber;
    private final boolean suppressCount;

    public SimpleDrcContainer(String message, int level) {
        this.message = message;
        this.severityLevel = level;
        this.markType = 0;
        this.listNumber = 0;
        this.suppressCount = false;
    }

    public SimpleDrcContainer(String message, int level, boolean supressCount) {
        this.message = message;
        this.severityLevel = level;
        this.markType = 0;
        this.listNumber = 0;
        this.suppressCount = supressCount;
    }

    public SimpleDrcContainer(Object message, int level) {
        this.message = message.toString();
        this.severityLevel = level;
        this.markType = 0;
        this.listNumber = 0;
        this.suppressCount = false;
    }

    public SimpleDrcContainer(Object message, int level, boolean supressCount) {
        this.message = message.toString();
        this.severityLevel = level;
        this.markType = 0;
        this.listNumber = 0;
        this.suppressCount = supressCount;
    }

    public SimpleDrcContainer(Circuit circ, Object message, int level, int markMask) {
        this.message = message.toString();
        this.severityLevel = level;
        this.myCircuit = circ;
        this.markType = markMask;
        this.listNumber = 0;
        this.suppressCount = false;
    }

    public SimpleDrcContainer(Circuit circ, Object message, int level, int markMask, boolean supressCount) {
        this.message = message.toString();
        this.severityLevel = level;
        this.myCircuit = circ;
        this.markType = markMask;
        this.listNumber = 0;
        this.suppressCount = supressCount;
    }

    public String toString() {
        return this.message;
    }

    public int getSeverity() {
        return this.severityLevel;
    }

    public boolean isDrcInfoPresent() {
        if (this.drcComponents == null || this.myCircuit == null) {
            return false;
        }
        return !this.drcComponents.isEmpty();
    }

    public Circuit getCircuit() {
        return this.myCircuit;
    }

    public boolean hasCircuit() {
        return this.myCircuit != null;
    }

    public void addMarkComponent(Object comp) {
        if (this.drcComponents == null) {
            this.drcComponents = new HashSet<Object>();
        }
        this.drcComponents.add(comp);
    }

    public void addMarkComponents(Set<?> set) {
        if (this.drcComponents == null) {
            this.drcComponents = new HashSet<Object>();
        }
        this.drcComponents.addAll(set);
    }

    public void setListNumber(int number) {
        this.listNumber = number;
    }

    public boolean getSupressCount() {
        return this.suppressCount;
    }

    public int getListNumber() {
        return this.listNumber;
    }

    public void markComponents() {
        if (!this.isDrcInfoPresent()) {
            return;
        }
        for (Object obj : this.drcComponents) {
            if (obj instanceof Wire) {
                Wire wire = (Wire)obj;
                if ((this.markType & 4) == 0) continue;
                wire.setDrcHighlight(true);
                continue;
            }
            if (obj instanceof Splitter) {
                Splitter split = (Splitter)obj;
                if ((this.markType & 1) == 0) continue;
                split.setMarked(true);
                continue;
            }
            if (!(obj instanceof InstanceComponent)) continue;
            InstanceComponent comp = (InstanceComponent)obj;
            if ((this.markType & 1) != 0) {
                comp.markInstance();
            }
            if ((this.markType & 2) == 0) continue;
            comp.markLabel();
        }
    }

    public void clearMarks() {
        if (!this.isDrcInfoPresent()) {
            return;
        }
        for (Object obj : this.drcComponents) {
            if (obj instanceof Wire) {
                Wire wire = (Wire)obj;
                if ((this.markType & 4) == 0) continue;
                wire.setDrcHighlight(false);
                continue;
            }
            if (obj instanceof Splitter) {
                Splitter split = (Splitter)obj;
                if ((this.markType & 1) == 0) continue;
                split.setMarked(false);
                continue;
            }
            if (!(obj instanceof InstanceComponent)) continue;
            InstanceComponent comp = (InstanceComponent)obj;
            comp.clearMarks();
        }
    }
}

